/***************************************************************************
FILE: lsr.cpp
PURPOSE: Shift 1 bit right (memory or accumulator)
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x4A
//LSR A
//Bytes 1
//Cycles 2
void lsr_accum()
{
	PC++;
	if(P.M==1)
	{
		Byte B;

		B=A&0xFF;
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		A=B|(A&0xFF00);
		P.N=0;
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		if(A&0x01) P.C=1; else P.C=0;
		A=A>>1;
		P.N=0;
		if(A==0) P.Z=1; else P.Z=0;
	}
	t+=2;
}

//0x46
//LSR d
//Bytes 2
//Cycles 5
void lsr_d()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		P.N=0;
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		P.N=0;
		if(W==0) P.Z=1; else P.Z=0;
	}
	t+=5;
}

//0x56
//LSR d,x
//Bytes 2
//Cycles 6
void lsr_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		P.N=0;
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		P.N=0;
		if(W==0) P.Z=1; else P.Z=0;
	}
	t+=6;
}

//0x4E
//LSR a
//Bytes 3
//Cycles 6
void lsr_a()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		P.N=0;
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		P.N=0;
		if(W==0) P.Z=1; else P.Z=0;
	}
	t+=6;
}

//0x5E
//LSR a,x
//Bytes 3
//Cycles 7
void lsr_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		P.N=0;
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		P.N=0;
		if(W==0) P.Z=1; else P.Z=0;
	}
	t+=7;
}