/***************************************************************************
FILE: misc.cpp
PURPOSE: Misc functions for use by the opcodes
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

void debug()
{
 int stoptime=clock();
  printf("???\nUnimplemented Opcode encountered (0x%x) at %x:%x\n",SNESgetbyte(PC,PB),PB,PC);
  printf("  Flags:  N:%i V:%i M:%i X:%i D:%i I:%i Z:%i C:%i E:%i\n",P.N,P.V,P.M,P.X,P.D,P.I,P.Z,P.C,P.E);
  printf("  Regs:   A: $%04x D: $%04x X: $%04x Y: $%04x\n",A,D,X,Y);
  printf("  Regs:   PB:  $%02x PC:$%04x DB:  $%02x S: $%04x\n",PB,PC,DB,S);
  printf("  Machine cycles elapsed: %i\n",t+totalt);
  if (stoptime!=0)
    printf("  Clock cycles elapsed:  %i\n  Speed (Instr/S): %i\n",stoptime,(t+totalt)/stoptime*CLOCKS_PER_SEC);
  else
    printf("  Clock cycles elapsed:  0\n  Approx speed (instr/s): >%i\n",(t+totalt)*CLOCKS_PER_SEC);
}

//These are my stack routines

void pushb(Byte data)
{
 long int location;
 MemType typ;
 SnesMap(S, 0, &typ,&location);
 SNESsetbyte(typ,location,data);
 S--;
}

void pushw(Word data)
{
 long int location;
 MemType typ;
 SnesMap(S, 0, &typ,&location);
 SNESsetword(typ,location,data);
 S-=2;
}

Byte pullb()
{
 Byte tmp;

 S++;
 tmp=SNESgetbyte(S,0);
 return tmp;
}

Word pullw()
{
 Word tmp;
 S+=2;
 tmp=SNESgetword(S,0);
 return tmp;
}


//special functions

void nil()
{}

void DoNMI()       //Not really an opcode, but I need access to stack routines.
{
 pushb(PB);
 pushw(PC);
 pushw(A);
 pushw(X);
 pushw(Y);
 pushw(D);
 pushb(DB);
 php();
 PC=SNESgetword(0xFFFA,0);        //This is somewhat odd.  Sometimes == 0?
 PB=0;
 t=0;
}

//thess are the addressing mode families.

 Byte family1b()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 1:      //direct indexed indirect
        return direct_indexed_indirVb();
   case 3:      //stack relative
        debug();
        break;
   case 5:      //direct
        return directVb();
   case 7:      //direct indirect long
        return direct_indir_longVb();
   case 9:      //immediate
        return SNESgetbyte(PC++,PB);
   case 0xd:    //absolute
        return absoluteVb();
   case 0xf:    //absolute
        return absolute_longVb();
   case 0x11:   //direct Indirect indexed
        return direct_indir_indexed_yVb();
   case 0x12:   //direct indirect
        return direct_indirVb();
   case 0x13:   //stack relative indirect indexed
        debug();
        break;
   case 0x15:   //direct indexed x
        return direct_indexed_xVb();
   case 0x17:   //direct indirect indexed long
        debug();
        break;
   case 0x19:   //absolute indexed (y)
        return absolute_YindexedVb();
   case 0x1D:
        return absolute_XindexedVb();
   case 0x1F:   //absolute indexed long
        return absolute_long_indexedVb();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Word family1w()
{
 Byte optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 1:      //direct indexed indirect
        return direct_indexed_indirVw();
   case 3:      //stack relative
        debug();
        break;
   case 5:      //direct
        return directVw();
   case 7:      //direct indirect long
        return direct_indir_longVw();
   case 9:      //immediate
        return SNESgetword(PC=+2,PB);
   case 0xd:    //absolute
        return absoluteVw();
   case 0xf:    //absolute
        return absolute_longVw();
   case 0x11:   //direct Indirect indexed
        return direct_indir_indexed_yVw();
   case 0x12:   //direct indirect
        return direct_indirVw();
   case 0x13:   //stack relative indirect indexed
        debug();
        break;
   case 0x15:   //direct indexed x
        return direct_indexed_xVw();
   case 0x17:   //direct indirect indexed long
        debug();
        break;
   case 0x19:   //absolute indexed (y)
        return absolute_YindexedVw();
   case 0x1D:
        return absolute_XindexedVw();
   case 0x1F:   //absolute indexed long
        return absolute_long_indexedVw();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Double family1a()
{
 unsigned char optest;
 unsigned long int tmp;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 1:      //direct indexed indirect
        return direct_indexed_indir();
   case 3:      //stack relative
        debug();
        break;
   case 5:      //direct
        return direct();
   case 7:      //direct indirect long
        return direct_indir_long();
   case 9:      //immediate
        tmp=PC;
        PC+=2;
        return tmp;
   case 0xd:    //absolute
        return absolute();
   case 0xf:    //absolute
        return absolute_long();
   case 0x11:   //direct Indirect indexed
        return direct_indir_indexed_y();
   case 0x12:   //direct indirect
        return direct_indir();
   case 0x13:   //stack relative indirect indexed
        debug();
        break;
   case 0x15:   //direct indexed x
        return direct_indexed_x();
   case 0x17:   //direct indirect indexed long
        debug();
        break;
   case 0x19:   //absolute indexed (y)
        return absolute_Yindexed();
   case 0x1D:
        return absolute_Xindexed();
   case 0x1F:   //absolute indexed long
        return absolute_long_indexed();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Byte family2b()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 2:
        return SNESgetbyte(PC++,PB);
   case 6:    //direct
        return directVb();
   case 0xE:  //Absolute
        return absoluteVb();
   case 0x16: //direct indexed (y)
        return direct_indexed_yVb();
   case 0x1E: //absolute indexed (y)
        return absolute_YindexedVb();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Word family2w()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 2:
        PC+=2;
        return SNESgetword(PC-2,PB);
   case 6:    //direct
        return directVw();
   case 0xE:  //Absolute
        return absoluteVw();
   case 0x16: //direct indexed (y)
        return direct_indexed_yVw();
   case 0x1E: //absolute indexed (y)
        return absolute_YindexedVw();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Double family2a()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 2:
        return SNESgetbyte(PC++,PB);
   case 6:    //direct
        return direct();
   case 0xE:  //Absolute
        return absolute();
   case 0x16: //direct indexed (y)
        return direct_indexed_y();
   case 0x1E: //absolute indexed (y)
        return absolute_Yindexed();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Byte family3b()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 0:    //immediate
        return SNESgetbyte(PC++,PB);
   case 4:    //direct
        return directVb();
   case 0xC:  //absolute
        return absoluteVb();
   case 0x14: //direct indexed x
        return direct_indexed_xVb();
   case 0x1C: //absolute indexed (x)
        return absolute_XindexedVb();
 }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Word family3w()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 0:    //immediate
        PC+=2;
        return SNESgetword(PC-2,PB);
   case 4:    //direct
        return directVw();
   case 0xC:  //absolute
        return absoluteVw();
   case 0x14: //direct indexed x
        return direct_indexed_xVw();
   case 0x1C: //absolute indexed (X)
        return absolute_XindexedVw();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

 Double family3a()
{
 unsigned char optest;
 optest=SNESgetbyte(PC,PB)&0x1F;
 PC++;
 switch (optest) {
   case 0:    //immediate
        debug();
        break;
   case 4:    //direct
        return direct();
   case 0xC:  //absolute
        return absolute();
   case 0x14: //direct indexed x
        return direct_indexed_x();
   case 0x1C: //Absolute indexed (x)
        return absolute_Xindexed();
   }
 puts("I don't know what to do cap'n!");
 PC--;
 debug();
 return 0;
}

