#ifndef __OPCODES_H_
#define __OPCODES_H_

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include "..\SNESstructures.h"
#include "..\SNESmemory.h"
#include "..\65c816.h"
#include "..\SNESregisters.h"
#include "..\AddressingModes.h"


void pushb(Byte data);
void pushw(Word data);
Byte pullb();
Word pullw();
 Byte family1b();
 Word family1w();
 Double family1a();
 Byte family2b();
 Word family2w();
 Double family2a();
 Byte family3b();
 Word family3w();
 Double family3a();



 void debug ();
 void rep();
 void sep();
 void jsr_a();
 void jsl_al();
 void rts();
 void jmp_al();
 void stp();
 void xba();
 void wdm();
 void rti();

 void DoNMI();

void adc_im();			//0x69 ADC #
void adc_d();			//0x65 ADC d
void adc_d_ix_x();		//0x75 ADC d,x
void adc_d_in();		//0x72 ADC (d)
void adc_d_ix_in();		//0x61 ADC (d,x)
void adc_d_in_ix();		//0x71 ADC (d),y
void adc_d_in_l();		//0x67 ADC [d]
void adc_a();			//0x6D ADC a
void adc_a_ix_x();		//0x7D ADC a,x
void adc_a_ix_y();		//0x79 ADC a,y
void adc_al();			//0x6F ADC al
void adc_a_l_ix_x();	//0x7F ADC al,x
void adc_s_r();			//0x63 ADC d,s
void adc_s_r_in_ix();	//0x73 ADC (d,s),y

void and_im();			//0x29 AND #
void and_d();			//0x25 AND d
void and_d_ix_x();		//0x35 AND d,x
void and_d_in();		//0x32 AND (d)
void and_d_ix_in();		//0x21 AND (d,x)
void and_d_in_ix();		//0x31 AND (d),y
void and_d_in_l();		//0x27 AND [d]
void and_a();			//0x2D AND a
void and_a_ix_x();		//0x3D AND a,x
void and_a_ix_y();		//0x39 AND a,y
void and_al();			//0x2F AND al
void and_a_l_ix_x();	//0x3F AND al,x
void and_s_r();			//0x23 AND d,s
void and_s_r_in_ix();	//0x33 AND (d,s),y

void asl_accum();		//0x0A ASL A
void asl_d();			//0x06 ASL d
void asl_d_ix_x();		//0x16 ASL d,x
void asl_a();			//0x0E ASL a
void asl_a_ix_x();		//0x1E ASL a,x

void bcc();				//0x90 BCC
void bcs();				//0xB0 BCS
void beq();				//0xF0 BEQ
void bit_im();			//0x89 BIT #
void bit_d();			//0x24 BIT d
void bit_d_ix_x();		//0x34 BIT d,x
void bit_a();			//0x2C BIT a
void bit_a_ix_x();		//0x3C BIT a,x
void bmi();				//0x30 BMI
void bne();				//0xD0 BNE
void bpl();				//0x10 BPL
void bra();				//0x80 BRA
void bvc();				//0x50 BVC
void bvs();				//0x70 BVS

void clc();				//0x18 CLC
void cld();				//0xD8 CLD
void cli();				//0x58 CLI
void clv();				//0xB8 CLV
void cmp_im();			//0xC9 CMP #
void cmp_d();			//0xC5 CMP d
void cmp_d_ix_x();		//0xD5 CMP d,x
void cmp_d_in();		//0xD2 CMP (d)
void cmp_d_ix_in();		//0xC1 CMP (d,x)
void cmp_d_in_ix();		//0xD1 CMP (d),y
void cmp_d_in_l();		//0xC7 CMP [d]
void cmp_a();			//0xCD CMP a
void cmp_a_ix_x();		//0xDD CMP a,x
void cmp_a_ix_y();		//0xD9 CMP a,y
void cmp_al();			//0xCF CMP al
void cmp_a_l_ix_x();	//0xDF CMP al,x
void cmp_s_r();			//0xC3 CMP d,s
void cmp_s_r_in_ix();	//0xD3 CMP (d,s),y

void cpx_im();			//0xE0 CPX #
void cpx_d();			//0xE4 CPX d
void cpx_a();			//0xEC CPX a

void cpy_im();			//0xE0 CPX #
void cpy_d();			//0xE4 CPX d
void cpy_a();			//0xEC CPX a

void dec_accum();		//0x3A DEC A
void dec_d();			//0xC6 DEC d
void dec_d_ix_x();		//0xD6 DEC d,x
void dec_a();			//0xCE DEC a
void dec_a_ix_x();		//0xDE DEC a,x
void dex();				//0xCA DEX
void dey();				//0x88 DEY

void eor_im();			//0x49 EOR #
void eor_d();			//0x45 EOR d
void eor_d_ix_x();		//0x55 EOR d,x
void eor_d_in();		//0x52 EOR (d)
void eor_d_ix_in();		//0x41 EOR (d,x)
void eor_d_in_ix();		//0x51 EOR (d),y
void eor_d_in_l();		//0x47 EOR [d]
void eor_a();			//0x4D EOR a
void eor_a_ix_x();		//0x5D EOR a,x
void eor_a_ix_y();		//0x59 EOR a,y
void eor_al();			//0x4F EOR al
void eor_a_l_ix_x();	//0x5F EOR al,x
void eor_s_r();			//0x43 EOR d,s
void eor_s_r_in_ix();	//0x53 EOR (d,s),y

void inc_accum();		//0x1A INC A
void inc_d();			//0xE6 INC d
void inc_d_ix_x();		//0xF6 INC d,x
void inc_a();			//0xEE INC a
void inc_a_ix_x();		//0xFE INC a,x
void inx();				//0xE8 INX
void iny();				//0xC8 INY

void lda_im();			//0xA9 LDA #
void lda_d();			//0xA5 LDA d
void lda_d_ix_x();		//0xB5 LDA d,x
void lda_d_in();		//0xB2 LDA (d)
void lda_d_ix_in();		//0xA1 LDA (d,x)
void lda_d_in_ix();		//0xB1 LDA (d),y
void lda_d_in_ix_l();	//0xB7 LDA [d],y
void lda_a();			//0xAD LDA a
void lda_a_ix_x();		//0xBD LDA a,x
void lda_a_ix_y();		//0xB9 LDA a,y
void lda_al();			//0xAF LDA al
void lda_a_l_ix_x();	//0xBF LDA al,x
void lda_s_r();			//0xA3 LDA d,s
void lda_s_r_in_ix();	//0xB3 LDA (d,s),y

void ldx_im();			//0xA2 LDX #
void ldx_d();			//0xA6 LDX d
void ldx_d_ix_y();		//0xB6 LDX d,y
void ldx_a();			//0xAE LDX a
void ldx_a_ix_y();		//0xBE LDX a,y

void ldy_im();			//0xA0 LDY #
void ldy_d();			//0xA4 LDY d
void ldy_d_ix_x();		//0xB4 LDY d,x
void ldy_a();			//0xAC LDY a
void ldy_a_ix_x();		//0xBC LDY a,x

void lsr_accum();		//0x4A LSR A
void lsr_d();			//0x46 LSR d
void lsr_d_ix_x();		//0x56 LSR d,x
void lsr_a();			//0x4E LSR a
void lsr_a_ix_x();		//0x5E LSR a,x

void nop();				//0xEA NOP

void ora_im();			//0x09 ORA #
void ora_d();			//0x05 ORA d
void ora_d_ix_x();		//0x15 ORA d,x
void ora_d_in();		//0x12 ORA (d)
void ora_d_ix_in();		//0x01 ORA (d,x)
void ora_d_in_ix();		//0x11 ORA (d),y
void ora_d_in_ix_l();	//0x17 ORA [d],y
void ora_a();			//0x0D ORA a
void ora_a_ix_x();		//0x1D ORA a,x
void ora_a_ix_y();		//0x19 ORA a,y
void ora_al();			//0x0F ORA al
void ora_a_l_ix_x();	//0x1F ORA al,x
void ora_s_r();			//0x03 ORA d,s
void ora_s_r_in_ix();	//0x13 ORA (d,s),y

void pea();				//0xF4 PEA
void pei();				//0xD4 PEI
void per();				//0x62 PER
void pha();				//0x48 PHA
void phb();				//0x8B PHB
void phd();				//0x0B PHD
void phk();				//0x4B PHK
void php();				//0x08 PHP
void phx();				//0xDA PHX
void phy();				//0x5A PHY
void pla();				//0x6B PLA
void plb();				//0xAB PLB
void pld();				//0x2B PLD
void plp();				//0x28 PLP
void plx();				//0xFA PLX
void ply();				//0x7A PLY

void rol_accum();		//0x2A ROL A
void rol_d();			//0x26 ROL d
void rol_d_ix_x();		//0x36 ROL d,x
void rol_a();			//0x2E ROL a
void rol_a_ix_x();		//0x3E ROL a,x

void ror_accum();		//0x6A ROR A
void ror_d();			//0x66 ROR d
void ror_d_ix_x();		//0x76 ROR d,x
void ror_a();			//0x6E ROR a
void ror_a_ix_x();		//0x7E ROR a,x

void sbc_im();			//0xE9 SBC #
void sbc_d();			//0xE5 SBC d
void sbc_d_ix_x();		//0xF5 SBC d,x
void sbc_d_in();		//0xF2 SBC (d)
void sbc_d_ix_in();		//0xE1 SBC (d,x)
void sbc_d_in_ix();		//0xF1 SBC (d),y
void sbc_d_in_ix_l();	//0xF7 SBC [d],y
void sbc_a();			//0xED SBC a
void sbc_a_ix_x();		//0xFD SBC a,x
void sbc_a_ix_y();		//0xF9 SBC a,y
void sbc_al();			//0xEF SBC al
void sbc_a_l_ix_x();	//0xFF SBC al,x
void sbc_s_r();			//0xE3 SBC d,s
void sbc_s_r_in_ix();	//0xF3 SBC (d,s),y

void sec();				//0x38 SEC
void sed();				//0xF8 SED
void sei();				//0x78 SEI

void sta_d();			//0x85 STA d
void sta_d_ix_x();		//0x95 STA d,x
void sta_d_in();		//0x92 STA (d)
void sta_d_ix_in();		//0x81 STA (d,x)
void sta_d_in_ix();		//0x91 STA (d),y
void sta_d_in_ix_l();	//0x97 STA [d],y
void sta_a();			//0x8D STA a
void sta_a_ix_x();		//0x9D STA a,x
void sta_a_ix_y();		//0x99 STA a,y
void sta_al();			//0x8F STA al
void sta_a_l_ix_x();	//0x9F STA al,x
void sta_s_r();			//0x83 STA d,s
void sta_s_r_in_ix();	//0x93 STA (d,s),y

void stx_d();			//0x86 STX d
void stx_d_ix_y();		//0x96 STX d,y
void stx_a();			//0x8E STX a

void sty_d();			//0x84 STY d
void sty_d_ix_y();		//0x94 STY d,x
void sty_a();			//0x8C STY a

void stz_d();			//0x64 STZ d
void stz_d_ix_y();		//0x74 STZ d,x
void stz_a();			//0x9C STZ a

void tax();				//0xAA TAX
void tay();				//0xA8 TAY
void tcd();				//0x5B TCD
void tcs();				//0x1B TCS
void tdc();				//0x7B TDC
void trb_d();			//0x14 TRB d
void trb_a();			//0x1C TRB a
void tsc();				//0x3B TSC
void tsx();				//0xBA TSX
void txa();				//0x8A TXA
void txs();				//0x9A TXS
void txy();				//0x9B TXY
void tya();				//0x98 TYA
void tyx();				//0xBB TYX

void tsb_d();			//0x04 TSB d
void tsb_a();			//0x0C TSB a

void xce();				//0xFB XCE
#endif