/***************************************************************************
FILE: rol.cpp
PURPOSE: Rotate one bit left
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x2A
//ROL A
//Bytes 1
//Cycles 2
void rol_accum()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;

		B=(Byte)A&0xFF;
		if(P.C==1) tempPC=1; else tempPC=0;
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		B|=tempPC;
		A=B|(A&0xFF00);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Byte tempPC;
				
		if(P.C==1) tempPC=1; else tempPC=0;
		if(A&0x8000) P.C=1; else P.C=0;
		A=A<<1;
		A|=tempPC;
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0x26
//ROL d
//Bytes 2
//Cycles 5
void rol_d()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		B|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		W|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x36
//ROL d,x
//Bytes 2
//Cycles 6
void rol_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		B|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		W|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x2E
//ROL a
//Bytes 3
//Cycles 6
void rol_a()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		B|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		W|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x3E
//ROL a,x
//Bytes 3
//Cycles 7
void rol_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		B|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) tempPC=1; else tempPC=0;
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		W|=tempPC;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}