/***************************************************************************
FILE: sbc.cpp
PURPOSE: Subtract memory from accumulator with borrow
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"


//0xE9
//SBC #
//Bytes 2
//Cycles 2
void sbc_im()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=immediateVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=immediateVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=2;
}

//0xE5
//SBC d
//Bytes 2
//Cycles 3
void sbc_d()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=directVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=directVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=3;
}

//0xF5
//SBC d,x
//Bytes 2
//Cycles 4
void sbc_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indexed_xVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=direct_indexed_xVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=4;
}

//0xF2
//SBC (d)
//Bytes 2
//Cycles 5
void sbc_d_in()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indirVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=direct_indirVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=5;
}

//0xE1
//SBC (d,x)
//Bytes 2
//Cycles 6
void sbc_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indexed_indirVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=direct_indexed_indirVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=6;
}

//0xF1
//SBC (d),y
//Bytes 2
//Cycles 5
void sbc_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indir_indexed_yVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=direct_indir_indexed_yVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=5;
}

//0xF7
//SBC [d],y
//Bytes 2
//Cycles 6
void sbc_d_in_ix_l()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=dir_indir_indexed_longVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=dir_indir_indexed_longVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=6;
}

//0xED
//SBC a
//Bytes 3
//Cycles 4
void sbc_a()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absoluteVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=absoluteVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=4;
}

//0xFD
//SBC a,x
//Bytes 3
//Cycles 4
void sbc_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_XindexedVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=absolute_XindexedVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=4;
}

//0xF9
//SBC a,y
//Bytes 3
//Cycles 4
void sbc_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_YindexedVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=absolute_YindexedVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=4;
}

//0xEF
//SBC al
//Bytes 4
//Cycles 5
void sbc_al()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_longVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=absolute_longVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=5;
}

//0xFF
//SBC al,x
//Bytes 4
//Cycles 5
void sbc_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_long_indexedVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=absolute_long_indexedVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=5;
}

//0xE3
//SBC d,s
//Bytes 2
//Cycles 4
void sbc_s_r()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=stack_relativeVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=stack_relativeVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=4;
}

//0xF3
//SBC (d,s),y
//Bytes 2
//Cycles 7
void sbc_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=stack_relative_indir_indexedVb();
		result=(A&0xFF)-B-P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result&0xFF==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if(A&0x80==B&0x80)
		{
			if(A&0x80!=result&0x80) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFF)|(A&0xFF00);
	}
	else
	{
		Double result;
		Word W;

		W=stack_relative_indir_indexedVw();
		result=A-W-P.C;
		if(result>0xFFFF) P.C=1; else P.C=0;
		if(result&0xFFFF==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if(A&0x8000==W&0x8000)
		{
			if(A&0x8000!=result&0x8000) P.V=1; else P.V=0;
		}else P.V=0;
		A=(Word)(result&0xFFFF);
	}
	t+=7;
}