/***************************************************************************
FILE: stx.cpp
PURPOSE: Store index X in memory
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x86
//STX d
//Bytes 2
//Cycles 3
void stx_d()
{
	PC++;
	if(P.X==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(X&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,X);
	}
	t+=3;
}


//0x96
//STX d,y
//Bytes 2
//Cycles 4
void stx_d_ix_y()
{
	PC++;
	if(P.X==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_y();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(X&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_y();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,X);
	}
	t+=4;
}

//0x8E
//STX a
//Bytes 3
//Cycles 4
void stx_a()
{
	PC++;
	if(P.X==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(X&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,X);
	}
	t+=4;
}