/***************************************************************************
FILE: stz.cpp
PURPOSE: Store zero in memory
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x64
//STZ d
//Bytes 2
//Cycles 3
void stz_d()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,0x00);
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,0x0000);
	}
	t+=3;
}


//0x74
//STZ d,x
//Bytes 2
//Cycles 4
void stz_d_ix_y()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,0x00);
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,0x0000);
	}
	t+=4;
}

//0x9C
//STZ a
//Bytes 3
//Cycles 4
void stz_a()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,0x00);
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,0x0000);
	}
	t+=4;
}