/***************************************************************************
FILE: tsb.cpp
PURPOSE: Test and set bit
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x04
//TSB d
//Bytes 2
//Cycles 5
void tsb_d()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;
		Byte B;
		Byte al;

		addr=direct();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		al=(Byte)A&0xFF;
		B|=al;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;
		Word W;
	
		addr=direct();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		W|=A;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W==0) P.Z=1; else P.Z=0;
	}
	t+=5;
}


//0x0C
//TSB a
//Bytes 3
//Cycles 6
void tsb_a()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;
		Byte B;
		Byte al;

		addr=absolute();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		al=(Byte)A&0xFF;
		B|=al;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;
		Word W;
	
		addr=absolute();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		W|=A;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W==0) P.Z=1; else P.Z=0;
	}
	t+=6;
}