/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "keyboard.h"


keyboard::keyboard()
// Constructor 
{

}

void keyboard::init(ggi_visual_t *visual)
{

  my_visual = visual;  // receive the visual
  for(BYTE i=0; i<sizeof(keys_pressed); i++)
	{
	  keys_pressed[i]=0x00;  // no keys pressed to start with
	}  
}

keyboard::~keyboard()
// Destructor
{

}

void keyboard::release_all()
{
  // no deallocation necessary, since ggi handles it in the graphics deallocation
}

void keyboard::read_key_state()
// reads the status of all the keys on the keyboard and stores into keystate
{
  struct timeval t={0,0};
  ggi_event event;
  ggi_event_mask mask;
  BYTE value;

  while ((mask = ggiEventPoll(*my_visual, emKey, &t))) // if an event occurs
	{
	  ggiEventRead(*my_visual, &event, emKey);  // read the event
	  if ((event.any.type == evKeyPress)||(event.any.type==evKeyRepeat))
		{
		  value = 0x01;  // mark the key as pressed
		}
	  else if (event.any.type == evKeyRelease)
		{
		  value = 0x00; // mark the key as not pressed
		}

	  // now set the appropriate value in keys_pressed
	  switch(event.key.sym)
		{
		case GIIK_Up:
		  keys_pressed[1] = value;
		  break;
		  
		case GIIK_Down:
		  keys_pressed[2] = value;
		  break;

		case GIIK_Left:
		  keys_pressed[3] = value;
		  break;
		  
		case GIIK_Right:
		  keys_pressed[4] = value;
		  break;

		case GIIK_PageUp:
		  keys_pressed[5] = value;
		  break;

		case GIIK_PageDown:
		  keys_pressed[6] = value;
		  break;

		case GIIK_Home:
		  keys_pressed[7] = value;
		  break;

		case GIIK_End:
		  keys_pressed[8] = value;
		  break;

		case GIIUC_Escape:
		  keys_pressed[9] = value;
		  break;

		case GIIUC_Space:
		  keys_pressed[10] = value;
		  break;

		case GIIUC_Period:
		  keys_pressed[11] = value;
		  break;

		case GIIUC_Slash: // '/'
		  keys_pressed[12] = value;
		  break;

		case GIIUC_BracketLeft: // '['
		  keys_pressed[13] = value;
		  break;

		case GIIUC_BracketRight: // ']'
		  keys_pressed[14] = value;
		  break;

		case GIIK_F1:
		  keys_pressed[15] = value;
		  break;

		default:
		  printf("unrecognized key presse\n");
		  break;
		}
	}
}

BYTE keyboard::key_pressed(BYTE key)
  // returns 0 unless the requested key has been pressed
{

  return keys_pressed[key];
}
