#if !defined(Cmapper0)
#define Cmapper0

#include "data_types.h"
#include "generic_ram.h"
#include "mapper.h"

class mapper0 : public mapper
{
public:
	mapper0(generic_ram* rom, generic_ram* vrom, generic_ram* sram, long int rom_size);	// constructor
	~mapper0();												// destructor		
	BYTE read_byte(WORD address);							// read a byte from bus
	void write_byte(WORD address, BYTE value);	// write byte to bus

private:
	long int prg_size;			// the size of the ROM in cartridge
	generic_ram *my_prg_rom;	// The ROM inside the cartridge
	generic_ram *my_chr_vrom;	// the VROM inside the cartridge
	generic_ram *my_sram;		// the SRAM (save RAM) inside cartridge
};


#endif //Cmapper0