#if !defined(Cmapper2)
#define Cmapper2

#include "data_types.h"
#include "generic_ram.h"
#include "mapper.h"

class mapper2 : public mapper
{
public:
	mapper2(generic_ram* rom, generic_ram* vrom, generic_ram* sram, long int rom_size);	// constructor
	~mapper2();												// destructor		
	BYTE read_byte(WORD address);							// read a byte from bus
	void write_byte(WORD address, BYTE value);	// write byte to bus

private:
	long int prg_size;			// the size of the ROM in cartridge
	generic_ram *my_prg_rom;	// The ROM inside the cartridge
	generic_ram *my_chr_vrom;	// the VROM inside the cartridge
	generic_ram *my_sram;		// the SRAM (save RAM) inside cartridge
	BYTE bank_select_reg;		// holds the bank number
	WORD low_bank_pointer;			// points to where 0x8000 is mapped
	long int high_bank_pointer;			// points to where 0xC000 is mapped
};


#endif //Cmapper2