// emuschool.h : main header file for the EMUSCHOOL application
//

#if !defined(EMUSCHOOL_H)
#define EMUSCHOOL_H

//#include <ggi/ggi.h>  // needed for ggi graphics and input
#include "data_types.h"
#include "generic_ram.h"
#include "mapper.h"
#include "mapper0.h"
#include "mapper2.h"
#include "ppu.h"
#include "mem_bus.h"
#include "cpu.h"
#include "graphics.h"
#include "input.h"
#include "gamepad.h"

// global variables
ggi_visual_t visual_ggi;  // ggi visual, this is ggi specific
//ggi_event event_ggi;  // ggi event object, this is ggi specific
graphics my_screen; // the screen to draw the graphics on
input my_input;	// the input object, talks to keyboard and joysticks

BYTE emulator_running;	// flag to indicate the emulator should be running
long int clock_cycles;		// number of 6502 clock cycles that have passed
unsigned int scan_line;		// the number of the current scan line;
ROM_header my_header;		// the ROM file header structure
generic_ram my_prg_rom;		// prg ROM device
generic_ram my_chr_vrom;	// chr VROM device
generic_ram my_sram;		// create SRAM device	
generic_ram my_ram;		// create a 2 KB memory object for internal RAM
generic_ram my_vram;		// video ram for ppu
gamepad my_gamepad1;		// create joystick1 object
gamepad my_gamepad2;		// create joystick2 object
mapper* my_mapper;			// pointer to a mapper object
PPU my_ppu;					// picture processing unit
mem_bus my_bus;
CPU my_cpu;

#endif // !defined(EMUSCHOOL_H)
