/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "input.h"
#include "data_types.h"

input::input()
// Constructor 
{
}

void input::init(ggi_visual_t *my_visual)
{
	my_keyboard.init(my_visual);

}

input::~input()
// Destructor
{
	
}

void input::release_all()
{
  my_keyboard.release_all();	
}

void input::read_keyboard_state()
{
	my_keyboard.read_key_state();
}

BYTE input::key_pressed(BYTE key)
// returns 1 if key is pressed, 0 if not
{
	return my_keyboard.key_pressed(key);
}

BYTE input::read_gamepad(BYTE pad_number, BYTE button_number)
// read from a gamepad
// button_number is defined as follows:
// 1 = A, 2 = B, 3 = SELECT, 4 = START, 5 = UP, 6 = DOWN, 7 = LEFT, 8 = RIGHT
{


  // for now gamepad 1 is assumed, and keyboard input is assumed
  switch (button_number)
	{
	case 1:
	  if (my_keyboard.key_pressed(KEY_PERIOD))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;

	case 2:
	  if (my_keyboard.key_pressed(KEY_SLASH))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;

	case 3:
	  if (my_keyboard.key_pressed(KEY_BRACKET_LEFT))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;
	  
	case 4:
	  if (my_keyboard.key_pressed(KEY_BRACKET_RIGHT))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;

	case 5:
	  if (my_keyboard.key_pressed(KEY_UP))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;
	  
	case 6:
	  if (my_keyboard.key_pressed(KEY_DOWN))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;
	  
	case 7:
	  if (my_keyboard.key_pressed(KEY_LEFT))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;

	case 8:
	  if (my_keyboard.key_pressed(KEY_RIGHT))
		{
		  return 0x41;
		}
	  else
		{
		  return 0x40;
		}
	  break;

	default:
	  printf("Illegal read of joystick\n");
	  return 0x00;
	  break;
	}  
}
