/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "mapper2.h"


mapper2::mapper2(generic_ram* rom, generic_ram* vrom, generic_ram* sram, long int rom_size) : mapper(rom, vrom, sram)
// Constructor 
// The memory bus must have a pointer to all the peripherals it will interface to
{
	my_prg_rom = rom;		// assign the pointer to program ROM
	my_chr_vrom = vrom;		// Video ROM
	my_sram = sram;			// battery backed ram
	prg_size = rom_size;	// the size of the program ROM (in bytes)
	bank_select_reg = 0x00;	// 0x8000 points to the first 16KB bank
	low_bank_pointer = 0x0000;
	high_bank_pointer = (prg_size - 0x4000);	// points to last 16KB bank
}

mapper2::~mapper2()
// Destructor
{
	my_prg_rom = NULL;		// unassign pointer to ROM
	my_chr_vrom = NULL;		// unassign pointer to Video ROM
	my_sram = NULL;		// unassign pointer to SRAM
}


BYTE mapper2::read_byte(WORD address)
// Read a byte from the memory bus
// This function must determine which device to read from, then perform the read
{
	if ((address >= 0x8000)&&(address < 0xC000))		// then it's in the low bank
	{
		return my_prg_rom->read_byte( (address-0x8000) + low_bank_pointer );	// read from prg ROM
	}
	else if ((address >= 0xC000)&&(address <= 0xFFFF))		// then it's in the high bank
	{
		return my_prg_rom->read_byte( (address-0x8000) + high_bank_pointer );	// read from prg ROM
	}	

	else if (address < 0x2000)		// note this is in the ppu address space, not cpu
	{
		return my_chr_vrom->read_byte(address);	// read from VROM
	}

	return 0x00;		// in case something goes wrong

}

void mapper2::write_byte(WORD address, BYTE value)
// Write byte to bus
// This function must determine which device to write to, then perform the write
{
	//can't write to ROM
	if ((address >= 0x8000) && (address <= 0xFFFF))		// then it is a write to bank select register
	{
		if (bank_select_reg != value)	// then update the bank select register
		{
			bank_select_reg = value;
			low_bank_pointer = 0x4000 * bank_select_reg;	// 16Kb * bank_num
		}

	}
}
