#if !defined(Cppu)
#define Cppu

#include "data_types.h"
#include "generic_ram.h"
#include "graphics.h"
#include "mapper.h"
#include "tile.h"

class PPU
{
public:
	PPU();
	PPU(generic_ram* ram, BYTE mirroring, mapper* map, graphics* vid_screen);	// constructor
	~PPU();						// destructor		
	void set_values(generic_ram* ppu_ram, generic_ram* ppu_vram, BYTE mirroring, mapper* map, graphics* vid_screen);
	void start_vblank();
	void end_vblank();
	BYTE read_byte(WORD address);				// read a byte from ppu
	void write_byte(WORD address, BYTE value);	// write byte to ppu	
	void display_pattern_table();	// show the pattern table
	void display_palette();			// show the palette
	
private:	
	tile my_table_low[256];		// the 256 tiles in the pattern table at address 0x0000
	tile my_table_high[256];		// the 256 tiles in the pattern table at adress 0x1000	
	void PPU::fill_pattern_table_cache();
	BYTE ptn_table_updated;		// 0 = no change to pattern table, 1= pattern table has been changed since cache was last filled
	BYTE update_background;		// 0 = no need to update (redraw) background

	BYTE ppu_regs[8];	// the ppu's registers mapped to $2000 - $2007	
	BYTE image_palette[16];		// background palette mapped to 0x3f00
	BYTE sprite_palette[16];		// sprite palette mapped to 0x3f10
	generic_ram *ram;		// the NES internal ram, needed for DMA to sprite memory
	generic_ram *vram;	// 2 KB of VRAM	
	generic_ram *chr;	// chr_ram
	graphics *screen;	// pointer to graphics memory
	BYTE ppu_mirroring;	// 1 = vertical 0 = horizontal
	void vram_write_byte(WORD address, BYTE value);
	BYTE vram_read_byte(WORD address);
	BYTE back_scroll_horizontal;
	BYTE back_scroll_vertical;
	WORD vram_addr_reg;
	WORD vram_addr_reg_buff;
	BYTE vram_data_buff;
	BYTE sprite_ram[256];		// 256 bytes of sprite ram;
	mapper *ppu_mapper;
	void draw_frame();			// draws the current screen to the graphics device
	void draw_background();
	void draw_tile(BYTE quadrant_num, BYTE table_num, BYTE tile_row, BYTE tile_column, BYTE tile_index);
	void draw_sprite(BYTE Y, BYTE X, BYTE tile_index, BYTE attributes, WORD ptn_table_addr);
	void draw_8x16_sprite(BYTE Y, BYTE X, BYTE tile_index, BYTE attributes);
	BYTE get_attrib_color(BYTE table_num, BYTE row, BYTE col);

};


#endif //Cppu