#if !defined(Cgamepad)
#define Cgamepad

#include "data_types.h"
#include "input.h"

class gamepad
{
public:
	gamepad();			// constructor
	~gamepad();						// destructor			
	void reset();   // resets the gamepad
	void set_input_ptr(input* pad_input_ptr, BYTE pad_num);
	BYTE write_byte(WORD address, BYTE value);
	BYTE read_byte(WORD address);
	
	
private:	
	input *pad_input;	// pointer to input object
	BYTE reset_value;		// 0 indicates not reset, 1 indicates reset
	BYTE strobe;			// variable used to track the reset strobe
	BYTE read_num;			// the number of reads performed since reset (mod 8)
	BYTE pad_number;		// indicates whether this instance is pad 0 or pad 1

};


#endif //Cgamepad
