/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "graphics.h"
#include "generic_ram.h"
#include "data_types.h"


#define SCREEN_WIDTH 320	// The screen resolution to use
#define SCREEN_HEIGHT 240	//


graphics::graphics()					// constructor
{

}

graphics::~graphics()
// Destructor 
{

}


void graphics::clear_NESBackground()
// draws a black background, used when background is disabled
{
  /*DDBLTFX     ddbltfx;
    // Use the blter to do a color fill to clear the background
    ZeroMemory(&ddbltfx, sizeof(ddbltfx));
    ddbltfx.dwSize = sizeof(ddbltfx);
    ddbltfx.dwFillColor = 13;	// 13th color in the palette is black
    
	// This line clears the back buffer
	g_pNESBackground->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);	
  */
}

bool graphics::blit_NES_background(BYTE horizontal_scroll, BYTE vertical_scroll)
// copies the pre-rendered background onto the backbuffer
{
  
  ggiCrossBlit(NESBackground_visual, horizontal_scroll, 240-vertical_scroll, 255, 240, *my_visual, 0, 0);
  //  ggiSetGCForeground(*my_visual, 1);
  //ggiFillscreen(*my_visual);
  return true;
}

void graphics::InitSurfaces()
{
 
}

bool graphics::init(ggi_visual_t *visual)
{
  my_visual = visual;  // receive the visual
 
  ggiInit();
  *my_visual = ggiOpen(NULL);
  if (ggiSetGraphMode(*my_visual, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_WIDTH, SCREEN_HEIGHT, GT_8BIT)!=0)  // then setting the mode failed
	{
	  printf("Unable to set 8 bit mode, trying palemu\n");
	  ggiClose(*my_visual);
	  *my_visual = ggiOpen("display-palemu",NULL);
	  if (ggiSetGraphMode(*my_visual, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_WIDTH, SCREEN_HEIGHT, GT_8BIT)!=0)  // then setting the mode failed
		{
		  return 0x00;  // graphics init failed
		}
	}
  NESBackground_visual = ggiOpen(NULL);
  if (ggiSetSimpleMode(NESBackground_visual, 512, 480, 1, GT_8BIT))
	{
	  printf("Unable to set 8 bit mode for background, trying palemu\n");
	  ggiClose(NESBackground_visual);
	  NESBackground_visual = ggiOpen("display-palemu",NULL); // "display-memory",NULL);
	  if (ggiSetSimpleMode(NESBackground_visual, 512, 480, 1, GT_8BIT))
		{
		  printf("graphics init failed\n");
		  return 0x00;  // graphics init failed
		}
	}

  pattern_table_visual = ggiOpen(NULL);
  if (ggiSetSimpleMode(pattern_table_visual, 256, 128, 1, GT_8BIT))
	{
	  printf("Unable to set 8 bit mode for pattern table, trying palemu\n");
	  ggiClose(pattern_table_visual);
	  pattern_table_visual = ggiOpen("display-palemu",NULL); // "display-memory",NULL);
	  if (ggiSetSimpleMode(pattern_table_visual, 256, 128, 1, GT_8BIT))
		{
		  printf("graphics init failed\n");
		  return 0x00;  // graphics init failed
		}
	}
  
  
  //  ggiSetGraphMode(NESBackground_visual, 512, 480, 512, 480, GT_8BIT);
  //  ggiAddFlags(*my_visual, GGIFLAG_ASYNC);
  init_palette();  // use the NES palette
  return 0x01;  // graphics init successful
}

void graphics::release_all()
{
  ggiClose(NESBackground_visual);
  ggiClose(*my_visual);   // release the ggi visual object
  ggiExit();  // close ggi
  printf("ggi exited cleanly\n");
}

void graphics::draw_frame()
{
  ggiFlush(*my_visual);  // redraw the screen
  ggiFlush(NESBackground_visual);
  ggiFlush(pattern_table_visual);
}

void graphics::init_palette()
// creates the palette to use
{

  ggi_color palette[64];  // the ggi palette
	
  // This palette stolen from NESTICLE.PAL
  const NES_pal nes_palette[64] =
  {
	{0x7f,0x7f,0x7f}, {0x00,0x00,0xFF}, {0x00,0x00,0xBF}, {0x47,0x2b,0xbf},
	{0x97,0x00,0x87}, {0xab,0x00,0x23}, {0xab,0x13,0x00}, {0x8b,0x17,0x00},
	{0x53,0x30,0x00}, {0x00,0x78,0x00}, {0x00,0x6b,0x00}, {0x00,0x5b,0x00},
	{0x00,0x43,0x58}, {0x00,0x00,0x00}, {0x00,0x00,0x00}, {0x00,0x00,0x00},
	
	{0xbf,0xbf,0xbf}, {0x00,0x78,0xF8}, {0x00,0x58,0xF8}, {0x6B,0x47,0xff},
	{0xdb,0x00,0xcd}, {0xe7,0x00,0x5b}, {0xF8,0x38,0x00}, {0xe7,0x5f,0x13},
	{0xaf,0x7f,0x00}, {0x00,0xB8,0x00}, {0x00,0xab,0x00}, {0x00,0xab,0x47},
	{0x00,0x8b,0x8b}, {0x00,0x00,0x00}, {0x00,0x00,0x00}, {0x00,0x00,0x00},
	
	{0xF8,0xF8,0xF8}, {0x3f,0xbf,0xFF}, {0x6b,0x88,0xFF}, {0x98,0x78,0xF8},
	{0xF8,0x78,0xf8}, {0xF8,0x58,0x98}, {0xF8,0x78,0x58}, {0xFF,0xa3,0x47},
	{0xF8,0xb8,0x00}, {0xb8,0xf8,0x18}, {0x5b,0xDb,0x57}, {0x58,0xf8,0x98},
	{0x00,0xeb,0xdb}, {0x78,0x78,0x78}, {0x00,0x00,0x00}, {0x00,0x00,0x00},
	
	{0xFF,0xFF,0xFF}, {0xa7,0xe7,0xFF}, {0xB8,0xB8,0xF8}, {0xd8,0xB8,0xF8},
	{0xF8,0xB8,0xf8}, {0xFb,0xa7,0xC3}, {0xF0,0xd0,0xB0}, {0xFF,0xe3,0xAb},
	{0xFb,0xDb,0x7b}, {0xd8,0xf8,0x78}, {0xb8,0xf8,0xB8}, {0xb8,0xF8,0xd8},
	{0x00,0xff,0xFF}, {0xf8,0xD8,0xf8}, {0x00,0x00,0x00}, {0x00,0x00,0x00}
  };

  for(int i=0; i<64; i++) // copy NES palette to ggi palette structure
	{
	  palette[i].r = nes_palette[i].red*256;  // need to x256 because ggi palette is 16 bit
	  palette[i].g = nes_palette[i].green*256;
	  palette[i].b = nes_palette[i].blue*256;
	}	
  
  ggiSetPalette(*my_visual, 0, 64, palette);
  ggiSetPalette(NESBackground_visual, 0, 64, palette);
  ggiSetPalette(pattern_table_visual, 0, 64, palette);  // not really necessary
}

void graphics::begin_background_set_pixel()
// for the directX implementation this locks the background surface.  Needs to be changed
// for other graphics platforms
{
}

void graphics::end_background_set_pixel()
// for the directX implementation this unlocks the background surface.
{
}

void graphics::background_set_pixel(int x, int y, BYTE color_index)
// this should not be using the pattern table surface, but it is for now
// The x and y are in screen coordinates, and the color_index is the color value (should be an index into the NES palette eventually)
{	
  ggiPutPixel(NESBackground_visual, x, y, color_index);	// set the value	
}

void graphics::begin_set_pixel()
{

}

void graphics::end_set_pixel()
{
}

void graphics::set_pixel(int x, int y, BYTE color_index)
// The x and y are in screen coordinates, and the color_index is the color index into the NES palette 
{	
  ggiPutPixel(*my_visual, x, y, color_index);	// set the value
}

void graphics::set_pixel_behind_background(int x, int y, BYTE color_index, BYTE background_color_index)
// just like set_pixel, but only draws the pixel if there is not something on the background already
  // I don't like this method very much, as it goes by color, not the fact that it's background
{
  ggi_pixel background_color;

  ggiGetPixel(*my_visual, x, y, &background_color);
  if (background_color == background_color_index)  // then this location has backround on it
	{
	  ggiPutPixel(*my_visual, x, y, color_index);
	}
			  
  /*
	if (vid_buf[x+y*ddsd_set_pixel.lPitch] == background_color_index)
		vid_buf[x+y*ddsd_set_pixel.lPitch] = color_index;	// set the value
  */
	
}

void graphics::screen_save()
// This is the screen save function.  For now, it only has the option to save to bmp format
{
  //SaveBMP(g_pDDSPrimary, g_pDDSPrimary, "screenshot.bmp");
}

void graphics::pattern_table_set_pixel(int x, int y, BYTE color_index)
{

  ggiPutPixel(pattern_table_visual, x, y, color_index);
}
