#if !defined(Cgraphics)
#define Cgraphics

#include "data_types.h"
#include "generic_ram.h"
//#include <ggi/ggi.h>

class graphics
{
public:
	graphics();					// constructor	
	~graphics();								// destructor	

	void InitSurfaces();

	bool init(ggi_visual_t*);
	bool blit_NES_background(BYTE horizontal_scroll, BYTE vertical_scroll);	
	void draw_frame();
	void init_palette();
	void set_palette_entry(int index, int red, int green, int blue);
	void set_pixel(int x, int y, BYTE color_index);
	void begin_set_pixel();
	void end_set_pixel();
	void begin_background_set_pixel();
	void end_background_set_pixel();
	void background_set_pixel(int x, int y, BYTE color_index);
	void set_pixel_behind_background(int x, int y, BYTE color_index, BYTE background_color_index);
	void clear_NESBackground();
	void screen_save();
	void release_all();
	void pattern_table_set_pixel(int x, int y, BYTE color_index);

private:
	ggi_visual_t *my_visual;  // the ggi visual object
	ggi_visual_t NESBackground_visual; // holds the background
	ggi_visual_t pattern_table_visual; // displays the patter table
};


#endif //Cgraphics
