/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

/*
This class handles all the direct communication with the input devices (directX for now)
*/

#if !defined(Cinput)
#define Cinput

#include "data_types.h"
#include "keyboard.h"

class input
{
public:
	input();			// constructor
	~input();			// destructor			
	void init(ggi_visual_t*);	// the initialization function
	void release_all();
	void read_keyboard_state();
	BYTE key_pressed(BYTE key);	// check status of a key on the keyboard	
	BYTE read_gamepad(BYTE pad_number, BYTE button_number);		// read from a gamepad
	
private:	
	keyboard my_keyboard;	
	
};


#endif //Cinput
