/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "gamepad.h"

gamepad::gamepad()
// Constructor 
{	
	pad_input = NULL;	// null pointer
	reset_value =0;		// make sure it starts out clear
	strobe =0;
	read_num = 0;
	pad_number = 0;	// is it gamepad 0 or gamepad 1
}

gamepad::~gamepad()
// Destructor
{
	
}

void gamepad::reset()
{
  reset_value = 0x01;  // indicate this gamepad has been reset
  read_num = 0;   // go back to first read in sequence
}

void gamepad::set_input_ptr(input* pad_input_ptr, BYTE pad_num)
{
	pad_input = pad_input_ptr;	
	pad_number = pad_num;		// set whether it is pad 0 or 1
}

BYTE gamepad::read_byte(WORD address)
// Read a byte from the memory bus
// This function must determine which device to read from, then perform the read
{
  
	if (!reset_value)
	{
	  printf("Attempt to read unitialized gamepad %x\n", address);
		return 0x00;
	}
	else
	{
		read_num++;
		if (read_num <= 8)
			return pad_input->read_gamepad(pad_number, read_num);		// check button
		
		else if ( (read_num == 20)&&(pad_number == 0) )	// for the pad 0 signature
			return 0x01;
		else if ( (read_num == 19)&&(pad_number == 1) )	// for the pad 1 signature
			return 0x01;
		else if (read_num == 25)  // then it was the last read
		  {
			read_num = 0;
			return 0x00;
		  }
		else 
			return 0x00;	
		
	}	
}

BYTE gamepad::write_byte(WORD address, BYTE value)
// Write byte to bus
  // This function must determine which device to write to, then perform the write
{
  if (address == 0x4016) 	// ignore other writes
	{
	  if ((strobe==1)&&(value==0))	// this transition resets the gamepad
		  {
			strobe = 0;
			reset();
			return 0x01;  // indicate a reset took place
		  }
	  else if (value==1)
		{
		  strobe = 1;
		}	
	}	
  return 0x00;  // no reset took place
}
