/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#if !defined(Ckeyboard)
#define Ckeyboard

#include "data_types.h"
// map ggi keys to the constants the emulator uses
#define KEY_UP 1 //GIIK_Up
#define KEY_DOWN 2 //GIIK_Down		
#define KEY_LEFT 3 //GIIK_Left
#define KEY_RIGHT 4 //GIIK_Right
#define KEY_PGUP 5 //GIIK_PageUp
#define KEY_PGDN 6 //GIIK_PageDown
#define KEY_HOME 7 // GIIK_Home
#define KEY_END 8 //GIIK_End
#define KEY_ESC 9 //GIIUC_Escape
#define KEY_SPACE 10 //GIIUC_Space
#define KEY_PERIOD 11 //GIIUC_Period // '.'
#define KEY_SLASH 12 //GIIUC_Slash // '/'
#define KEY_BRACKET_LEFT 13 //GIIUC_BracketLeft // '['
#define KEY_BRACKET_RIGHT 14 //GIIUC_BracketRight // ']'
#define KEY_F1 15 //GIIK_F1

class keyboard
{
public:
	keyboard();		// constructor
	~keyboard();	// destructor		
	void init(ggi_visual_t*);
	void read_key_state();		// read key presses from keyboard
	BYTE key_pressed(BYTE key);
	void release_all();
private:	
	ggi_visual_t *my_visual;  // a pointer to the ggi visual	
	BYTE keys_pressed[100]; // indexed by the KEY_XXX variables, 0=key not pressed, 1=key pressed
	
};


#endif //Ckeyboard
