// emuschool.h : main header file for the EMUSCHOOL application
//

#if !defined(AFX_EMUSCHOOL_H__3ADA1804_8591_11D3_90A7_00105ACA3B5F__INCLUDED_)
#define AFX_EMUSCHOOL_H__3ADA1804_8591_11D3_90A7_00105ACA3B5F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "dinput.h"
#include "ddraw.h"
#include "data_types.h"
#include "generic_ram.h"
#include "mapper.h"
#include "mapper0.h"
#include "ppu.h"
#include "mem_bus.h"
#include "cpu.h"
#include "graphics.h"
#include "input.h"
#include "gamepad.h"
/////////////////////////////////////////////////////////////////////////////
// CEmuschoolApp:
// See emuschool.cpp for the implementation of this class
//

class CEmuschoolApp : public CWinApp
{
public:
	CEmuschoolApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEmuschoolApp)
	public:
	virtual BOOL InitInstance();
	virtual int Run();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

public:
	//{{AFX_MSG(CEmuschoolApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileOpen();
	afx_msg void OnAltEnter();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	graphics my_screen;			// the screen to draw the graphics on
	input my_input;				// the input object, talks to keyboard and joysticks

	BYTE emulator_running;		// flag to indicate the emulator should be running
	long int clock_cycles;		// number of 6502 clock cycles that have passed
	unsigned int scan_line;		// the number of the current scan line;
	ROM_header my_header;		// the ROM file header structure
	generic_ram my_prg_rom;		// prg ROM device
	generic_ram my_chr_vrom;	// chr VROM device
	generic_ram my_sram;		// create SRAM device	
	generic_ram my_ram;			// create a 2 KB memory object for internal RAM
	generic_ram my_vram;		// video ram for ppu
	gamepad my_gamepad1;		// create joystick1 object
	gamepad my_gamepad2;		// create joystick2 object
	mapper* my_mapper;			// pointer to a mapper object
	PPU my_ppu;					// picture processing unit
	mem_bus my_bus;
	CPU my_cpu;
	
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EMUSCHOOL_H__3ADA1804_8591_11D3_90A7_00105ACA3B5F__INCLUDED_)
