/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "stdafx.h"
#include "generic_ram.h"


generic_ram::generic_ram()					// constructor
{
	memory = NULL;
	mem_size =0;
}

generic_ram::generic_ram(long int size)
// Constructor 
{
	memory = new BYTE[size];	// allocate memory 
	
	mem_size = size;
	for(int i = 0; i<size; i++)		// clear the contents of memory
        memory[i] = 0x00;
}

generic_ram::~generic_ram()
// Destructor
{	
	mem_size = 0;
	delete [] memory;		// deallocate the memory	
}

void generic_ram::set_size(long int size)
// Read from memory
{
	delete [] memory;		// deallocate the memory	
	memory = new BYTE[size];	// allocate memory 
	mem_size = size;
	for (int i=0; i < mem_size; i++)
	{
		memory[i]=0x00;		// clear out memory
	}
}

BYTE generic_ram::read_byte(WORD address)
// Read from memory
{
	if ((address >= mem_size) || (address < 0))
	{
		TRACE("Out of Bounds reading address %X \n",address);
		return 0x00;
	}
	return memory[address];		// return requested byte
}

void generic_ram::write_byte(WORD address, BYTE value)
// Write to memory
{	
    // should be >= because mem_size is zero-based
    if (   (address >= mem_size) || (address < 0))
    {
        TRACE("Out of Bounds writing address %X\n", address);
    }
    else
    {
		memory[address] = value;	// assign byte correct value
    }
}
