#if !defined(Cmem_bus)
#define Cmem_bus

#include "data_types.h"
#include "generic_ram.h"
#include "mapper.h"
#include "ppu.h"
#include "gamepad.h"

class mem_bus
{
public:
	mem_bus();
	mem_bus(generic_ram* ram, mapper* map, PPU* ppu, gamepad* pad);			// constructor
	~mem_bus();			// destructor		
	void set_values(generic_ram* ram, mapper* map, PPU* ppu, gamepad* pad1, gamepad* pad2);
	BYTE read_byte(WORD address);							// read a byte from bus
	void write_byte(WORD address, BYTE value);	// write byte to bus
	WORD read_address(WORD address);			// reads an address from a device

#if defined(DEBUG)
	void get_debug_info(WORD address, BYTE data[], WORD pc, BYTE prog_data[]);
#endif

private:		
	generic_ram *my_cpu_ram;	// The NES's internal 2 KB of RAM
	mapper *my_mapper;			// the memory mapper inside the cartridge
	PPU *my_ppu;				// the PPU
	gamepad *my_gamepad1;		// the joystick port
	gamepad *my_gamepad2;		// the joystick port
};


#endif //Cmem_bus