#if !defined(Ccpu)
#define Ccpu

#include "data_types.h"
#include "mem_bus.h"
#include <stdio.h>		// here for debug log file



class CPU
{
public:
	CPU();
	CPU(mem_bus* bus);			// constructor
	~CPU();						// destructor		
	void set_bus(mem_bus* bus);
	void reset();				// reset the state of the 6502	
	BYTE execute_instruction(long int &cycles);	// executes the next 6502 instruction
	void vblank_interrupt(long int &cycles);	// execute a vblank interrupt	
	
private:		
	BYTE RegAcc;	// Accumulator Register
	BYTE RegX;		// Register X of the 6502
	BYTE RegY;		// Register	opcodes[0x0] = &CPU::func_0x0;

	WORD PC;		// The Program Counter		
	BYTE IR;		// The instruction Register
	BYTE SR;		// The Status Register					
	WORD SP;		// The Stack Pointer
	mem_bus *my_mem_bus;	// The NES's internal 2 KB of RAM

	BYTE bit_set(short bit_number);	
	void SetCMPFlags(BYTE value1, BYTE value2);	
	void push(BYTE value);
	void push(WORD value);
	BYTE pop_byte();
	WORD pop_word();
	unsigned int cycles;
	BYTE temp_byte, temp_byte2;
	WORD temp_word;


	

};


#endif //Ccpu
