/*
Copyright (C) 2000 Chris Teague

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#include "stdafx.h"
#define INITGUID
#include <objbase.h>	// COM stuff
#include "keyboard.h"


keyboard::keyboard()
// Constructor 
{
	lpDirectInput = NULL;
	lpDIKeyboard = NULL;
}

void keyboard::init()
{
	HRESULT hr;		

	hr = DirectInputCreate(AfxGetInstanceHandle(), DIRECTINPUT_VERSION, &lpDirectInput, NULL);
	if FAILED(hr)
	{
		TRACE("Error creating DirectInput object\n");
	}

	hr = lpDirectInput->CreateDevice(GUID_SysKeyboard, &lpDIKeyboard, NULL);
	if FAILED(hr)
	{
		TRACE("Error creating keyboard object\n");
	}

	if (lpDIKeyboard->SetCooperativeLevel(AfxGetMainWnd()->GetSafeHwnd(), DISCL_BACKGROUND | DISCL_NONEXCLUSIVE)!=DI_OK)
	{
		TRACE("Error setting keyboard coop level\n");
	}

	if (lpDIKeyboard->SetDataFormat(&c_dfDIKeyboard) != DI_OK)
	{
		TRACE("Error setting keyboard data format\n");
	}

	if (lpDIKeyboard->Acquire() != DI_OK)
	{
		TRACE("Error acquiring keyboard\n");
	}
	

}

keyboard::~keyboard()
// Destructor
{
	release_all();
}

void keyboard::release_all()
{
	if (lpDirectInput != NULL)
	{
		lpDirectInput->Release();		// clean up the DirectInput object
		lpDirectInput = NULL;
	}

	if (lpDIKeyboard != NULL)
	{
		lpDIKeyboard->Unacquire();		// clean up the keyboard object
		lpDIKeyboard->Release();
		lpDIKeyboard=NULL;
	}
}

void keyboard::read_key_state()
// reads the status of all the keys on the keyboard and stores into keystate
{
	if (lpDIKeyboard != NULL)
	{
		if (lpDIKeyboard->GetDeviceState(256, keystate)!=DI_OK)
		{
			TRACE("Error reading keyboard state\n");
		}
	}
}

BYTE keyboard::key_pressed(BYTE key)
// returns 0 unless the requested key has been pressed
{
	switch (key)
	{
		case F1:
			return (keystate[DIK_F1] & 0x80);
			break;

		case ESC:		// check escape key
			return (keystate[DIK_ESCAPE] & 0x80);
			break;

		case 1:		// check A button
			return (keystate[DIK_RALT] & 0x80);
			break;

		case 2:		// check B button
			return (keystate[DIK_RCONTROL] & 0x80);
			break;

		case 3:		// check SELECT button
			return (keystate[DIK_LCONTROL] & 0x80);
			break;

		case 4:		// check START button
			return (keystate[DIK_LALT] & 0x80);
			break;

		case 5:		// check UP button
			return (keystate[DIK_UP] & 0x80);
			break;

		case 6:		// check DOWN button
			return (keystate[DIK_DOWN] & 0x80);
			break;

		case 7:		// check LEFT button
			return (keystate[DIK_LEFT] & 0x80);
			break;

		case 8:		// check RIGHT button
			return (keystate[DIK_RIGHT] & 0x80);
			break;

		default:
			TRACE("Checking keystate of undefined key\n");
			return 0;
			break;
	}




}
