#if !defined(Cdebugger)
#define Cdebugger

#include "data_types.h"
#include "cpu.h"

class debugger
{
public:
	debugger(CPU* temp_cpu, mem_bus* bus);		// constructor
	//debugger(generic_ram* ram, mapper* map, PPU* ppu);		// constructor
	~debugger();	// destructor		
	BYTE update();		// redraw the debugger screen
private:			
	CPU *cpu;
	mem_bus *debug_mem_bus;
	BYTE acc;
	BYTE x;
	BYTE y;
	WORD pc;
	BYTE sr;
	WORD sp;
	WORD cpu_mem_addr;
	WORD prev_cpu_mem_addr;
	BYTE cpu_mem_data[80];		// the 80 bytes to be displayed in debug window
	BYTE prev_cpu_mem_data[80];		// the 80 bytes to be displayed in debug window, previous copy
	WORD ppu_mem_addr;
	BYTE program_data[39];		// holds the ~13 instructions surrounding the current one
	WORD pc_target;			// the debugger uses this as a breakpoint 	
	WORD pc_base;			// used to tell whethre the instructions need to be redrawn
	WORD instructions[13];	// used to hold the starting address of each of the 13 instuctions shown on the screen
	int prev_instr_line;		// used to hold the screen line of the previous instruction
	BYTE cpu_mem_range_changed;	// indicates whether the cpu memory needs to be redrawn
	void print_mnemonic(int &pc_ptr, WORD pc);
};


#endif //Cdebugger