#if !defined(Cgraphics)
#define Cgraphics

#include "data_types.h"
#include <ddraw.h>
#include "generic_ram.h"

class graphics
{
public:
	graphics();					// constructor	
	~graphics();								// destructor	

	HRESULT init();
	BOOL blit_NES_background(BYTE horizontal_scroll, BYTE vertical_scroll);	
	void draw_frame();
	HRESULT ChangeCoopLevel();		// switch screen modes	
	void init_palette();
	void set_palette_entry(int index, int red, int green, int blue);
	void set_pixel(int x, int y, BYTE color_index);
	void begin_set_pixel();
	void end_set_pixel();
	void begin_background_set_pixel();
	void end_background_set_pixel();
	void background_set_pixel(int x, int y, BYTE color_index);
	void set_pixel_behind_background(int x, int y, BYTE color_index, BYTE background_color_index);
	void clear_NESBackground();
	void screen_save();

	

private:
	//-----------------------------------------------------------------------------
	// Global Variables
	//-----------------------------------------------------------------------------
	HINSTANCE				g_hInstance;
	LPDIRECTDRAW4           g_pDD;				// DirectDraw object
	LPDIRECTDRAWSURFACE4    g_pDDSPrimary;		// DirectDraw primary surface
	LPDIRECTDRAWSURFACE4    g_pDDSBack;			// DirectDraw back surface
	LPDIRECTDRAWSURFACE4    g_pNESBackground;	// Surface to hold the background
	RECT                    g_rcWindow;         // Saves the window size & pos.
	RECT                    g_rcViewport;       // Pos. & size to blt from
	RECT                    g_rcScreen;         // Screen pos. for blt
	BOOL                    g_bActive;			// App is running/active
	BOOL                    g_bReady;			// App is ready for updates
	BOOL                    g_bWindowed;		// App is in windowed mode
	
	LPDIRECTDRAWPALETTE lpddpal;
	HRESULT ReleaseAllObjects();		// release memory
	HRESULT InitFail(HRESULT hRet, LPCTSTR szError, ...); // called if initialization fails
	HRESULT graphics::InitSurfaces();	// create surfaces

	DDSURFACEDESC2      ddsd_set_pixel;
	UCHAR* vid_buf;

	DDSURFACEDESC2      ddsd_background_set_pixel;
	UCHAR* background_vid_buf;
	
	
	
	
};


#endif //Cgraphics