DECLARE SUB wbyte (c%, byte%)

CLS


PRINT "Questo programma legge i files HEADER.BIN, BOOTROM.BIN e FONT.BIN"
PRINT "e li accoda uno all'altro (nell'ordine in cui sono stati citati)"
PRINT "Creando un file con nome UPLOAD.BIN."
PRINT "Aggiunge poi un header compatibile con il formato .TAP dell'emulatore"
PRINT "di Spectrum. Il formato .TAP permette di redirezionare l'input/output"
PRINT "del nastro (comandi basic LOAD e SAVE) in un file, che potra' essere"
PRINT "caricato nell'emulatore."
PRINT
PRINT "L'indirizzo di caricamento SARA` 30000."
PRINT
PRINT "ROMIMAGE.ROM e` composto dai soli BOOTROM.BIN + FONT.BIN"
PRINT "ed e` il file da programmare in EPROM."
PRINT

REM FORMATO DEI FILES .TAP:

REM Essi possono essere costituiti da piu' blocchi; nel caso piu' semplice
REM (come il nostro) ci sono 2 blocchi: header e dati (come su nastro).

REM Il presente programma genera un file .TAP con il seguente formato:


REM Offset      0       2 bytes lunghezza del blocco (eccetto questi 2 bytes)
REM Offset      2       1 byte flag: 0 = header block, FF = data (qui e' 0)

REM --- da qui la struttura e' la stessa di un header su nastro ---

REM Offset      3       1 byte: tipo di blocco che segue: 0=basic, 3=bytes, ecc.
REM Offset      4       10 bytes: nome programma
REM Offset      14      2 bytes lunghezza programma
REM Offset      16      2 bytes indirizzo di caricamento programma
REM Offset      18      2 bytes, forse riservati, sempre $00 $80

REM --- fine parte uguale a quella di un header su nastro

REM Offset      20      1 byte checksum che non comprende i primi 2 bytes
REM                            (quelli della lunghezza totale del blocco)
REM                            Il checksum e' un XOR fra i bytes.


REM Offset      21      Inizio secondo blocco (data block); come sopra,
REM                     i primi 2 bytes contengono la lunghezza totale
REM                     eccetto se stessi.

REM Offset      23      1 byte flag: 0 = header, $FF = dati (qui e' $FF)
REM Offset      24      immagine del programma (file .bin)
REM Offset       x      1 byte checksum, tutto il blocco tranne i 2 bytes
REM                     iniziali (lunghezza blocco).

REM ss$ = s$ + ".bin": OPEN ss$ FOR BINARY AS #1: REM file sorgente
REM ss$ = s$ + ".tap": OPEN ss$ FOR OUTPUT AS #2: REM file destinazione

OPEN "header.bin" FOR BINARY AS #1: REM file sorgente N. 1
OPEN "bootrom.bin" FOR BINARY AS #2: REM file sorgente N. 2
OPEN "font.bin" FOR BINARY AS #4: REM file sorgente N. 3
OPEN "upload.bin" FOR OUTPUT AS #3: REM file destinazione
OPEN "romimage.rom" FOR OUTPUT AS #5: REM secondo file destinazione


WHILE EOF(1) > -1
        a$ = INPUT$(1, #1)
        IF LEN(a$) = 1 THEN
                a% = ASC(a$)
                PRINT #3, CHR$(a%);
        END IF
WEND

WHILE EOF(2) > -1
        a$ = INPUT$(1, #2)
        IF LEN(a$) = 1 THEN
                a% = ASC(a$)
                PRINT #3, CHR$(a%);
                PRINT #5, CHR$(a%);
        END IF
WEND

WHILE EOF(4) > -1
        a$ = INPUT$(1, #4)
        IF LEN(a$) = 1 THEN
                a% = ASC(a$)
                PRINT #3, CHR$(a%);
                PRINT #5, CHR$(a%);
        END IF
WEND

CLOSE #1: CLOSE #2: CLOSE #3: CLOSE #4: CLOSE #5

ad = 30000: REM indirizzo di caricamento
s$ = "zx-com"

OPEN "upload.bin" FOR BINARY AS #1: REM file sorgente
OPEN "upload.tap" FOR OUTPUT AS #2: REM file destinazione

llenght% = LOF(1) MOD 256
hlenght% = INT(LOF(1) / 256)


REM --- INIZIO HEADER BLOCK ---

CALL wbyte(c%, 19)
CALL wbyte(c%, 0): REM lunghezza header: 19 bytes (senza contare i primi 2)

c% = 0: REM dai prossimi bytes viene calcolato il checksum

CALL wbyte(c%, 0): REM flag: 0 = header
CALL wbyte(c%, 3): REM Tipo programma: bytes

add: IF LEN(s$) < 10 THEN s$ = s$ + " ": GOTO add

FOR n% = 1 TO 10
        CALL wbyte(c%, ASC(MID$(s$, n%, 1))): REM nome programma
        NEXT n%

CALL wbyte(c%, llenght%)
CALL wbyte(c%, hlenght%)
CALL wbyte(c%, ad MOD 256)
CALL wbyte(c%, INT(ad / 256))
CALL wbyte(c%, 0)
CALL wbyte(c%, 128)

CALL wbyte(c%, c%): REM checksum

REM --- FINE HEADER BLOCK ---

llenght% = llenght% + 2: REM calcola lunghezza blocco dati: add flags e chcksum
IF llenght% > 255 THEN llenght% = llenght% - 256: hlenght% = hlenght% + 1

CALL wbyte(c%, llenght%)
CALL wbyte(c%, hlenght%)

c% = 0: REM inizio nuovo checksum
CALL wbyte(c%, 255)

REM Inizio blocco programma vero e proprio

WHILE EOF(1) > -1
        a$ = INPUT$(1, 1)
        IF LEN(a$) = 1 THEN
                a% = ASC(a$)
                CALL wbyte(c%, a%)
                END IF
        WEND

CALL wbyte(c%, c%): REM scrive il checksum

PRINT : PRINT
PRINT "Dimensioni file .bin: "; LOF(1); "Bytes"
PRINT "Dimensioni file .tap: "; LOF(2); "Bytes"

CLOSE #1
CLOSE #2

SUB wbyte (c%, byte%)

PRINT #2, CHR$(byte%);
c% = c% XOR byte%

END SUB

