;---------------------------------------------------------------------------------------------
; This test program will copy the original sinclair 16/48K rom to RAM bank n. 31.
; It then patches the NMI handler so it will increment the first byte of video ram and
; activate the new "ROM".
;---------------------------------------------------------------------------------------------
;


; CPLD REGISTERS
;
FASTPAGE   	equ $7F


;********************************************************************************************************
;********************************************************************************************************

	org 40000

	ld a,$9F			; Bank n. 31 (1F) and D7 set = RAM WR enable, read disabled
	out (FASTPAGE),a		; (original rom is active on read cycles)

	ld hl,0				; copy sinclair rom to selected RAM bank
	ld de,0
	ld bc,16384
	ldir

	ld hl,nmi_block			; new NMI handler patch
	ld de,$66			; destination address
	ld bc,end_nmi-nmi_block
	ldir				; NMI handler is now patched

	ld a,$5F			; Bank n. 31 (1F) and D6 set = RAM RD enable (page-in), wr protected
	out (FASTPAGE),a		; (will act as a real rom. Original rom is disabled via ROMCS).
	jp 0


nmi_block
	push af				; patch code for NMI handler
	push hl
	ld hl,16384
	inc (hl)
	nop
	nop
	nop
	nop
	pop hl				; this is same as original content, at address $70
	pop af
	retn
end_nmi

        end 

