   g^h^a8aa  aa ]@0  g^|JdA  !@                                v         f^f^       )&9&vv                      THE SCOPE-SCAPE

The core of this program was based  on  the  properties  of
electric  fields,  and  gives  a  view, or "scope" into the
nature of such fields. The results are a bit suggestive  of
a  3-D  oscilloscope,  or  "'scope." The routine is a near-
perfect  model  for  the  study  of  electrostatics.  After
experimenting  with  it,  however, I realized that it has a
much broader "scope" than simple electrostatics. Hence  the
name, "Scope-scape."

Imagine  a  two-dimensional  plane,  which we will call the
"Generator Plane." At the centre of this plane is a  point-
source  of  positive electric potential, which we'll call a
"Generator."

Now imagine  that  we  have  a  sensitive  electric  field-
strength  probe. By moving the probe around near our point-
source in the generator plane, we can get readings  of  its
field at any point.

Let's  now  visualize a second plane, above and parallel to
the Generator Plane. We'll call this  the  "Effect  Plane."
Let's  scan our field-strength probe over a portion of this
plane  (plane-segment),  taking  readings  at  every  point
within   the   plane-segment.  The  measured  readings  are
recorded; the table of  readings  are  stored  in  a  table
called  the "Scope map." These values are subsequently used
to draw either 2-D topographical maps, or  3-D  view  maps,
showing the effect of the generator on the "Effect Plane." 

Figure 1 shows the concept behind the Scope-scape.

How  are  the  values  in  the  Scope  map calculated? Good
question. If you will  recall  your  college  Physics,  you
might remember that the field strength generated by a point
electric source is "inversely proportional to the square of
the  distance."  Put  in everyday terms, imagine that we're
taking a field-strength reading one unit of distance from a
point  source.  If  we  double  the distance, the new field
strength will be 1/4 of the first reading. At  three  times
the  distance,  field  strength  will  be  1/9 of the first
reading, and so on. To put it yet another way,

FS=K/(D**2)

where K is a constant of proportionality.  More  about  "K"
later.

How  would  we  calculate  the  distance, D? Easy. Remember
Pythagoras and his ubiquitous theorem? Let X and Y  be  the
co-ordinate  in  the  Effect plane that we are calculating.
Let Z represent the distance between  the  generator  plane
and  the effect plane. Let Xg and Yg be the co-ordinates of
the generator. The distance from the generator to the point
under study would be,

D = SQRT( (X-Xg)`2 + (Y-Yg)`2 + Z`2 )

Note  that,  since field strength is inversely proportional
to the SQUARE of the distance, or D`2, there is no need  to
evaluate the square root; we save a lot of time by using

D`2= (X-Xg)`2 + (Y-Yg)`2 + Z`2

We  then  divide  the value of D`2 into constant K. In this
program, K is  assigned  the  value  of  Z`2.  This  is  to
"normalize"  the  results for varying values of inter-plane
distance Z. Regardless of the value of Z, the maximum value
in  the  effect  plane  will  always  be directly above the
generator, i.e. when the distance D is  minimum.  By  using
Z`2  as  the  proportionality  constant, this maximum value
will equal the value (size) of the generator.

What if the generator has a  negative  value,  representing
(for  example) a negative charge? No problem. The resulting
values in the Effect Plane will simply be inverted. Instead
of  the  "bump"  created  by  a positive generator, we will
obtain a "dip" from a negative generator.

MULTIPLE GENERATORS

What if we have more than one generator  in  the  Generator
plane?   In  such  a  case,  we  borrow  the  principle  of
"superposition" from electronics. At  every  point  in  the
effect  plane, we compute the effect of EACH generator, and
algebraically add them together.

The scope-scape idea is also an exact analog  for  magnetic
fields.   If   only   positive  values  are  used  for  the
generators, it also provides an  analog  for  gravitational
fields,  light  intensity,  and  a  wide  variety  of other
phenomena which follow the "inverse square law."

THE SCOPE-SCAPE ALGORITHM

Here is a "pseudo-code"  summary  of  how  the  scope-scape
routine works:

INPUT N                         :# of GENERATORS
FOR I=1 TO N
  INPUT X(N),Y(N),V(N)          :Input  generator  X,  Y  &
value
NEXT I
INPUT Z distance
K=Z**2                          :calculate K, =Z`2
DIM P(XM,YM)                    :Dimension map array

FOR Y=0 TO YM
  FOR X=0 TO XM
    TOTAL=0
    FOR I=1 TO N
      VAL=K+(X-X(I))`2+(Y-Y(I))`2
      TOTAL=TOTAL+VAL
    NEXT I
  P(X,Y)=TOTAL
  NEXT X
NEXT Y

In simple English: For every point in the effect plane, sum
the effects of each of  the  generators  in  the  generator
plane. Store the superposed value in map array P.

ARITHMETIC IN F-SCAPES

The  Scope-scape  routine, and indeed all the major map and
display routines, are written in machine-code. However,  no
less  than  THREE  different  kinds of arithmetic are used,
depending on accuracy requirements. The first  is  ordinary
Z80  8-bit  math. This is used for counters and such, where
we only need values from 0 to 255 (or -128 to +127).

Where more range is  needed,  16-bit  math  is  used.  Such
numbers  can have a range from 0 to 65535 (positive 16-bit)
or -32768 to +32767 (signed 16-bit). A collection  of  math
routines  (multiply,  divide, etc.) are used to handle such
operations. These routines were  originally  found  in  Bob
Berch's runtime package for his "Compiler."

The  third  type of math is Sinclair floating-point. It has
the widest range, and therefore the best precision, but  it
is  also  the  slowest.  Some speed improvement is afforded
even in this case, by coding  directly  in  the  Sinclair's
"calculator language" instead of BASIC.

These  three  types  of  math  are  used  as  the situation
dictates. For instance, 8-bit math is  used  for  the  loop
counters,  simple  comparisons, etc. 16-bit math is used to
compute the square of the distance from the given point  to
the   given  generator.  Floating-point  math  is  used  to
calculate and sum the net effect of each generator.

This approach  pervades  F-SCAPES.  This  is  how  I  could
optimize speed without compromising precision. Only as much
precision as is really needed, is used in these routines.  

THE MAP ARRAY

To allow the program to run in 48K, and  give  the  maximum
possible  resolution,  a string array (instead of a numeric
array) is used to store the map values. This is P$(99,256).
The  first  96  dimensions represent 96 vertical lines. The
second dimension represents  128  horizontal  positions  on
each  line, two bytes each. (I.e. the map values are stored
as signed 16-bit numbers.)

The last three dimensions (97, 98 and 99) are used for  the
generator  X  position,  Y position, and value (magnitude),
respectively. These are also 16-bit signed numbers,  so  it
follows  that  128  is  the  maximum  number  of generators
allowed. By including the generators in the same map as the
scope  map  they  create, I considered owners of Z-XLR8 and
similar "array-save" routines.

Dimensioning this array is done as a separate operation  in
the  MAP  menu.  The  reason  is  so that you can superpose
scope-scapes from two or more different generator sets onto
a single map. You could even superpose a scope-scape onto a
3-D "Mu-map" (Mandelbrot set). Other possibilies exist, and
are entirely up to your imagination.

vv                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v 