   ffiみii  ii ]@0  f|[  !@                                v         {Ff       $&)&9&vv                        THE MAP MENU

Finally, after all this preambling, here's how you go about
actually creating a "Map" from which you can "Draw" various
neat "F-Scapes." The options are [C]lear, [S]cope, [M]umap,
[S]cale, [Flip], [T]urn, and [Z]ap.

CLEAR

[C]lear dimensions the map array, setting the value of each
element to zero. This is one of those places where you  are
asked "Are you sure?", for obvious reasons. You have to use
the [C]lear option before attempting to generate a  F-Scape
map.

ZAP

[Z]ap  is,  in a way, the opposite of [C]lear. It collapses
the map array to a size of (1,1). This is so that  you  can
save the program alone, without that humungous (almost 25K)
map array. This is how you receive the program.

HINT: If you [Z]ap by mistake, you might still be  able  to
[D]raw  from the "deleted" array. Only the bottom few lines
will be corrupted if you do your  Draw  Menu  option  right
after  Zapping.  DO NOT use [C]lear, as this will genuinely
erase the present array. However, the [S]ave options in the
File Menu will NOT save the zapped array to tape.

SCOPE

This  creates  a scope-scape. Use the [C]lear option first,
to create the array if it doesn't already exist.

You are asked for the number of generators to use,  from  1
to  128.  How  long  the  scope-scape  will take to create,
depends on how many generators you select, at the  rate  of
about 1.5 minutes per generator.

You  are  then  asked  if  you  want  the  generators to be
[R]andomly determined, or [A]ssigned by you.

If you select [R]andom, you're  asked  for  a  "Randomizing
Seed" value, so that you can duplicate (or extend) the same
scope-scape later, if desired. Entering zero (or using  the
default  of  PV=0  by pressing [Enter] alone) gives a truly
unpredictable   set   of   generators.   The   co-ordinates
(location) and value (magnitude) of the generators are then
pseudo-randomly created.

If you select [A]ssign, you are asked to input the X and  Y
co-ordinates,  and  the value of each generator. Though the
generators are, of course, in the Generator plane, their  X
and Y values correspond directly to the co-ordinates of the
Effect plane (0<=X<=127, and 0<=Y<=95). Note, however, that
X and/or Y MAY be outside of the range of the Effect plane.
In other words, it's perfectly valid  to  specify  X  or  Y
values   less   than  zero,  or  greater  than  127  or  95
respectively. Don't go TOO far out of range,  however.  Not
only  will such remote generators have a negligible effect,
but  you  might  also  run  into  overflow  of  the  16-bit
arithmetic, with bizarre results.

There is no set range limit on "Value," except that it must
of course be within the 16-bit signed integer range (-32768
to  +32767).  However,  once  again there will be a problem
with overflow if the absolute value of these are too  high.
Keeping  "value"  in the range of -300 to +300 will usually
be fine, but to be unconditionally safe, limit them to  the
8-bit range (-128 to 127). (This will also prevent the need
for major re-scaling later.)

After the generators have been assigned one way or another,
you  are asked to input the "Z" distance. Lower values of Z
yields sharper peaks and dips,  and  higher  values  yields
broader ones. Electronics people can relate this to the "Q"
of a tuned circuit; higher Z equals lower Q. "Good"  values
of  Z  range  from  about  5  through 30, though higher (or
lower) values are, of course, permissible.

Z=zero would only produce a "carbon-copy" of the  Generator
plane  ("infinite  Q").  However,  using 0 will give a zero
result in this program because attempted division  by  zero
gives an answer of zero, rather than stopping with an error
code.

Finally, you are asked to verify that you want to continue.
Answering  [Y]  will  commence calculating the map. This is
done in FAST mode, and the BREAK  key  is  inactive  during
calculation,  so don't assume that the program has crashed.
Be patient, you are eventually returned to the Home Menu.

MUMAP

This is something of an afterthough.  It  lets  you  do  3-
dimensional  Mandelbrot set plots, as well as the usual 2-D
ones we have all grown to  know  and  love.  ("Mu-map"  was
Benoit  Mandelbrots  original term for what was later named
the "Mandelbrot Set"  in  his  honour.)  You  can  even  do
composites  of  Mu-maps  and  Scope  maps,  for  even  more
realistic-looking 'scapes!

There is good reason why [M]umap appears before [S]cope  in
the  Map  menu.  This is that creating a Mu-map over-writes
the map array. Scope maps, on the other hand, are additive.

In  other  words, you can do a Scope-scape using one set of
parameters, then do another without  first  [C]learing  the
old  map. The new map will simply be algebraically added to
the old map. You can use this, for example,  to  make  some
rolling  hills and valleys (high Z), then add sharper peaks
and   dips  (low  Z).  The  process  can  be  continued  ad
infinitum,  or until you mess up the map by overflowing 16-
bit arithmetic.

If you want to superimpose a Mumap and  a  Scope-Scape  (as
the  illustration  of  Figure  2 below), you have to do the
Mumap   FIRST,  then  add  the  scope-scape(s).  You  can't
superimpose  one  mumap  on  top of another, or on top of a
scope-scape.

For   information   (and  practice)  in  playing  with  the
Mandelbrot Set (Mumap), see my "MANDEL-FFP."

                      MAP MANIPULATION

The  next  options  physically  modify  the  map  array. In
general, the modifications can be reversed, but  beware  of
using Re-[S]cale, which can get you into trouble because of
the rounding that accompanies integer math.

FLIP

[F]lip inverts the map (multiplies  each  element  by  -1).
Peaks  become  dips,  and  dips  become peaks. Using [F]lip
again reverts to original.

TURN

[T]urn rotates the map by 180 degrees. If you  use  one  of
the  2-D  Draw  Menu  options ([T]iny, [B]ig or [S]trange),
it's as if you turned the map upside down. If you use a 3-D
option  ([F]ront  or [A]ngle), it's as if you're looking at
the map from  the  other  side.  In  other  words,  "North"
becomes South, and vice versa.

An  exact  analog  to  [T]urn  is if you used the View Menu
[M]irror   options,   mirroring   both   horizontally   and
vertically.   Note   the  important  distinction,  however;
[M]irror, being in the View Menu, affect  only  the  screen
display;  it  does  not  modify  the  map. [T]urn, however,
modifies the map itself, without  visible  results  on  the
screen until you use one of the [D]raw options to re-create
the new image.

As with [F]lip, the effect of [T]urn can be reversed with a
second application of [T]urn.

[S]cale

You  will  find quite often, that your resulting map spills
off the screen when using a 3-D Draw  Menu  option.  Slight
overspills  are alright, the part the goes of the screen is
simply  ignored.  Larger  overspills,  however,  can  cause
bizarre  vertical  lines  to be generated. [S]cale lets you
view the present scale of  the  map  (maximum  and  minimum
values), and optionally rescale the entire map.

It  works like this. The program first searches through the
map to find the highest  and  lowest  values,  and  reports
them.  If  you  wish  to  change the scale, answer [Y] when
asked "Rescale?". You are now prompted for  a  new  maximum
and  new minimum. For instance, your map might range from -
300 to +250. Looking at an [A]ngle  3-D  plot,  you  figure
that  it would all fit on the screen if the range were -100
to +100. This  approach  was  a  little  more  involved  to
program than a simple "scale factor" and "offset" approach,
but is (I feel) a lot easier for the user.

The trouble with rescaling is  that  we  are  dealing  with
integers.  If  you  increase the spread between maximum and
minimum, you will get "jaggies" as  a  result.  So  rescale
judiciously. You can always go smaller, but beware of going
too small; if you try to enlarge after getting carried away
with   this,   you  will  lose  detail.  Incidentally,  the
rescaling is done in floating point math  even  though  the
starting numbers as well as the final results are integers.
This minimizes "integer  strobing"  and  allows  fractional
scale  factors.  In  other  words, it is perfectly valid to
rescale from "-100 to +100" to "-47 to +45",  or  for  that
matter anything else.

                    A WORD ABOUT ERRORS

I have already pointed out that generating a Scope map does
not automatically re-dimension the  map  array.  There  are
several other parts of the program where you have to make a
conscious effort to do things in  the  correct  order.  For
instance,  the Draw Menu options do not automatically clear
the screen. As in the case of map dimensioning, this can be
annoying  if you forget to clear the display before drawing
a  new  map.  On  the  other  hand,  it  allows  for  added
flexibility.  For  instance,  you  can super-impose a [B]ig
display over a [S]trange, or a [G]enerator over a [B]ig, or
whatever.

Since   this   is   a   program   for   entertainment   and
experimentation, I felt it better to let you make  mistakes
and  suffer  the  consequences, than to make it all too cut
and dried. Some of  your  "errors"  will  actually  produce
fascinating (if sometimes bizarre) results.

To  my knowledge, it's not possible to crash the program by
making mistakes. A few mistakes, such as entering the  null
string for the SAVE name, will cause an error stop, so even
though the program is crash-proof,  it's  not  quite  bomb-
proof.

vv                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v 