-- TEST CPLD VUOTA: SU issue6 eseguendo un loop di OUT su una porta qualsiasi
-- (anche non zxmmc+, ad esempio 15) va in crash dopo pochi istanti se ULA calda.
-- (nota: non succede se la porta e' 01).
--
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity X9572_zxmmc2 is port (
	clock, reset:					in std_logic;									-- clock (same as Z80)
	z80_databus:					inout std_logic_vector(7 downto 0);		-- Z80 databus
	z80_iorq, z80_mreq:			in std_logic;
	z80_rd,z80_wr:	 				in std_logic;									-- iorq, rd, wr
	address:							in std_logic_vector(7 downto 0);			-- Z80 A7:A0
	hi_address:						in std_logic_vector(1 downto 0);			-- Z80 A15:A14
	z80_nmi:							inout std_logic;
	z80_wait:						inout std_logic;

	edge_romcs:						out std_logic;									-- ROMCS1 -> (A4) (fixed); 
--	edge_romcs2:					inout std_logic;								-- ROMCS2 (B15); this is VIDEO on 48/128,
																							-- where ROMCS is B25 (jumpered)
	
	memory_bank:					inout std_logic_vector(4 downto 0);	-- A18:A14 to memory chips
	ram_cs, rom_cs:				out std_logic;
	residos:							in std_logic;									-- D6 status (1 = fastpage enabled)
	ramrom:							in std_logic;									-- D5 status (0 = RAM paged; 1 = ROM paged) (NOT!)
	kempston_enable:				in std_logic;									-- '0' enables $1F read
	if1_enable:						in std_logic;									-- '0' enables $EF and $F7 read
	rs_232in,dtr_in,net_in:		in std_logic;

	kempston:						in std_logic_vector(2 downto 0);			-- remaining (D4:D3) from memory_bank<4:3>
	
	rs_232out, cts_out, net_out: out std_logic;

	OUT1_reg:						out std_logic_vector(1 downto 0);	-- Cards CS
	spi_clock:						out std_logic;
	spi_dataout:					out std_logic;
	spi_datain:						in std_logic
);

end X9572_zxmmc2;

architecture Behavioral of X9572_zxmmc2 is

signal tx_register: 				std_logic_vector(7 downto 0); 		-- shift register trasmissione
signal shift: 						std_logic_vector (6 downto 0);		-- shift register ricezione
signal rx_register: 				std_logic_vector(7 downto 0); 		-- registro ricezione leggibile dallo Z80
signal spi_tx: 					std_logic_vector (3 downto 0);
signal bus_cnt: 					std_logic_vector(1 downto 0);
--signal mmc1_cs, mmc2_cs:		std_logic;
signal fastpage:					std_logic_vector(2 downto 0);			-- D7:D5
signal flashwrite:				std_logic;
signal comms_data, data_out:	std_logic;
signal nmi_enable:				std_logic;
signal wait_cnt:					std_logic_vector(1 downto 0);
signal msb_latch:					std_logic_vector(1 downto 0);

begin


		fastpage(2) <= '0';					-- (D7) RAM WR disabled
		fastpage(1) <= residos;				-- (D6) 1 = fastpaging enabled (jumper selectable)
		fastpage(0) <= not ramrom;			-- (D5) 0 = RAM is paged-in; 1 = ROM is paged-in. 'NOT': OPEN = 1 = RAM IS PAGED
		msb_latch <= "00";
		flashwrite <= '0';					-- flash write disabled
		nmi_enable <= '0';
			
		comms_data <= '0';					-- selects NETWORK. attenzione: questa aggiunta ha comportato una riduzione
													-- sospetta di macrocelle utilizzate (-2)
		data_out <= '1';						-- IDLE network
		
		cts_out <= '1';						-- CTS inactive (negated by MAX232)
		
		wait_cnt <= "00";
			
		z80_nmi <= 'Z';						-- questa aggiunta ha comportato il passaggio di optimize da 'balance' a 'density'
		z80_wait <= 'Z';

z80_databus <= "ZZZZZZZZ";
	
memory_bank <= "00000";

ram_cs <= '1';

rom_cs <= '1';

edge_romcs <= 'Z';

end Behavioral;

