----------------------------------------------------------------------------------
-- COMPILED ON ISE 10.1.01i
--
-- 01/06/2008
--
-- Compilata su ISE 10.1; creato nuovo progetto ed inseriti i files VHD e UCF.
-- Unica differenza: Collapsing Input Limit = 19 invece di 20. Tutto il resto di default.
-- Il file .jed e` risultato identico a quello della 9.1 (confronto nel dispositivo)
--
--
--
-- Aggiornamento del 04/01/2008 (versione corrente = 1.4):
--
-- Assemblato primo esemplare del pcb v1.1, che ha richiesto l'inserimento di un
-- transistor fast-switching (PMBT2369, lo stesso usato nel primo clock adapter,
-- molto vicino al pin di clock della cpld).
-- Dato che questi NEGA il clock, la presente versione ha clock'event modificato a '1'.
-- In una ulteriore revisione del PCB si potrebbero invertire gli ingressi del comparatore.
--
-- Dopo questa modifica, le impostazioni di implementazione e fitter sono TUTTE DI DEFAULT,
-- tranne il Collapsing Input Limit = 20 (altrimenti non completa il fit).
-- Questo significa slew rate = high, macrocell power = std, optimize balance, optimize for speed.
--
--
--
-- V1.4 del 04/11/2007
--
-- Come la V1.3, ma con SPI_CLOCK LOW when IDLE. Questo rende la nostra porta SPI
-- compatibile con l'Ethernet Controller ENC28J60 (oltre a mantenere la compatibilita`
-- con le SD-CARD). E` necessario rinunciare ad una sd-card per utilizzarne il CS.
--
-- La versione su ZX-Badaloc prevede anche la generazione di un terzo CHIP SELECT
-- in modo da mantenere due card. I bit di controllo sono sempre D1:D0, il terzo
-- chip select si attiva quando sono entrambi '0'. Qui non e` (ancora) stato fatto
-- per mancanza di un pin libero. Vedere.
--
--
--
-- V1.3 del 11/06/2007
--
-- Compilata ripartendo da valori di default, poi modificati come segue:
-- Slew Rate = SLOW
-- Input Limit = 20
-- Pterm Limit = 25
-- Quindi, l'ottimizzazione resta "balance" (con "density" la card funziona MALISSIMO)
-- Inoltre, dopo l'installazione del nuovo clock adapter 128K heatsink-aware,:
-- Macrocell Power Setting = LOW (rimessa "Std" nella 1.4, vedi sopra)
--
-- Nota su questa ultima impostazione (29/06/2007):
-- Una volta stabiliti i componenti per il nuovo clock adapter basato su operazionale AD8063
-- (Vref = 39K pos, 10K gnd, 100nF in parallelo alla 10K) che erano OK sia con 48K che 128K,
-- il terzo prototipo collaudato (la n.5 prodotta) ha manifestato malfunzionamento con il 48K.
-- Modificando pero` la 39K --> 27K, cosa che permetteva il perfetto funzionamento sia con il 48K
-- che il 128K, la stessa modifica causava il problema nel caso opposto sui prototipi 1, 4
-- (ovvero malfunzionamento solo sul 128K) in quanto l'innalzamento della Vref provoca un
-- accorciamento del semiciclo LOW del clock sulla CPLD, che nel 128K e` gia` piuttosto corto
-- dato che l'ULA eroga solo 1,5V sull'edge.
-- Impostare il macrocell power setting = LOW ha permesso il buon funzionamento anche del
-- prototipo n.5 con la 39K sullo ZX-Spectrum 48K.
--
-- Introdotta gestione di COMMUTAZIONE ROM SU OUTPUT $7FFD, bit D4. NON E` IN GRADO DI OFFRIRE
-- PROTEZIONE da LOCK BIT, per cui in caso di OUT $7FFD si potra` avere un cambio di banco anche
-- se il lock e` attivo nel vero registro dell'ULA. Cio` e` piu` o meno accettabile in quanto
-- si puo` mettere in duplice copia il banco rom 48K, che e` l'unico in cui questo lock deve
-- essere realmente operativo. Inoltre (leggere avanti) il cambio di banco NON avviene se e`
-- paginata la RAM.
--
-- Funzionamento:
-- In caso di output su $7FFD (testate solo le linee A15, A14, A7-A0) il valore di D4
-- viene memorizzato nel SIGNAL ROMAD_LSB, ma SOLO se e` paginato un banco di FLASHROM.
--
-- Spiegazione:
-- L'intento e` quello di ottenere una communtazione di ROM 0/1 conforme a quella sullo
-- ZX-Spectrum 128K. Questa commutazione non deve pero` avvenire nei seguenti due casi:
-- 1) Firmware bootrom in funzione (che quando ripristina uno snapshot, aggiorna $7FFD)
-- 2) ResiDOS (sicuramente lo manderebbe in crash).

-- Dato che in entrambi i casi si usa la RAM (il bootrom viene copiato in ram e resta
-- in esecuzione li` per poter avere uno spazio rd/wr per le proprie variabili), il
-- meccanismo e` accettabile.
-- E` possibile programmare una coppia di ROM 128K in due banchi adiacenti (ROM 0 deve essere
-- ovviamente in un banco con A0 = '0') che saranno in grado di eseguire il salto grazie al
-- port standard $7FFD. (un sistema a 64Krom (+2A/+3) non e` invece implementabile in quanto,
-- avendo solo gli indirizzi A15, A14 per quanto riguarda la parte MSB, non potremmo
-- distinguere un OUT $1FFD da un $3FFD, tanto per fare un esempio).

-- La nuova bootrom 1.21 e` in grado di determinare (andando per tentativi) il contenuto
-- dei registri $1FFD e $7FFD (il primo e` pero` superfluo, fatto solo per compatibilita`
-- con snapshot badaloc) e ne esegue l'OUT in fase di ripristino. Questo non comporta
-- salti di banco grazie al fatto di girare in RAM. Nemmeno l'hardware ULA puo` nulla,
-- dato che le rom interne restano SEMPRE disattivate (gira il nostro bootrom in RAM e
-- poi gireranno le nostre ROM modificate in FLASH).

-- La nuova bootrom 1.30 salva e ripristina anche il contenuto di FASTPAGE, per cui
-- il ritorno al banco di flashrom che era attivo al momento dello snap e` garantito;
-- il valore determinato per i registri $1FFD e $7FFD non ha quindi alcuna importanza in
-- questo contesto, mentre puo` averne se lo snapshot viene ripristinato sul badaloc.

-- NOTA: I due banchi che contengono 48K + IF1 SHADOW dovrebbero essere invertiti fra loso
-- in modo che quello con la rom 48K risieda nel secondo banco (Con A14 = '1') in modo che
-- un accidentale OUT $7FFD verso la ROM1 (basic 48K nello spectrum 128) non comporti un crash.
--
--
--
-- V1.2 del 20/05/2007
--
-- Modificata la formula del ROMCS, che nella V1.1 era semplicemente <= fastpage(1).
-- La nuova formula evita l'attivazione della rom interna su cicli di SCRITTURA Z80, dato
-- che pare che cio` possa avvenire sul +2 e forse anche su altri modelli.
-- Cercando di commutare meno possibile, il ROMCS viene forzato alto se fastpage(1) = '1' (come prima)
-- ma anche se Z80_RD e` '1' CONTEMPORANEAMENTE ad una di queste due condizioni: RAM o FLASHROM
-- abilitate in scrittura. Il software, infatti, potrebbe attivare solo scrittura ma non lettura
-- (fastpage(1) = '0') e cio` comporterebbe una concomitanza del dato Z80 con quello della ROM interna.
--
-- NOTA:
-- Questa modifica ha comportato il passaggio da Optimize Balance ad Optimize Density, CHE PERO`
-- CAUSAVA UN ERRORE GRAVE NEL FUNZIONAMENTO DELLA SD-CARD!!!
-- Situazione attuale = Optimize Balance, fit ottenuto mediante impostazione di
-- PTERM-LIMIT = 25 (default), COLLAPSING INPUT-LIMIT = 20
-- In seguito, si e` anche messo SLEW-RATE = SLOW (vedi aggiornamento del 31/05!!)
-- Tutto il resto e` al DEFAULT.
-- A questo punto non si puo` escludere che possa funzionare bene anche l'Optimize Density se si
-- imposta slew-rate = slow, ma al momento non c'e' motivo di provare.
--
-- AGGIORNAMENTO IMPORTANTE DEL 31/05:
-- Assemblato il terzo prototipo: questo ha subito manifestato un evidente problema sulle SD-CARD
-- nell'utilizzo del programma NONVOLA (ripristino dei 512K mediante PRINT USR 30006). Soprattutto
-- a freddo, esce quasi quasi subito con codice '1', lasciando il CS attivo. Ipotizzando un problema
-- specifico di quell'esemplare, si e` ripetuto il test sul CAMPIONE 1 che ha dato il medesimo risultato!!!
-- Programmando il V1.1.jed tutto tornava a posto. Da prove, pare che il problema sia di nuovo risolto
-- impostando SLEW RATE = SLOW.
-- NOTA: il ResiDOS e perfino IDESPEED.BAS sembrava funzionare cmq; forse si tratta di un problema legato
-- alla massima velocita` mediante code-unrolling usato da NONVOLA.ASM.
--
--
--
-- V1.1 del 24/04/2007 - versione prima spedizione Garry.
--
-- Cambiate le impostazioni di implementazione e fit: tutte al default
--
-- Il sorgente corrente ha una modifica sull'asserzione del WAIT: dopo la correzione del CLOCK, con la
-- versione precedente il wait non era abbastanza tempestivo da bloccare il ciclo di WR I/O stesso.
-- Questa versione non usa BUS_CNT per questa particolare funzione ed abbassa il WAIT sul fronte di
-- discesa che segue immediatamente quello di salita sul quale sono stati asseriti IORQ+WR.
-- Questo blocca lo Z80 sul ciclo stesso, come accade nell'hardware originale.
--
-- La parte di REVOCA non ha subito modifiche in quanto ha un contatore a 3 stadi il cui scopo e` proprio
-- quello di ritardare la revoca come avviene sull'hardware originale (originale = 9 TOGGLE circa = 4,5T-states).
-- Tale contatore sarebbe stato dannoso nella precedente versione perche` somma ulteriore ritardo.
--
--
--
-- V1.0 del 23/04/2007
-- Optimize Balance e` ok.
--
-- Non inizializza i CS delle card, che sono attivi al poweron.
-- E` la versione BASE OK in uso al momento della soluzione del problema del CLOCK CPLD.
--
-- Ha impostazioni diverse dal default sia nell'implementazione che nel FIT.
--
-- 24/04/2007 ricompilata con tutto DEFAULT, *sembra* ok. Sorgente salvato in
-- "9572zxmmc2_VERYgoodprimadimodificaWAIT_IF1.vhd"
--
--
--
-- V 0.6 03/04/2007
--
-- IF1 con tutti i pin RS-232/NET autonomi; kempston<4:3> eliminati e riversati su MEMORY_BANK<3:4>
--
-- Porte implementate:
--
-- $1F WR:
-- D1:D0		SD/MMC card chip selects, active LOW
-- D2			don't care
-- D3			'1' = NMI issued on rs_232in falling edge
-- D7:D4		Special commands code:
--				'A' = Enables FLASH WR PIN; any other combination DISABLES flash write
--				When 'A' is on MSB nibble, the lower nibble DOES NOT CARE.
--
-- $1F RD:	Kempston port.
-- Only 3 pins are available for kempston joystick (D2:D0). The remaining 2 bits (D4:D3) are shared with
-- MEMORY_BANK msb bits (D3:D4 respectively). To do this, these two pins are turned into BANK OUTPUTS only
-- when Z80 MREQ is active, while are INPUTS otherwise. On the hardware side, the two joystick inputs are sent
-- to two PNP transistors who place a logic '1' on MEMORY_MSB pin when the input is activated, through a 2K2
-- serie resistor and a 4K7 pulldown. The '1' logic level is around 3V, while the 4K7 resistor should be fast
-- enough to pull down the line after a memory access with the corresponding address bank bit HIGH.
--
--
-- $3F RD/WR:	SPI data port
--
--
-- $7F RD/WR:	FASTPAGE register:
-- D7:			'1' = RAM WR enabled (standalone)
-- D6:			'1' = PAGING enabled
-- D5:			'0' = RAM is paged; '1' = ROM is paged
-- D4:D0			Paged BANK (0-31)
--
--
-- Original INTERFACE 1 Pin and I/O ports LEVELS:
--
-- RS-232 2IN/2OUT: no inversion on any (reading/writing '0' on I/O port will report/send -12V on pins)
-- NET IN: no inversion (0V (idle) is read as '0').
-- NET OUT: inversion on TX hardware (no ULA inversion) as output = PNP open emitter transistor, so
-- I/O port output bit should be HIGH for NET = idle.
-- COMMS_OUT (NET/RS-232 select) is inverted in the ULA: '0' (pin = 5V) = NET active; '1' (pin = 0V) = RS-232 active
--
-- Power-on register reads:
-- $EF = F4 or maybe F6.
-- $F7 = 1E
--
-- Default COMMS/DATA status: '0' (NET is enabled) (tested by a single OUT 247,0), which turns ON the JACK (+5V)
-- and then a IN 247 reads 1F (NET = HIGH STATUS).
-- This also confirms that NET output pin is not negated into ULA, but only by the PNP output transistor.
-- NOTE: the OUT 247,0 also resets BUSY bit on $EF port, that will then read E4 instead of F4.
-- Writing OUT 247,254 gives the same result (+5V on jack, BUSY bit low).
--
-- From power-on status, an OUT 239,255 will enable RS-232 port (since D4 is '1', this command also
-- switches the CTS to +7V. CTS is independent from COMMS_DATA. Since the DATA_OUT pin is HIGH by default,
-- the command will switch the "RXDATA" output pin to +7V (was -11V). In these condition, the previous
-- OUT 247,0 will bring the RXDATA back to -11V.
--
-- DTR TEST: placing +5V on DTR will turn the 'dtr' bit (D3 $EF) = '1'
-- CTS TEST: -11V by default, turns to +7V by OUT 239,255 (as seen before)
-- TXDATA TEST: placing +5V on TXDATA will turn the TXDATA (D7 $F7) bit = '1'

-- WAIT TEST:
-- Performing an OUT 239,0 (D4 = BUSY = LOW) have no effect on Z80 WAIT when the NET is resting (0V).
-- If the NET is +5V, then the Z80 WAIT is immediately asserted and kept active until the NET line goes inactive.
-- This also means that issuing such command when the NET is activated by us (OUT 247,0) will hang the system.
--
-- WAIT assertion: IMMEDIATELY after IORQ+WR goes low (approx 90 ns later, asynchronous to clock)
-- WAIT deassertion: after approx 9 clock toggles (no matter the polarity) so about 4 T-states later.
--
-- Problem: our logic may not be able to assert the WAIT fast enough to stop the processor on the I/O
-- execution. Also, the current version deasserts WAIT immediately after the NET line goes inactive.
-- These two behaviour may turn everything into the right way, as we are late on both operation and
-- the resulting delay maybe equivalent to those generated by the original hardware.
-- We also may consider placing a two bits counter for WAIT deassertion, if necessary.
-- NOTE that the original hardware works probably in this way, as a short NET deassertion (a few CLOCK
-- toggles) did not trigger the WAIT release).


--	$EF:
--       Bit    7   6    5    4    3    2    1     0
--            +---------------------------------------+
--        READ|   |   |    |busy| dtr |gap| sync|write|
--            |   |   |    |    |     |   |     |prot.|
--            |---+---+----+----+-----+---+-----+-----|
--       WRITE|   |   |wait| cts|erase|r/w|comms|comms|
--            |   |   |    |    |     |   | clk | data|
--            +---------------------------------------+Port 0xf7
-- If the microdrive is not being used, the COMMS DATA output selects the function of bit 0 of OUT-Port 0xf7:
--
-- $F7:
--       Bit      7    6   5   4   3   2   1       0
--            +------------------------------------------+
--        READ|txdata|   |   |   |   |   |   |    net    |
--            |      |   |   |   |   |   |   |   input   |
--            |------+---+---+---+---+---+---+-----------|
--       WRITE|      |   |   |   |   |   |   |net output/|
--            |      |   |   |   |   |   |   |   rxdata  |
--            +------------------------------------------+--

--
--
-- Our I/O ports:
-- RS-232 2IN/2OUT = should ALL BE INVERTED in the CPLD as we placed a MAX232 line driver.
-- NET OUT: as in original hardware. Since we have separate output pins for RS-232 out and NET out, we are able
-- to invert just the first (for MAX232) and leave the second straight, so the same PNP open-emitter hardware can
-- be used.
-- NET IN: as in original hardware: 10K resistor and 4V7 zener.
--
-- IF1 compatibility: Input on $EF and $F7 only when IF1_ENABLE = LOW (dip switch)
--
-- $EF RD:		RS232_IN -> D7, DTR_IN -> D3 and NET_IN -> D0.
-- $EF WR:		D4 = RS-232 CTS_OUT
--					D0 = COMMS/DATA (INTERNAL output select bit)
--
-- Nell'hardware originale, la linea NET viene letta senza inversione mentre la trasmissione e` invertente
-- (transistor PNP open emitter, manda alta (attiva) la linea quando pilotato BASSO dall'uscita ULA).
-- Il nostro circuito e` identico.
--
-- To simplify the CPLD, ports $EF and $F7 are reading the SAME DATA:
--
-- D0	NET_IN input (only meaningful for $F7 port. On $EF this is microdrive wr protection)
-- D1	Not meaningful (sync on $EF port), reads '0'
-- D2	Not meaningful (gap on $EF port), reads '0'
-- D3 RS-232 DTR_IN (only meaningful for $EF port. Not used on $F7 port)
-- D4:D6 read "000"
-- D7: RS232_IN (only meaningful for $F7 port. Not used on $EF port)
--
--
-- $F7 RD:		as $EF
--	$F7 WR:		D0 = DATA_OUT (the destination of this internal latch is determined by the COMMS_DATA status)
--
--
-- CPLD TEST PROCEDURE:
--
-- PINS (from TOP to BOTTOM):
-- NET
-- RS-232 OUT
-- RS-232 IN
-- DTR IN
-- GND
-- CTS OUT
--
-- On power on, NETWORK is enabled by default. NET pin = 0V (termination jumper should be in place); RS-232 out = -6V
-- A PRINT IN 247 will return 0 (NET line (D0)LOW, RS-232 line (D7)LOW).
-- The 247 register is set to 1 on power on (the NET pin reflects negated value of D0 on 247 port).
--
-- NOTE: THE BOOTROM FIRMWARE SELECTS THE RS-232 AS THE ACTIVE INTERFACE!
--
-- INPUT TEST: always works, regardless of the active interface
-- If a +5V is applied to the NET pin, then PRINT IN 247 should give 1.
-- If a +5V is applied to the RS-232 input pin, then PRINT IN 247 should give 128.
-- If a +5V is applied to the DTR pin, then pring IN 247 should give 8.
--
-- NET OUTPUT TEST:
-- Since the NET is active by default, an OUT 247,0 will bring the NET pin to 5V.
-- If network is not the active interface (for example due to bootrom firmware initialization)
-- it should be activated by an OUT 239,254. This may switch the NET pin to +5V immediately, as the 247 data
-- register is also written by bootrom.
-- Anyway, when NET pin is at +5V, reading port 247 will return 1.
-- Writing 1 to port 247 will turn off the NET pin (0V). Reading 247 will then return 0.
-- 
-- RS-232 OUTPUT TEST:
-- OUT 239 with D4 low (for example 239) will ALWAYS switch the CTS output to -6V.
-- OUT 239, 255 will ALWAYS switch it to +6V.
-- When RS-232 interface is selected (OUT 239, 255 (D0 is meaningful)):
-- OUT 247,1 (power on default) will bring +6V on the RS-232 OUT pin;
-- OUT 247,0 will switch it to -6V.
--
-- WAIT ASSERTION TEST:
-- Writing D5 LOW on 239 port will cause Z80 WAIT STATE while the NET pin is +5V.
-- System is then released as soon as NET pin goes LOW. If the NET pin is kept HIGH by us, then
-- the WAIT is endless.
-- Operation:
-- Select NET by OUT 239,254
-- Assure NET pin LOW by OUT 247,1
-- OUT 239,0: no wait if NET is LOW; machine locked if NET pin is +5V (externally).

--
--
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity X9572_zxmmc2 is port (
	clock, reset:					in std_logic;									-- clock (same as Z80)
	z80_databus:					inout std_logic_vector(7 downto 0);		-- Z80 databus
	z80_iorq, z80_mreq:			in std_logic;
	z80_rd, z80_wr:				in std_logic;									-- iorq, rd, wr
	address:							in std_logic_vector(7 downto 0);			-- Z80 A7:A0
	hi_address:						in std_logic_vector(1 downto 0);			-- Z80 A15:A14
	z80_nmi:							inout std_logic;
	z80_wait:						inout std_logic;

	edge_romcs:						out std_logic;									-- ROMCS1 -> (A4) (fixed); 
--	edge_romcs2:					inout std_logic;								-- ROMCS2 (B15); this is VIDEO on 48/128,
																							-- where ROMCS is B25 (jumpered)
	
	memory_bank:					inout std_logic_vector(4 downto 0);	-- A18:A14 to memory chips
	ram_cs, rom_cs:				out std_logic;
	residos:							in std_logic;									-- D6 status (1 = fastpage enabled)
	ramrom:							in std_logic;									-- D5 status (0 = RAM paged; 1 = ROM paged) (NOT!)
	kempston_enable:				in std_logic;									-- '0' enables $1F read
	if1_enable:						in std_logic;									-- '0' enables $EF and $F7 read
	rs_232in,dtr_in,net_in:		in std_logic;

	kempston:						in std_logic_vector(2 downto 0);			-- remaining (D4:D3) from memory_bank<4:3>
	
	rs_232out, cts_out, net_out: out std_logic;

	OUT1_reg:						out std_logic_vector(1 downto 0);	-- Cards CS
	spi_clock:						out std_logic;
	spi_dataout:					out std_logic;
	spi_datain:						in std_logic
);

end X9572_zxmmc2;

architecture Behavioral of X9572_zxmmc2 is

signal tx_register: 				std_logic_vector(7 downto 0); 		-- shift register trasmissione
signal shift: 						std_logic_vector (6 downto 0);		-- shift register ricezione
signal rx_register: 				std_logic_vector(7 downto 0); 		-- registro ricezione leggibile dallo Z80
signal spi_tx: 					std_logic_vector (3 downto 0);
signal bus_cnt: 					std_logic_vector(1 downto 0);
--signal mmc1_cs, mmc2_cs:		std_logic;
signal fastpage:					std_logic_vector(2 downto 0);			-- D7:D5
signal flashwrite:				std_logic;
signal comms_data, data_out:	std_logic;
signal nmi_enable:				std_logic;
signal wait_cnt:					std_logic_vector(1 downto 0);
signal msb_latch:					std_logic_vector(1 downto 0);

begin


MAIN_PROC: process(clock, reset)
begin

	if reset='0' then

		fastpage(2) <= '0';					-- (D7) RAM WR disabled
		fastpage(1) <= residos;				-- (D6) 1 = fastpaging enabled (jumper selectable)
		fastpage(0) <= not ramrom;			-- (D5) 0 = RAM is paged-in; 1 = ROM is paged-in. 'NOT': OPEN = 1 = RAM IS PAGED
		memory_bank(2 downto 0) <= "000";-- BANK 0
		msb_latch <= "00";
		flashwrite <= '0';					-- flash write disabled
		nmi_enable <= '0';
			
		comms_data <= '0';					-- selects NETWORK. attenzione: questa aggiunta ha comportato una riduzione
													-- sospetta di macrocelle utilizzate (-2)
		data_out <= '1';						-- IDLE network
		
		cts_out <= '1';						-- CTS inactive (negated by MAX232)
		
		wait_cnt <= "00";
			
--		z80_nmi <= 'Z';						-- questa aggiunta ha comportato il passaggio di optimize da 'balance' a 'density'
--		z80_wait <= 'Z';

-- Modifica: con il nuovo transistor che nega il clock, trigger su rising edge '1'
--	elsif (clock'event and clock='0') then
	elsif (clock'event and clock='1') then
	
--		if fastpage(0) = '1' then
--			memory_bank(0) <= romad_lsb;
--		end if;

--		CATTURA DATI SCRITTI DALLO Z80 --> nostri registri
		if z80_wr = '1' or z80_iorq = '1' then
			bus_cnt <= "00";
		else
			bus_cnt <= bus_cnt +1;
			if address = 239 and z80_databus(5) = '0' and net_in = '1' and if1_enable = '0' then
				wait_cnt <= "11";
			end if;

			if bus_cnt = 1 then										-- this happens when BUS_CNT is equal to 2 (one cycle later)
				if address = 31 then
					if z80_databus(7 downto 4) = 10 then		-- 'A' (4 bit LSB = don't care) = codice attivazione FLASH WRITE
						flashwrite <= '1';
					else
						flashwrite <= '0';
						nmi_enable <= z80_databus(3);					-- eventualmente modificare allo stesso modo anche la ZXMMC
						OUT1_reg(1) <= z80_databus(1);				-- MMC1 chip select register - 'NOT' as it's reverted again later
						OUT1_reg(0) <= z80_databus(0);				-- MMC0 chip select register - 'NOT' as it's reverted again later
					end if;
					
				elsif address = 127 then
					fastpage <= z80_databus(7 downto 5);
					msb_latch <= z80_databus(4 downto 3);
					memory_bank(2 downto 0) <= z80_databus(2 downto 0);
				
				elsif address = 239 then
					cts_out <= not z80_databus(4);
					comms_data <= z80_databus(0);
--					if z80_databus(5) = '0' and net_in = '1' and if1_enable = '0' then
----						z80_wait <= '0';
--						wait_cnt <= "11";
--					end if;

				elsif address = 247 then
					data_out <= z80_databus(0);					-- invertito piu` avanti e solo per la linea RS-232 (MAX232)

				elsif address = 63 then
					spi_dataout <= z80_databus(7);								-- first bit in output
					tx_register <= z80_databus(6 downto 0) & '1';			-- tx_register shift. IN => '1' in modo da avere
					spi_tx <= "1111";													-- output alto in caso di lettura della porta
--					spi_clock <= '0';
				
--				elsif address = 253 and hi_address = 1 and fastpage(0) = '1' and lock7ffd = '0' then
				elsif address = 253 and hi_address = 1 and fastpage(0) = '1' then
					memory_bank(0) <= z80_databus(4);
				end if;
			end if;		-- chiusura BUS_CNT = 1
		end if;			-- chiusura z80_wr & z80_iorq


		-- revoca lo stato di WAIT del processore se la linea NET IN e` a riposo (a riposo sarebbe BASSA, ma abbiamo
		-- dovuto invertirla con un NPN a causa della presenza del pullup sul port kempston).
		-- Il WAIT viene asserito su scrittura sul port $EF con D5 = '0' (WAIT SIGNAL for NET synchronization).
		-- NUOVA VERSIONE che attende 4T-states prima di revocare il WAIT; l'hardware originale attende 9 clock toggle
		-- (quindi 4,5T-states).
		-- Questa versione deve essere abbinata al controllo del tri-state del WAIT in modo combinatorio (piu` avanti)
		if net_in = '0' and wait_cnt > 0 then
			wait_cnt <= wait_cnt -1;
		end if;

--		VERSIONE ISTANTANEA (la prima versione)
--		if net_in = '0' then
--			z80_wait <= 'Z';
--		end if;


-- MASTER SPI PORT: gestione simultanea trasmissione/ricezione:
-- TX: il nuovo bit viene posto in output sul fronte di DISCESA del clock da noi generato;
-- RX: l'input pin viene letto sul fronte di SALITA del clock da noi generato.
--
-- Nuova versione con idle clock = '0' per compatibilita` con ENC28J60 Ethernet controller

		if z80_iorq = '0' and z80_rd = '0' and address = 63 and spi_tx = 0 then
			spi_tx <= "1111";
--			spi_clock <= '0';
			spi_dataout <= '1';
		end if;

		if spi_tx > 1 then
			if spi_tx(0) = '0' then
				spi_dataout <= tx_register(7);								-- next bit in output
--				spi_clock <= '0';
				tx_register <= tx_register(6 downto 0) & '1';			-- tx_register shift. IN => '1' in modo da avere
			else																		-- DATAOUT ALTO (inattivo) durante eventuali
--				spi_clock <= '1';													-- ricezioni di bytes
				shift (6 downto 0) <= (shift (5 downto 0) & spi_datain);
			end if;
			spi_tx <= spi_tx -1;
		elsif spi_tx = 1 then
			rx_register <= shift (6 downto 0) & spi_datain;
--			spi_clock <= '1';
			spi_tx <= spi_tx -1;
		end if;
		
		spi_clock <= spi_tx(0);

	end if;		-- chiusura clk'event
end process;

-- Negating output allows default '1' on pins at power-on
--OUT1_reg(0) <= not mmc1_cs;
--OUT1_reg(1) <= not mmc2_cs when OUT1_reg(0) = '1' else '1';	-- prevents both CS low


z80_databus <= rx_register when address = 63 and z80_iorq = '0' and z80_rd = '0' else
	"000" & memory_bank(3) & memory_bank(4) & not kempston when address = 31 and z80_iorq = '0' and z80_rd = '0' and kempston_enable = '0' else
	fastpage & msb_latch & memory_bank(2 downto 0) when address = 127 and z80_iorq = '0' and z80_rd = '0' else
	not rs_232in & "000" & not dtr_in & "00" & net_in when (address = 247 or address = 239) and z80_iorq = '0' and z80_rd = '0' and if1_enable = '0' else
	"ZZZZZZZZ";
	
rs_232out <= not data_out when comms_data = '1' else '1';					-- RS-232 out should be negated due to MAX232
net_out <= data_out when comms_data = '0' else '1';							-- NET out is straight (same TX hardware)

memory_bank(4 downto 3) <= msb_latch when z80_mreq = '0' else "ZZ";		-- memory_bank 4:3 are shared with KEMPSTON INPUTS

ram_cs <= '0' when hi_address = 0 and z80_mreq = '0' and reset = '1' and
	((fastpage(2) = '1' and z80_wr = '0') or (fastpage(1 downto 0) = 2 and z80_rd = '0')) else '1';

rom_cs <= '0' when hi_address = 0 and z80_mreq = '0' and reset = '1' and
	((fastpage(1 downto 0) = 3 and z80_rd = '0') or (flashwrite = '1' and z80_wr = '0')) else '1';


-- formula della V1.1 (prima spedizione Garry).
--edge_romcs <= fastpage(1);

-- questa formula evita l'attivazione della rom interna su cicli di SCRITTURA Z80, dato
-- che pare che cio` possa avvenire sul +2 e forse anche su altri modelli.
edge_romcs <= fastpage(1) or ((fastpage(2) or flashwrite) and z80_rd);

-- RS-232 Data line LOW means START BIT (MAX232). WARNING: The NMI signal follows the RS-232 IN line!
-- This should be disabled immediately by NMI handler (resetting nmi_enable).
-- NMI_ENABLE is writable on D3 of $1F port
z80_nmi <= '0' when  rs_232in = '0' and nmi_enable = '1' else 'Z';

-- Combinatorial WAIT handling (for wait_cnt delayed operation)
z80_wait <= 'Z' when wait_cnt = 0 else '0';

end Behavioral;

