   1k2kJn3KnUn  VnVn ]@0  1k  E  !@                                v        #0k      ~)&9&vv                         APPENDIX A
                    THE BASIC VARIABLES

Quite  a  few  variables  were  defined externally, to save
memory. This means that you  won't  find  any  LET  or  DIM
statements  for  many  variables  used by the program, even
though they are read (and in some cases written to)  within
the program. They represent constants (often-used integers,
GOSUB and GOTO  routine  line  numbers,  and  USR/POKE/PEEK
addresses),  menu  arrays, and pre-defined parameters which
have a "PV" (present value)  but  may  be  changed  by  the
program. The following list details the name, function, and
constant value  (if  applicable)  of  all  externally  pre-
defined variables in the program, in order of definition.

NAME        VALUE           DESCRIPTION
HR          20000           The SHR-EB entry point
KEY         22551           The "key" routine
O           0 (zero)        Constant
H           1000            Home Menu entry
WA          260             "Please Wait" subroutine
SR          250             "Are You Sure?" subroutine
PR          230             "Print Prompt, wait for key"
                            subroutine
ER          220             "Erase Prompt" subroutine
VU          10              View Menu entry point
IN          240             "Input value" subroutine
AS          600             "Assign 16-bit Value to P$"
                            subroutine
MS          290             "Print Message" subroutine
RD          500             "Read FP value in T, convert to

                            16-bit"
K           5               Constant
F           0               Input flag. Controls
                            CLEAR/RUN mode (lower 2 lines) 
                            for single or multiple input.  
VE          1               "Verify" flag
D           2               Constant
MR          1030            Home Menu "return" line number 
W$(12,18)                   Message/prompt swap string
V$(105,10)                  View Menu swap string
H$(91,8)                    Home Menu swap string
S$(81,8)                    Set Menu swap string
D$(73,10)                   Draw Menu swap string
M$(81,7)                    Map Menu swap string
F$(43,6)                    File Menu swap string
C$(43,6)                    Save/Load Menu swap string
U$(73,10)                   User Tools Menu swap string
X$(32)                      Info message accumulator
MD          21377           2-D mode (Tiny, Big or Strange)
BW          3               Bandwidth parameter
Z           10              Gen.-to-Effect plane distance  
R           3               Number of Generators
V           20              Constant
E                           Save/Load flag
Q           1               Normal/F-SAVE flag
Y$(2,4)     "Save"/"Load"   Save/Load menu title
A           -2.4            A-corner (mumap)
B           -1.25           B-corner (mumap)
S           2.5             Side length (mumap)
L           99              Iteration limit (mumap)
G           2.5/96          "Gap" = S/96 (mumap)
W                           "Window-down input" flag
VM          700             View Menu Swap subroutine
HM          710             Home Menu Swap subroutine
MM          720             Map Menu Swap subroutine
DM          730             Draw Menu Swap subroutine
FM          740             File Menu Swap subroutine
SM          750             Set Menu Swap subroutine
UM          770             User Tools Swap subroutine
TS          1               Trace speed

THE OTHER VARIABLES
Here are the rest of the BASIC variables, which are defined
within the program,  but  whose  meanings  are  undoubtedly
obscure without at least a brief description.

T                           General temporary numeric
                            variable,       used      quite
extensively.
T$                          General temporary string
C                           Mumap accumulator
M                           Mumap "Imaginary" counter
N                           Mumap "Real" counter
HI                          High byte of 16-bit number
LO                          Low byte of 16-bit number
Q                           "Which dimension" (temp.)
P$(99,256)                  The main map array.
                            P$(97) through P$(99) represent
                            generator X, Y, and value.
Q$(256)                     Used by the hidden-line
                            subroutine.
I                           General loop counter

SOME ROUTINE ADDRESSES
Here are the meanings of the addresses referred  to  within
the BASIC portion of the program, in order of appearance:

23344     FFP-Mandelbrot set (mumap) routine
23701     LOAD screen, normal mode
23571     SAVE screen, normal mode
22605     Mirror vertically
22702     Mirror horizontally
22639     Draw dots for border
22743     Figure X/Y co-ords of cursor, return value
22812     X position of cursor
22813     Y position of cursor
23583     SAVE variables, normal mode
23622     LOAD variables, normal mode
22288     2-D plots. Which type is selected by MD
22385     Pattern (L or D) sprite number for "Big"
21878     Perspective value
21940     "Front" 3-D plot routine
21879     Scale value for 3-D plots
22961     Density value for "Angle" plot
22962     "Angle" 3-D plot routine
23250     "Generator" plot routine
21376     Fast/Slow display mode flag
16505     "Sea-level" variable (2 bytes)
21580     Scope-scape routine
23173     Scan map for maximum/minimum values
23190     Get minimum value
23196     Rescale routine
21850     Flip map routine
21813     Turn map routine

                         APPENDIX B
                BASIC ROUTINE LINE NUMBERS

Here   are  the  BASIC  routine  addresses.  This  list  is
essentially the REM lines that would have made the  program
more  readable,  had  there  been room for them. First, the
menus:

HOME MENU, line 1000

25        View
1080      Quit
1500      File
2000      Draw
2500      Set

2200      Strange
2250      Front 3-D
2300      Angle 3-D
2350      Generator

SET MENU, line 2500

2600      Fast
2650      Slow
2700      Level
2750      Bandwidth
2800      Verify
2850      Quick
2900      Normal
2950      Return to Home menu
2975      Trace speed

TOOLS MENU, line 3000

9100      User routine 1
9200      User routine 2
9300      User routine 3
9400      User routine 4
9500      User routine 5
9600      User routine 6

MAP MENU, line 3500

4000      Clear
4100      Mumap
4500      Scope
5000      (Re-)Scale
5100      Flip
5150      Turn
5180      Zap

                       OTHER ROUTINES

4         Dummy RETURN (if GOSUB goes to 0)
5         General "KEY" subroutine (alpha chars only)
40        Main Mumap routine
190       64-column message subroutine
195       32-column message routine
220       Erase message subroutine
230       Print prompt, wait for keypress, erase
232       Wait for keypress, then erase
240       Input value subroutine
250       "Are you sure?" subroutine
260       "Please Wait..." subroutine
290       Print message, pause, erase
500       Convert T to 16-bit integer
600       Assign HI/LO to P$(97)-P$(99)
700-775   Menu swap subroutines
1030      Return to home menu
1400      Input filename subroutine
1500      File menu
1510      File menu return
1530      Save/Load menu
1550      All/Data?
1595      Do selected File menu option
1600      Save/Load All
1700      Save/Load Data
1900      Exit file menu
2080      Erase Draw menu, return to Home
2290      Input scale factor
2520      Set Menu return
2625      Print "... mode set" message
3510      Map Menu return
4050      "Map ..." report
4600      Assign/Calculate generators loop
4900      Clear Map & Home menus

                     Appendix C
                     Sample User Tools

Here are a few sample "Tools" routines you might like.

The  first allows you to input any function of X and Y, and
evaluates the function over the "effect plane" for plotting
with  any  of the Draw Menu routines. The other two options
allow you turn the hidden-line routine off  and  on;  there
may  be times when you want a wire-frame drawing (Front 3-D
or Angle 3-D) without hiding the  lines  that  go  "behind"
something.

Start  by  modifying  line 3060 so that it looks as follows
(note that lower-case means inverse):

3060 IF USR HR THEN PRINT AT V+S
GN PI,D;;;"1 fUNCTN";TAB D;"2 uN
hIDE|;TAB D;"3 hIDE";TAB D;"4 uN
USED";TAB D;"5 uNUSED";TAB D;"6
uNUSED"

If you want to add other user routines, now is a good  time
to  add  the  options  to  the menu (replacing the "Unused"
entries for options 4, 5 and 6). Note that you are  limited
to  six  characters  per menu option (7 is borderline). For
instance, "4" might be "DOS" to go into your  disk  system,
"5"  might  be  "Paint" to automatically load ZX-PAINT, and
"6" might be "Dump" (to big printer). Or whatever. It's  up
to you.

When  done modifying the menu, GOTO H, select [T]ools, then
[Y]es. When the menu has been generated, press  [Enter]  to
return to Home Menu, and [Q]uit. Delete lines 3010-3095 and
9399, then enter the following lines:

9100 REM functions
9105 IF USR HR THEN RETURN         :return to normal BASIC 
9110 CLS
9115 PRINT "ENTER A FUNCTION F(X
,Y)","0<=X<=127, 0<=Y<=95"
9120 INPUT A$                      :function in A$
9125 FAST
9130 FOR Y=0 TO 95                 : Y-loop counter
9135 FOR X=0 TO 127                :X-loop counter
9140 LET Q=Y+1                     :Setup for ASsign
9145 LET I=X+1                      subroutine
9150 LET T=INT (VAL A$+.5)         :evaluate function
9155 GOSUB AS                      :assign to P$
9160 NEXT X
9165 NEXT Y
9199 GOTO H                        :return to Home Menu

9200 REM hidden lines off
9205 POKE VAL "21917",VAL "33"
9210 LET T$="FF"
9220 LET X$="hIDDEN LINES o"+T$
9225 GOSUB MS                      :print message
9299 GOTO H
9300 REM hidden lines on
9305 POKE VAL "21917",VAL "34"
9310 LET T$="N"
9315 GOTO VAL "9220"
9399 [delete]

The screen-dump below shows the function:

100* SIN(X/10)* COS(Y/20)* EXP(-X/60)* EXP(-Y/80)

After  generating  the  map  for this function, the map was
[F]lipped. This effectively multiplied the function by  -1.
It  was  also  [T]urned, which effectively replaced all "X"
with "128-X" and all "Y"  with  "96-Y".  Get  it?  If  yes,
great. If no, don't worry about it. Just have fun.

When  drawing,  I selected [A]ngle from the Draw Menu, then
Density=3 and Scale=12. The border and legends  were  added
from  the  immediate  mode using the SHR-EB "IF USR HR THEN
LPRINT   R;"   and  "IF  USR  HR  THEN  PRINT;,"  commands,
respectively.

vv                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v                                v 