/***************************************************************************

  Mini-Pac Copyright (C) 1999 by Michael Balfour.  All Rights Reserved.


  Pac-Man Copyright (C) 1980 by Namco, Ltd.  All Rights Reserved.


  Multi-Z80 32 Bit emulator 
  Copyright (C) 1996-1999 Neil Bradley, All rights reserved
  Author      : Neil Bradley (neil@synthcom.com)
  Distribution: ftp://ftp.synthcom.com/pub/emulators/cpu/makez80.zip (latest)

 ***************************************************************************/

#define NUM_SOUND_VOICES		3
#define NUM_SPRITES				8

typedef struct
{
	int x;
	int y;
	int color;
	int type;
	int directionFacing;
	UCHAR *graphicsPtr;
} SPRITE_STRUCT;

typedef struct
{
	char *name;
	long location;
	long size;
} CODE_ROM;


class Interpreter
{
public:
	Interpreter();
	~Interpreter();

	UCHAR *emuMemory;
    UCHAR *dirtyVideoMemory;

	UCHAR *origPalette;
    UCHAR *origColorLookup;

	UCHAR *tilePtr;

	char  waveBuffer[0x100];

	long  frequency[NUM_SOUND_VOICES];
	long  volume[NUM_SOUND_VOICES];
	long  wave[NUM_SOUND_VOICES];
	bool  soundEnable;

	SPRITE_STRUCT	spriteList[NUM_SPRITES];

	void Interpret(void);

protected:

	UCHAR *spritePtr;
	UCHAR *spriteHFlipPtr;
	UCHAR *spriteVFlipPtr;
	UCHAR *spriteHVFlipPtr;

	bool InitEmuMemory(CODE_ROM *romList);
	void InitInputPorts(void);
	void InitGraphics(void);
	void InitSprites(void);
	void InitColors(void);
	void InitSound(void);

	void DecodeTiles(UCHAR *srcBuffer, UCHAR *destBuffer);
	void DecodeSprites(UCHAR *srcBuffer, UCHAR *destBuffer);
	void FlipSpritesHoriz(UCHAR *srcBuffer, UCHAR *flipBuffer);
	void FlipSpritesVert(UCHAR *srcBuffer, UCHAR *flipBuffer);
	void FlipSpritesHorizVert(UCHAR *srcBuffer, UCHAR *flipBuffer);

	void InterpretSprites(void);

	void InterpretSound(void);

};

