/***************************************************************************

  Mini-Pac Copyright (C) 1999 by Michael Balfour.  All Rights Reserved.


  Pac-Man Copyright (C) 1980 by Namco, Ltd.  All Rights Reserved.


  Multi-Z80 32 Bit emulator 
  Copyright (C) 1996-1999 Neil Bradley, All rights reserved
  Author      : Neil Bradley (neil@synthcom.com)
  Distribution: ftp://ftp.synthcom.com/pub/emulators/cpu/makez80.zip (latest)

 ***************************************************************************/

// INCLUDES ///////////////////////////////////////////////////////////////////

#include "MiniPac.h"

extern UCHAR *emu_mem;

MiniPac            *miniPac;      // Mini-Pac primary game engine

// DEFINES ////////////////////////////////////////////////////////////////////

#define WINDOW_CLASS_NAME "WINDOW_CLASS" // this is the name of the window class

// WINDOWS CALLBACK FUNCTION //////////////////////////////////////////////////		             

// this is the main message handler of the system
LRESULT CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{

	PAINTSTRUCT ps;			// used to hold the paint info

	// what is the message?

	switch(msg)
	{	
		case WM_CREATE:
		{
			// do windows inits here
			return(0);
		} break;

		case WM_PAINT:
		{
			// this message occurs when your window needs repainting
			BeginPaint(hwnd,&ps);	 
			EndPaint(hwnd,&ps);
		
			return(0);
   		} break;

        case WM_KEYDOWN:
            // Handle any non-accelerated key commands
        	switch (wparam)
        	{
				case VK_UP:
					emu_mem[0x5000] &= 0xFE;	break;
				case VK_LEFT:
					emu_mem[0x5000] &= 0xFD;	break;
				case VK_RIGHT:
					emu_mem[0x5000] &= 0xFB;	break;
				case VK_DOWN:
					emu_mem[0x5000] &= 0xF7;	break;
				case '1':
					emu_mem[0x5040] &= 0xDF;	break;
				case '2':
					emu_mem[0x5040] &= 0xBF;	break;
				case '3':
					emu_mem[0x5000] &= 0xDF;	break;
				case 'U':
					miniPac->Unthrottle();      break;
				case 'R':
					miniPac->Reset();           break;
            	case VK_ESCAPE:
            	    PostMessage(hwnd, WM_CLOSE, 0, 0);
                    return 0L;
        	}
        	break;

        case WM_KEYUP:
            // Handle any non-accelerated key commands
        	switch (wparam)
        	{
				case VK_UP:
					emu_mem[0x5000] |= 0x01;	break;
				case VK_LEFT:
					emu_mem[0x5000] |= 0x02;	break;
				case VK_RIGHT:
					emu_mem[0x5000] |= 0x04;	break;
				case VK_DOWN:
					emu_mem[0x5000] |= 0x08;	break;
				case '1':
					emu_mem[0x5040] |= 0x20;	break;
				case '2':
					emu_mem[0x5040] |= 0x40;	break;
				case '3':
					emu_mem[0x5000] |= 0x20;	break;
				case 'U':
					miniPac->Throttle();        break;
        	}
        	break;

		case WM_DESTROY:
		{
			// this message is sent when your window is destroyed
			PostQuitMessage(0);
			return(0);
		} break;

		default:break;

    } // end switch

	// let windows process any messages that we didn't take care of 
	return (DefWindowProc(hwnd, msg, wparam, lparam));

} // end WinProc

// WINMAIN ////////////////////////////////////////////////////////////////////

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPSTR sCmdLine,
					int nCmdShow)
{
	WNDCLASSEX		winclass;	// this holds the windows class info
	HWND			hwnd;		// this holds the handle of our new window
	MSG				msg;		// this holds a generic message

    if (!hPrevInstance)
    {
	    // first fill in the window class stucture

	    winclass.cbSize			= sizeof(WNDCLASSEX);
	    winclass.style			= CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	    winclass.lpfnWndProc	= WindowProc;
	    winclass.cbClsExtra		= 0;
	    winclass.cbWndExtra		= 0;
	    winclass.hInstance		= hInstance;
	    winclass.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
	    winclass.hIconSm		= LoadIcon(NULL, IDI_APPLICATION);
	    winclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	    winclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	    winclass.lpszMenuName	= NULL;
	    winclass.lpszClassName	= WINDOW_CLASS_NAME;
	
	    // register the window class
	    if (!RegisterClassEx(&winclass))
		    return(0);
    }

	// create the window
	if (!(hwnd = CreateWindowEx(WS_EX_TOPMOST,
								WINDOW_CLASS_NAME,					// class
								"Mini-Pac",            				// title
								WS_VISIBLE | WS_POPUP,
						 		0,0,								// x,y
								GetSystemMetrics(SM_CXSCREEN),
								GetSystemMetrics(SM_CYSCREEN),				
								NULL,								// parent
								NULL,								// menu
								hInstance,							// instance
								NULL)))								// creation parms
		return(0);

	ShowWindow(hwnd,nCmdShow);
	UpdateWindow(hwnd);
	SetFocus(hwnd);
	// hide the mouse cursor
	ShowCursor(false);

    try
    {
	    // initialize game
        miniPac = new MiniPac(hwnd);
    }
    catch (char *e)
    {
    	ShowCursor(true);
        MessageBox(hwnd,e,"Error",MB_OK);
		DestroyWindow(hwnd);
        return 0;
    }


	// enter main event loop
	while(1)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{ 
			// test if this is a quit
			if (msg.message == WM_QUIT)
				break;
	
			// translate any accelerator keys
			TranslateMessage(&msg);

			// send the message to the window proc
			DispatchMessage(&msg);
		} // end if
		else
		{
            miniPac->ExecuteFrame();
		} // end else

    } // end while

	// shutdown game
    delete miniPac;

	DestroyWindow(hwnd);

    // return to Windows
	return(msg.wParam);

} // end WinMain

