/***************************************************************************

  Mini-Pac Copyright (C) 1999 by Michael Balfour.  All Rights Reserved.


  Pac-Man Copyright (C) 1980 by Namco, Ltd.  All Rights Reserved.


  Multi-Z80 32 Bit emulator 
  Copyright (C) 1996-1999 Neil Bradley, All rights reserved
  Author      : Neil Bradley (neil@synthcom.com)
  Distribution: ftp://ftp.synthcom.com/pub/emulators/cpu/makez80.zip (latest)

 ***************************************************************************/

/* Visual C define for smaller, faster header files */
#define WIN32_LEAN_AND_MEAN  

#include <windows.h>         // include the standard windows stuff
#include <windowsx.h>        // include the 32 bit stuff
#include <mmsystem.h>        // include the multi media stuff
							 // note you need winmm.lib also

#include <ddraw.h>           // include direct draw components
#include <dsound.h>			 // include direct sound components

#include <stdlib.h>			 // include all the good stuff
#include <stdio.h>
#include <math.h>
#include <float.h>

#include "Interpreter.h"
#include "pac2d.h"
#include "PacEngine.h"
#include "Sound.h"

// DEFINES ////////////////////////////////////////////////////////////////////

// defines for screen parameters

#define SCREEN_WIDTH     640          // the width of the viewing surface
#define SCREEN_HEIGHT    480          // the height of the viewing surface
#define SCREEN_BPP       8            // the bits per pixel
#define MAX_COLORS       256          // the maximum number of colors

// TYPES /////////////////////////////////////////////////////////////////////

typedef unsigned char  UCHAR;

// MiniPac Class

class MiniPac
{
public:
	MiniPac(HWND hwnd);
	~MiniPac();

    int ExecuteFrame(void);
    void Throttle(void);
    void Unthrottle(void);
    void Reset(void);

protected:
    Interpreter			*pacInterpreter;
    Pac2D				*pac2D;
    PacEngine			*pacEngine;
	PacSound			*pacSound;

    LPDIRECTDRAW         ddObject;
    LPDIRECTDRAWSURFACE  ddPrimarySurface;
    LPDIRECTDRAWSURFACE  ddOffscreenSurface;
    LPDIRECTDRAWPALETTE  ddPalette;           		// a pointer to the created dd palette
    PALETTEENTRY         color_palette[256];		// holds the shadow palette entries

	LARGE_INTEGER	timerFreq;
	LARGE_INTEGER	timerValue;
	LARGE_INTEGER	lastTimerValue;
	LARGE_INTEGER	timeTillSecond;
	LARGE_INTEGER	frameFreq;
	LARGE_INTEGER	realFrameFreq;
	LARGE_INTEGER	frameValue;
	LARGE_INTEGER	lastFrameValue;
	LARGE_INTEGER	timeTillFrame;
	long			fps;

    void DDInit(HWND hwnd);
    void DDShutdown(void);
    void CreateSurfaces(void);
    void InitPalette(void);
};

