/***************************************************************************

  Pac-X Copyright (C) 1999 by Michael Balfour.  All Rights Reserved.


  Pac-Man Copyright (C) 1980 by Namco, Ltd.  All Rights Reserved.


  Multi-Z80 32 Bit emulator 
  Copyright (C) 1996-1999 Neil Bradley, All rights reserved
  Author      : Neil Bradley (neil@synthcom.com)
  Distribution: ftp://ftp.synthcom.com/pub/emulators/cpu/makez80.zip (latest)

 ***************************************************************************/

class PacSound
{
public:
	PacSound(Interpreter *com, HWND hwnd);
	~PacSound();

	void EnableSound(void);
	void DisableSound(void);
	void SetWaveform(int voice, int wave);
	void PlayFrame(void);

protected:
    Interpreter *c;

	LPDIRECTSOUND ddSound;
	LPDIRECTSOUNDBUFFER dsBuffer[NUM_SOUND_VOICES];

	long lastVolume[NUM_SOUND_VOICES];
	long lastFrequency[NUM_SOUND_VOICES];
	long lastWaveform[NUM_SOUND_VOICES];

	char *wavePtr[8];

	bool soundEnable;

	void InitWaveBuffers(void);
	void CreateBuffers(void);
};

