/***************************************************************************

  Mini-Pac Copyright (C) 1999 by Michael Balfour.  All Rights Reserved.


  Pac-Man Copyright (C) 1980 by Namco, Ltd.  All Rights Reserved.


  Multi-Z80 32 Bit emulator 
  Copyright (C) 1996-1999 Neil Bradley, All rights reserved
  Author      : Neil Bradley (neil@synthcom.com)
  Distribution: ftp://ftp.synthcom.com/pub/emulators/cpu/makez80.zip (latest)

 ***************************************************************************/

#include "minipac.h"

/////////////////////////////////////////////////////////////////////////////////////////////

Pac2D::Pac2D(const LPDIRECTDRAW ddObj, Interpreter *com)
{
    ddObject = ddObj;

    c = com;
}

/////////////////////////////////////////////////////////////////////////////////////////////

Pac2D::~Pac2D()
{
}

/*-----------------------------------------------------------------------------
   Name: CreateSurface()
   Desc: Create our DirectDraw surface
  -----------------------------------------------------------------------------*/

void Pac2D::InitPalette(PALETTEENTRY *colorPalette)
{
    int i;
    int bit0, bit1, bit2;

	for (i = 0; i < 0x20; i++)
    {
        bit0 = (c->origPalette[i] >> 0) & 0x01;
        bit1 = (c->origPalette[i] >> 1) & 0x01;
        bit2 = (c->origPalette[i] >> 2) & 0x01;

        colorPalette[i].peRed = 0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2;

        bit0 = (c->origPalette[i] >> 3) & 0x01;
        bit1 = (c->origPalette[i] >> 4) & 0x01;
        bit2 = (c->origPalette[i] >> 5) & 0x01;

        colorPalette[i].peGreen = 0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2;

        bit0 = 0;
        bit1 = (c->origPalette[i] >> 6) & 0x01;
        bit2 = (c->origPalette[i] >> 7) & 0x01;

        colorPalette[i].peBlue = 0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2;

        colorPalette[i].peFlags = PC_NOCOLLAPSE;
    }

    return;
}

/////////////////////////////////////////////////////////////////////////////////////////////

void Pac2D::Draw(UCHAR *vidBuffer)
{
    DrawScreen(vidBuffer);
    DrawSprites(vidBuffer);
}

/////////////////////////////////////////////////////////////////////////////////////////////

void Pac2D::DrawScreen(UCHAR *vidBuffer)
{
	UCHAR *t;
	UCHAR *v;
	UCHAR *mem;
	UCHAR *color;

	mem = &(c->emuMemory[0x4000]);
	color = &(c->emuMemory[0x4400]);

	for(int tile = 0; tile < 0x400; tile++)
	{
		if (c->dirtyVideoMemory[tile])
		{
			int tx, ty, tmp;

			tx = (31 - (tile / 32)) * 8;
			ty = (tile % 32) * 8;

			// The first and last two rows turn into the first
			// and last two columns, thanks to the video hardware.
			if (tx < 16)
			{
				tmp = tx;
				tx = (256 - ty) - 16;
				ty = 8 - tmp;
			}
			else if (tx >= 240)
			{
				tmp = tx;
				tx = (256 - ty) - 16;
				ty = (280 + 240) - tmp;
			}
			else
			{
				ty += 16;
				tx -= 16;
			}
				
			// don't draw first and last two rows
			if ((tx >= 0) && (tx < 224))
			{
				c->dirtyVideoMemory[tile] = 0;

				t = &(c->tilePtr[mem[tile] * (8*8)]);
				v = &(vidBuffer[ty*SCREEN_WIDTH + tx]);

				for(int y = 0; y < 8; y++)
				{
					for (int x = 0; x < 8; x++)
					{
						*v = c->origColorLookup[*t + (color[tile] & 0x1F)*4];
						v++;
						t++;
					}

					v+=SCREEN_WIDTH-8;
				}
			}
		}
	}
}


/////////////////////////////////////////////////////////////////////////////////////////////

void Pac2D::DrawSprites(UCHAR *video_buffer)
{
	UCHAR *s;
	UCHAR *v;

	for(int sprite = 0; sprite < NUM_SPRITES; sprite++)
	{
		int dirty_offset;
		int sx,sy;
		int total_x,total_y;
		int pixel;
		int color;

		sx    = c->spriteList[sprite].x;
		sy    = c->spriteList[sprite].y;
		color = c->spriteList[sprite].color;
		s     = c->spriteList[sprite].graphicsPtr;
		
		/* A 16x16 sprite can overlap at most 9 8x8 tiles */
		dirty_offset = ((0x3E0 - 4*sx) & 0x3E0) + ((sy / 8) & 0x01F);
		if ((dirty_offset > 0x1F) && (dirty_offset < 0x3DE))
		{
			c->dirtyVideoMemory[dirty_offset + 0x00] = 1;
			c->dirtyVideoMemory[dirty_offset + 0x01] = 1;
			c->dirtyVideoMemory[dirty_offset + 0x02] = 1;
			c->dirtyVideoMemory[dirty_offset - 0x20] = 1;
			c->dirtyVideoMemory[dirty_offset - 0x1F] = 1;
			c->dirtyVideoMemory[dirty_offset - 0x1E] = 1;
			c->dirtyVideoMemory[dirty_offset + 0x20] = 1;
			c->dirtyVideoMemory[dirty_offset + 0x21] = 1;
			c->dirtyVideoMemory[dirty_offset + 0x22] = 1;
		}

		// Offset our sprites by 16 due to the funky video hardware
		sx -= 16;
		sy += 16;

		v = &(video_buffer[sy*SCREEN_WIDTH + sx]);

		for(int y = 0; y < 16; y++)
		{
			total_y = sy+y;

			for (int x = 0; x < 16; x++)
			{
				total_x = sx+x;

				// only draw on-screen sprites
				if ((total_x >= 0) && (total_x < 224) && (total_y < (256 + 16)))
				{
					pixel = c->origColorLookup[*s + color*4];
					// 0 is transparent
					if (pixel != 0)
						*v = pixel;
				}
				v++;
				s++;
			}

			v+=SCREEN_WIDTH-16;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////

void Pac2D::DrawFPS(UCHAR *video_buffer, int val)
{
	UCHAR *t;
	UCHAR *v;

	int num = val;

    if (num < 0) num = 0;


	for(int i = 3; i >= 0; i--)
	{
		int tile;
		int tx, ty;

		tile = num % 10;
		num = num / 10;
		
		tx = 96 + i*8;
		ty = 288;

		t = &(c->tilePtr[tile * (8*8)]);
		v = &(video_buffer[ty*SCREEN_WIDTH + tx]);

		for(int y = 0; y < 8; y++)
		{
			for (int x = 0; x < 8; x++)
			{
				*v = c->origColorLookup[*t + 4];
				v++;
				t++;
			}

			v+=SCREEN_WIDTH-8;
		}
	}
}
