/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import smsqmulator.cpu.MC68000Cpu;

public class Beep {
    private static final boolean BIG_ENDIAN = true;
    private boolean canPlay = true;
    private SourceDataLine sdl;
    private static final float SAMPLE_RATE = 44100.0f;
    private static final int channels = 1;
    private static final int bits = 8;
    private static final boolean SIGNED = false;
    private static final double RAD = Math.PI * 2;
    private double vol = 1.0;
    private int beepStateInSysvars = 0;
    private FloatControl volume;

    public Beep(int n) {
        try {
            AudioFormat audioFormat = new AudioFormat(44100.0f, 8, 1, false, true);
            this.sdl = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, audioFormat));
            this.sdl.open(audioFormat);
        }
        catch (Exception exception) {
            this.canPlay = false;
            return;
        }
        try {
            this.volume = (FloatControl)this.sdl.getControl(FloatControl.Type.VOLUME);
            this.setVolume(n);
        }
        catch (Exception exception) {
            try {
                this.volume = (FloatControl)this.sdl.getControl(FloatControl.Type.MASTER_GAIN);
                this.setVolume(n);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public Beep() {
        this(100);
    }

    public final void setVolume(int n) {
        if (this.volume == null) {
            return;
        }
        float f = this.volume.getMaximum();
        float f2 = this.volume.getMinimum();
        float f3 = f - f2;
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        f3 = n == 0 ? f2 : f3 * ((float)n / 100.0f) + f2;
        try {
            this.volume.setValue(f3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void killSound(MC68000Cpu mC68000Cpu) {
        if (this.canPlay) {
            this.sdl.flush();
            this.sdl.stop();
            mC68000Cpu.writeMemoryByte(this.beepStateInSysvars, 0);
        }
    }

    private int makePitch(int n) {
        double d = n - 1;
        double d2 = 10.6 + d;
        return (int)(11447.0 / d2) & 0xFFFF;
    }

    private int makeDuration(int n) {
        if (n == 0) {
            return n;
        }
        return (n /= 25) == 0 ? 1 : n;
    }

    public void play(MC68000Cpu mC68000Cpu) {
        int n;
        if (!this.canPlay) {
            return;
        }
        this.killSound(mC68000Cpu);
        if (this.volume.getValue() == this.volume.getMinimum()) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = 4;
        int n5 = mC68000Cpu.addr_regs[3] + 1;
        int n6 = mC68000Cpu.readMemoryByte(n5++) & 0xFF;
        this.beepStateInSysvars = mC68000Cpu.addr_regs[6] + 150;
        int n7 = mC68000Cpu.readMemoryLong(n5);
        n5 += 4;
        int n8 = n = mC68000Cpu.readMemoryByte(n5++) & 0xFF;
        int n9 = (n7 & n4) == 0 ? mC68000Cpu.readMemoryByte(n5) & 0xFF : -1;
        ++n5;
        if ((n7 & (n4 <<= 2)) == 0) {
            n2 = mC68000Cpu.readMemoryByte(n5++) & 0xFF;
            n2 += (mC68000Cpu.readMemoryByte(n5++) & 0xFF) << 8;
            n2 = this.makeDuration(n2);
        } else {
            n5 += 2;
        }
        n4 <<= 4;
        int n10 = mC68000Cpu.readMemoryByte(n5++) & 0xFF;
        if ((n10 += (mC68000Cpu.readMemoryByte(n5++) & 0xFF) << 8) == 0) {
            this.killSound(mC68000Cpu);
            return;
        }
        n10 = this.makeDuration(n10);
        if ((n7 & n4) == 0) {
            n3 = mC68000Cpu.readMemoryByte(n5++);
            if (n6 == 8) {
                n3 >>>= 4;
            }
            if (((n3 &= 0xF) & 8) != 0) {
                n3 |= 0xFFFFFFF0;
            }
        }
        if ((n10 = (int)(44100.0f * (float)n10 / 1000.0f)) % 2 == 1) {
            ++n10;
        }
        byte[] byArray = new byte[n10];
        if (n3 != 0 && n2 > 0 && n9 > 0) {
            n2 = 44100 * n2 / 1000;
        } else {
            n9 = n;
            n2 = n10;
        }
        if (n < n9) {
            n4 = n;
            n = n9;
            n9 = n4;
        }
        int n11 = 0;
        double d = 1.4247585730565955E-4;
        double d2 = 127.0 * this.vol;
        int n12 = this.makePitch(n8);
        for (int i = 0; i < n10; ++i) {
            double d3 = (double)(i * n12) * d;
            byArray[i] = (byte)(Math.sin(d3) * d2);
            if (++n11 != n2) continue;
            if ((n8 += n3) > n || n8 < n9) {
                n8 += (n3 *= -1) * 2;
            }
            n12 = this.makePitch(n8);
            n11 = 0;
        }
        mC68000Cpu.writeMemoryByte(this.beepStateInSysvars, 1);
        PlayThread playThread = new PlayThread(byArray, mC68000Cpu);
        playThread.start();
    }

    private class PlayThread
    extends Thread {
        private final byte[] soundArray;
        private final MC68000Cpu cpu;

        public PlayThread(byte[] byArray, MC68000Cpu mC68000Cpu) {
            this.soundArray = byArray;
            this.cpu = mC68000Cpu;
        }

        @Override
        public void run() {
            try {
                Beep.this.sdl.start();
                Beep.this.sdl.write(this.soundArray, 0, this.soundArray.length);
                PlayThread.sleep(1L);
                Beep.this.sdl.drain();
                Beep.this.killSound(this.cpu);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

