/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

public class CircularBuffer<T> {
    private final T[] buffer;
    private int tail;
    private final int capacity;
    private int elements;

    public CircularBuffer() {
        this(10);
    }

    public CircularBuffer(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[n];
        this.capacity = n;
        this.tail = 0;
        this.elements = 0;
    }

    public void add(T t) {
        if (t == null) {
            return;
        }
        ++this.tail;
        if (this.tail == this.capacity) {
            this.tail = 0;
        } else {
            ++this.elements;
        }
        if (this.elements > this.capacity) {
            this.elements = this.capacity;
        }
        this.buffer[this.tail] = t;
    }

    public void addNoDoubles(T t) {
        if (t == null) {
            return;
        }
        if (this.buffer[this.tail] != null && t.equals(this.buffer[this.tail])) {
            return;
        }
        this.add(t);
    }

    public T getlast() {
        return this.buffer[this.tail];
    }

    public T get(int n) {
        if (n > this.elements) {
            return null;
        }
        int n2 = this.tail - n;
        if (n2 < 0) {
            n2 = this.capacity - n2;
        }
        return this.buffer[n2];
    }

    public String toString() {
        return "CircularBuffer (size= " + this.capacity + "Number of elements already in buffer= " + this.elements + ")";
    }
}

