/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import smsqmulator.Localization;
import smsqmulator.SpringUtilities;

public class DriveAssignmentsDialog
extends JDialog {
    private String[] options = new String[8];
    private JTextField[] tf1;
    private JFileChooser fc;
    private boolean acceptChanges = false;

    public DriveAssignmentsDialog(Frame frame, boolean bl, String[] stringArray, String string, boolean bl2, String string2) {
        super(frame, bl);
        JButton jButton;
        if (stringArray == null || stringArray.length != 8) {
            return;
        }
        this.initComponents();
        this.setTitle(Localization.Texts[35]);
        System.arraycopy(stringArray, 0, this.options, 0, 8);
        this.tf1 = new JTextField[8];
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new SpringLayout());
        for (int i = 0; i < 8; ++i) {
            if (this.options[i] == null) {
                this.options[i] = "";
            }
            jPanel.add(new JLabel(string + (1 + i)));
            this.tf1[i] = new JTextField(this.options[i]);
            Dimension dimension = this.tf1[i].getPreferredSize();
            if (dimension.width < 200) {
                dimension.width = 200;
                this.tf1[i].setPreferredSize(dimension);
            }
            jPanel.add(this.tf1[i]);
            jButton = new JButton("...");
            jButton.setMnemonic(i);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DriveAssignmentsDialog.this.dirButtonsActionPerformed(actionEvent);
                }
            });
            dimension = jButton.getPreferredSize();
            dimension.width = 50;
            jButton.setPreferredSize(new Dimension(dimension));
            jPanel.add(jButton);
        }
        jButton = new JButton(Localization.Texts[46]);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriveAssignmentsDialog.this.OKButtonActionPerformed(false);
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriveAssignmentsDialog.this.OKButtonActionPerformed(true);
            }
        });
        jPanel.add(jButton);
        jPanel.add(new JLabel(""));
        SpringUtilities.makeCompactGrid(jPanel, 9, 3, 5, 5, 5, 5);
        container.add(jPanel);
        container.add(new JLabel(Localization.Texts[151] + string2));
        this.pack();
        this.fc = new JFileChooser();
        if (bl2) {
            this.fc.setFileSelectionMode(1);
        } else {
            this.fc.setFileSelectionMode(2);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriveAssignmentsDialog.this.OKButtonActionPerformed(false);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.rootPane.registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void dirButtonsActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        int n = jButton.getMnemonic();
        String string = this.options[n];
        if (!string.isEmpty()) {
            this.fc.setCurrentDirectory(new File(string));
        }
        if (this.fc.showOpenDialog(this) == 0) {
            this.options[n] = this.fc.getSelectedFile().getAbsolutePath();
            this.tf1[n].setText(this.options[n]);
        }
    }

    private void OKButtonActionPerformed(boolean bl) {
        this.acceptChanges = bl;
        if (bl) {
            for (int i = 0; i < 8; ++i) {
                this.options[i] = this.tf1[i].getText().replaceAll(File.separator + "{2,}", File.separator);
            }
        }
        this.setVisible(false);
    }

    public boolean adoptChanges(String[] stringArray, int n, int n2) {
        this.acceptChanges = false;
        if (stringArray.length != 8) {
            return false;
        }
        this.setLocation(n, n2);
        this.setVisible(true);
        return this.acceptChanges;
    }

    public String[] getOptions() {
        return (String[])this.options.clone();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.pack();
    }
}

