/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import smsqmulator.Helper;
import smsqmulator.Localization;
import smsqmulator.cpu.MC68000Cpu;

public class FloppyDriver {
    private final RandomAccessFile[] raFile;
    private final FileChannel[] ioChannel;
    private final String[] nativeFile;
    private final int[] flpType;
    private MC68000Cpu cpu;
    public static final int QL5A = 1363948865;
    public static final int QL5B = 1363948866;
    private static final int s720K = 737280;
    private final int usage = 1179406384;
    private final boolean[] driveStatusChanged = new boolean[]{true, true, true, true, true, true, true, true};
    private final IniFile inifile;
    private final boolean[] readOnly = new boolean[]{false, false, false, false, false, false, false, false};

    public FloppyDriver(MC68000Cpu mC68000Cpu, IniFile iniFile) {
        this.cpu = mC68000Cpu;
        this.raFile = new RandomAccessFile[8];
        this.ioChannel = new FileChannel[8];
        this.nativeFile = new String[8];
        this.flpType = new int[8];
        this.inifile = iniFile;
    }

    public boolean setNames(String[] stringArray, boolean bl, int n) {
        if (this.inifile.getTrueOrFalse("DISABLE-FLP-DEVICE")) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            boolean bl2;
            boolean bl3;
            this.driveStatusChanged[i] = true;
            boolean bl4 = bl3 = this.nativeFile[i] != null && !this.nativeFile[i].isEmpty();
            boolean bl5 = bl3 ? this.raFile[i] != null : false;
            if (stringArray[i] == null || stringArray[i].isEmpty()) {
                if (!bl5) continue;
                this.raFileClose(i);
                continue;
            }
            if (bl5 && stringArray[i].equals(this.nativeFile[i])) continue;
            this.readOnly[i] = false;
            OpenFileCheck openFileCheck = new OpenFileCheck();
            openFileCheck.checkDrive(stringArray[i]);
            boolean bl6 = bl2 = openFileCheck.errStr == null;
            if (!bl2 && openFileCheck.errStr.contains(Localization.Texts[123])) {
                bl2 = true;
                this.readOnly[i] = true;
                if (this.inifile.getTrueOrFalse("WARN-ON-FLPDRIVE-READ-ONLY")) {
                    stringBuilder.append(openFileCheck.errStr).append("\n)");
                }
            }
            if (bl2) {
                if (this.raFile[i] != null) {
                    this.raFileClose(i);
                }
                this.raFile[i] = openFileCheck.raFile;
                this.ioChannel[i] = openFileCheck.ioChannel;
                this.flpType[i] = openFileCheck.flpType;
                continue;
            }
            if (bl3 && bl5) {
                this.raFileClose(i);
            }
            stringBuilder.append(openFileCheck.errStr).append("\n");
        }
        System.arraycopy(stringArray, 0, this.nativeFile, 0, 8);
        if (stringBuilder.length() != 0 && bl && this.inifile.getTrueOrFalse("WARN-ON-NONEXISTING-FLPDRIVE")) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[81] + "\n" + stringBuilder.toString(), null);
            return false;
        }
        return true;
    }

    public void readSector() {
        int n = this.cpu.readMemoryLong(this.cpu.addr_regs[7]);
        int n2 = (this.cpu.data_regs[7] & 0xFFFF) - 1;
        if (n2 < 0 || n2 > 7 || this.raFile[n2] == null) {
            this.cpu.data_regs[0] = -16;
            return;
        }
        long l = this.calculatePosition(n, n2);
        try {
            this.ioChannel[n2].position(l);
            this.cpu.readFromFile(this.cpu.addr_regs[1], 512, this.ioChannel[n2]);
            this.cpu.data_regs[0] = 0;
            this.cpu.data_regs[2] = 1;
        }
        catch (Exception exception) {
            this.cpu.data_regs[0] = -16;
        }
        this.cpu.data_regs[0] = 0;
    }

    public void writeSector() {
        int n = this.cpu.readMemoryLong(this.cpu.addr_regs[7]);
        int n2 = (this.cpu.data_regs[7] & 0xFFFF) - 1;
        if (this.readOnly[n2]) {
            this.cpu.data_regs[0] = -20;
            return;
        }
        if (n2 < 0 || n2 > 7 || this.raFile[n2] == null) {
            this.cpu.data_regs[0] = -16;
            return;
        }
        long l = this.calculatePosition(n, n2);
        try {
            this.ioChannel[n2].position(l);
            this.cpu.writeToFile(this.cpu.addr_regs[1], 512, this.ioChannel[n2]);
            this.cpu.data_regs[0] = 0;
            this.cpu.data_regs[2] = 1;
        }
        catch (Exception exception) {
            this.cpu.data_regs[0] = -16;
        }
    }

    public void formatDrive() {
        Comparable<File> comparable;
        int n = this.cpu.data_regs[2] & 0xFF;
        int n2 = (this.cpu.data_regs[7] & 0xFFFF) - 1;
        if (this.nativeFile[n2] == null || this.nativeFile[n2].isEmpty()) {
            this.cpu.data_regs[0] = -14;
            return;
        }
        if (this.raFile[n2] == null) {
            comparable = new File(this.nativeFile[n2]);
            try {
                if (((File)comparable).exists()) {
                    this.cpu.data_regs[0] = -14;
                    return;
                }
                this.raFile[n2] = new RandomAccessFile(this.nativeFile[n2], "rw");
                this.ioChannel[n2] = this.raFile[n2].getChannel();
            }
            catch (Exception exception) {
                this.cpu.data_regs[0] = -14;
                return;
            }
        }
        try {
            this.ioChannel[n2].truncate(0L);
            this.ioChannel[n2].position(0L);
            if (n != 2) {
                comparable = ByteBuffer.allocate(737280);
                this.flpType[n2] = 1363948865;
                n = 9;
            } else {
                comparable = ByteBuffer.allocate(1474560);
                this.flpType[n2] = 1363948866;
                n = 18;
            }
            for (int i = 0; i < ((Buffer)((Object)comparable)).capacity(); i += 4) {
                ((ByteBuffer)comparable).putInt(i, 0x30303030);
            }
            this.ioChannel[n2].write((ByteBuffer)comparable);
            this.ioChannel[n2].force(true);
            this.cpu.data_regs[1] = this.cpu.data_regs[2] = n;
            this.cpu.data_regs[0] = 0;
        }
        catch (Exception exception) {
            this.cpu.data_regs[0] = -14;
        }
    }

    private long calculatePosition(int n, int n2) {
        int n3 = n >>> 16;
        int n4 = n >> 8 & 0xFF;
        n &= 0xFF;
        if (this.flpType[n2] == 1363948865) {
            return (long)n3 * 18L * 512L + (long)(n4 * 9 * 512) + (long)((n - 1) * 512);
        }
        return (long)n3 * 36L * 512L + (long)(n4 * 18 * 512) + (long)((n - 1) * 512);
    }

    public void checkDriveStatus() {
        int n = (this.cpu.data_regs[7] & 0xFFFF) - 1;
        if (this.driveStatusChanged[n]) {
            int n2 = this.cpu.addr_regs[4] + 36;
            this.cpu.writeMemoryByte(n2, 1);
            this.driveStatusChanged[n] = false;
        }
    }

    public void checkWriteProtect() {
        int n = (this.cpu.data_regs[7] & 0xFF) - 1;
        if (n < 0 || n > 7 || this.raFile[n] == null) {
            this.cpu.data_regs[0] = -16;
            this.cpu.reg_sr |= 8;
            return;
        }
        this.cpu.reg_sr = this.readOnly[n] ? (this.cpu.reg_sr &= 0xFFFB) : (this.cpu.reg_sr |= 4);
        this.cpu.data_regs[0] = 0;
    }

    public void setDrive() {
        int n = this.cpu.addr_regs[6] + this.cpu.addr_regs[1];
        int n2 = this.cpu.data_regs[6] & 0xFFFE;
        String string = this.cpu.readSmsqeString(n);
        if (n2 < 0 || n2 > 8) {
            this.cpu.data_regs[0] = -15;
            return;
        }
        if (string == null || string.isEmpty() || this.inifile.getTrueOrFalse("DISABLE-FLP-DEVICE")) {
            this.cpu.data_regs[0] = -7;
            return;
        }
        String[] stringArray = new String[8];
        stringArray[n2] = string;
        boolean bl = this.setNames(stringArray, false, n2);
        this.cpu.data_regs[0] = !bl ? -7 : 0;
    }

    public void getDrive() {
        int n = this.cpu.addr_regs[6] + this.cpu.addr_regs[1];
        int n2 = this.cpu.readMemoryWord(n) - 1;
        if (n2 < 0 || n2 > 8 || this.nativeFile[n2] == null || this.nativeFile[n2].isEmpty() || this.inifile.getTrueOrFalse("DISABLE-FLP-DEVICE")) {
            this.cpu.data_regs[0] = -15;
            return;
        }
        String string = this.nativeFile[n2];
        n = n - 2 - string.length() & 0xFFFFFFFE;
        this.cpu.addr_regs[1] = n - this.cpu.addr_regs[6];
        this.cpu.writeSmsqeString(n, string, 256);
        this.cpu.data_regs[0] = 0;
    }

    private void raFileClose(int n) {
        try {
            this.raFile[n].close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.raFile[n] = null;
        this.ioChannel[n] = null;
    }

    public String[] getNames(int n) {
        return (String[])this.nativeFile.clone();
    }

    public void setxCpu(MC68000Cpu mC68000Cpu) {
        this.cpu = mC68000Cpu;
    }

    public void setCPU(MC68000Cpu mC68000Cpu) {
        this.cpu = mC68000Cpu;
    }

    private class OpenFileCheck {
        private RandomAccessFile raFile;
        private FileChannel ioChannel;
        private String errStr;
        private int flpType;

        private OpenFileCheck() {
        }

        public void checkDrive(String string) {
            File file = new File(string);
            if (!file.exists()) {
                this.errStr = string + " " + Localization.Texts[64];
                return;
            }
            try {
                this.raFile = new RandomAccessFile(file, "rw");
            }
            catch (Exception exception) {
                try {
                    this.raFile = new RandomAccessFile(file, "r");
                    this.errStr = string + " " + Localization.Texts[123];
                }
                catch (Exception exception2) {
                    this.errStr = string + " " + Localization.Texts[64];
                    return;
                }
            }
            this.ioChannel = this.raFile.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(512);
            try {
                long l = this.ioChannel.size();
                this.ioChannel.read(byteBuffer);
                int n = byteBuffer.getInt(0);
                boolean bl = false;
                switch (n) {
                    case 1363948865: {
                        bl = l == 737280L;
                        break;
                    }
                    case 1363948866: {
                        boolean bl2 = bl = l == 1474560L;
                    }
                }
                if (!bl) {
                    this.errStr = string + " " + Localization.Texts[86];
                } else {
                    this.flpType = n;
                }
            }
            catch (Exception exception) {
                this.errStr = string + " " + Localization.Texts[86];
            }
        }
    }
}

