/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import smsqmulator.FloppyDriver;
import smsqmulator.Helper;
import smsqmulator.IPHandler;
import smsqmulator.Localization;
import smsqmulator.MemDriver;
import smsqmulator.MonitorGoThread;
import smsqmulator.MonitorGui;
import smsqmulator.NfaDriver;
import smsqmulator.QL50HzInterrupt;
import smsqmulator.SampledSound;
import smsqmulator.Screen;
import smsqmulator.SfaDriver;
import smsqmulator.SoundDevice;
import smsqmulator.TrapDispatcher;
import smsqmulator.Warnings;
import smsqmulator.WinDriver;
import smsqmulator.cpu.CPUforScreenEmulation;
import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.MC68000Cpu;

public class Monitor {
    protected MC68000Cpu cpu;
    private boolean watchBreakpoints;
    private boolean logInstructions;
    private JTextArea regLogger;
    private JTextArea dataLogger;
    private static final String commandNames = "tgjbddikgbrhqrasxcbcdi1di2d1d2mwc1c2drdr1dr2sculslck0ck1wmspewrdp";
    private StringBuilder sbuffer;
    private MonitorGoThread goThread = null;
    private static final int ERRORCODE = -123456789;
    private ArrayList<Integer> breakpoints = new ArrayList();
    private String debugFilename;
    private QL50HzInterrupt ih = null;
    private TrapDispatcher trapDispatcher;
    private int diPanelNbr = 1;
    private JTextArea diTextArea;
    private int dPanelNbr = 2;
    private JTextArea dTextArea;
    private String lastCommand = "";
    private MonitorGui gui;
    private JTextField inputWdw;
    private int conditionDataReg = -1;
    private int conditionAddressReg = -1;
    private int conditionAddress = -1;
    private int conditionValue;
    private boolean conditionIsContent;
    private int upperLimit = 0;
    private boolean checkmem = false;
    private int memoryToBeWatched = 0;
    private boolean fastMode;
    private boolean excludeSuper = false;
    private SampledSound sam;
    private SoundDevice sound;
    private FloppyDriver floppy;
    private final IniFile inifile;
    public static int TIME_OFFSET;

    public Monitor(MC68000Cpu mC68000Cpu, boolean bl, boolean bl2, SampledSound sampledSound, JTextArea jTextArea, JTextArea jTextArea2, boolean bl3, Warnings warnings, int n, int n2, MonitorGui monitorGui, int n3, SoundDevice soundDevice, IniFile iniFile) {
        this.cpu = mC68000Cpu;
        this.watchBreakpoints = bl;
        this.logInstructions = bl2;
        this.regLogger = jTextArea;
        this.dataLogger = jTextArea2;
        this.sbuffer = new StringBuilder(240);
        this.sam = sampledSound;
        this.gui = monitorGui;
        this.sound = soundDevice;
        this.inifile = iniFile;
        this.diTextArea = this.getPanel(this.diPanelNbr);
        this.dTextArea = this.getPanel(this.dPanelNbr);
        this.fastMode = bl3;
        this.ih = new QL50HzInterrupt(0, this.cpu, this.cpu.screen);
        this.trapDispatcher = new TrapDispatcher(this.sam, n, monitorGui, n3, soundDevice, iniFile, new IPHandler());
        if (!this.inifile.getTrueOrFalse("DISABLE-WIN-DEVICE")) {
            this.trapDispatcher.register(new WinDriver(mC68000Cpu, warnings));
        }
        if (!this.inifile.getTrueOrFalse("DISABLE-MEM-DEVICE")) {
            this.trapDispatcher.register(new MemDriver(mC68000Cpu, warnings));
        }
        if (!this.inifile.getTrueOrFalse("DISABLE-NFA-DEVICE")) {
            this.trapDispatcher.register(new NfaDriver(mC68000Cpu));
        }
        if (!this.inifile.getTrueOrFalse("DISABLE-SFA-DEVICE")) {
            this.trapDispatcher.register(new SfaDriver(mC68000Cpu));
        }
        if (!this.inifile.getTrueOrFalse("DISABLE-FLP-DEVICE")) {
            this.floppy = new FloppyDriver(this.cpu, iniFile);
            this.trapDispatcher.setFloppy(this.floppy);
        }
        try {
            this.debugFilename = System.getProperty("user.home") + File.separator + "SMSQmulatorDebug.txt";
        }
        catch (Exception exception) {
            // empty catch block
        }
        TimeZone timeZone = TimeZone.getDefault();
        TIME_OFFSET = timeZone.getOffset(System.currentTimeMillis()) / 1000 + 283996799 + n2;
        if (this.regLogger == null) {
            this.regLogger = this.dataLogger;
        }
        if (this.regLogger == null) {
            this.dataLogger = this.regLogger = new JTextArea();
        }
    }

    public void executeMonitorCommand(String string) {
        if (string == null) {
            return;
        }
        if ((string = string.toLowerCase().trim()).isEmpty()) {
            string = this.lastCommand;
        }
        if (string.isEmpty()) {
            return;
        }
        int n = string.indexOf("  ");
        while (n != -1) {
            string = string.replace("  ", " ");
            n = string.indexOf("  ");
        }
        String[] stringArray = string.split(" ");
        if (stringArray.length == 0) {
            return;
        }
        int n2 = commandNames.indexOf(stringArray[0]);
        if (n2 == -1 && string.startsWith("s")) {
            n2 = 15;
        }
        switch (n2) {
            case 0: {
                int n3 = this.cpu.execute();
                this.cpu.stopNow = 0;
                this.showInfo(true, this.diTextArea);
                this.lastCommand = string;
                break;
            }
            case 1: {
                this.fastMode = false;
                this.cpu.stopNow = 0;
                this.goCommand(stringArray, -1);
                this.lastCommand = "";
                break;
            }
            case 2: {
                int n4 = this.cpu.pc_reg * 2;
                int n5 = this.cpu.readMemoryWord(n4);
                Instruction instruction = this.cpu.getInstructionFor(n5);
                DisassembledInstruction disassembledInstruction = instruction.disassemble(n4, n5, this.cpu);
                this.cpu.pc_reg = (n4 += disassembledInstruction.size()) / 2;
                this.showInfo(true, this.diTextArea);
                this.lastCommand = "";
                break;
            }
            case 3: {
                this.setBreakpoints(stringArray);
                this.lastCommand = "";
                break;
            }
            case 4: {
                this.dispMem(stringArray);
                this.lastCommand = string;
                break;
            }
            case 5: {
                this.diCommand(stringArray);
                this.lastCommand = string;
                break;
            }
            case 7: {
                this.waitForGoThreadToDie();
                this.lastCommand = "";
                break;
            }
            case 8: {
                int n6;
                if (stringArray.length > 1 && (n6 = this.parseForInteger(stringArray[1])) != -123456789) {
                    this.fastMode = false;
                    this.goCommand(null, n6);
                }
                this.lastCommand = "";
                break;
            }
            case 10: 
            case 38: {
                this.diTextArea = this.dataLogger;
            }
            case 36: {
                this.showInfo(true, this.diTextArea);
                this.lastCommand = "";
                break;
            }
            case 11: {
                this.showHelp();
                this.lastCommand = "";
                break;
            }
            case 12: {
                this.traceOver();
                this.lastCommand = "t";
                break;
            }
            case 14: {
                if (this.goThread != null) {
                    this.regLogger.append("Go thread still running...!\n");
                } else {
                    this.regLogger.append("Go thread is stopped.\n");
                }
                this.lastCommand = "";
                break;
            }
            case 15: {
                this.setRegister(stringArray);
                this.lastCommand = "";
                break;
            }
            case 16: {
                this.fastMode = true;
                this.goCommand(stringArray, -1);
                this.lastCommand = "";
                break;
            }
            case 17: {
                this.dataLogger.setText("");
                this.regLogger.setText("");
                break;
            }
            case 18: {
                this.breakpoints.clear();
                this.lastCommand = "";
                this.regLogger.setText("All breakpoints cleared");
                break;
            }
            case 20: 
            case 23: {
                this.dixCommand(stringArray);
                this.lastCommand = string;
                break;
            }
            case 26: 
            case 28: {
                this.dispXMem(stringArray);
                this.lastCommand = string;
                break;
            }
            case 30: {
                this.setMem(stringArray);
                break;
            }
            case 32: {
                this.dataLogger.setText("");
                break;
            }
            case 34: {
                this.regLogger.setText("");
                break;
            }
            case 41: {
                this.showInfo(true, this.regLogger);
                this.lastCommand = "";
                break;
            }
            case 44: {
                this.parseCondition(stringArray);
                break;
            }
            case 46: {
                this.setUpperLimit(stringArray);
                break;
            }
            case 48: {
                this.logInstructions = !this.logInstructions;
                this.regLogger.setText("Logging is now " + (this.logInstructions ? "ON" : "OFF") + "\n");
                if (this.goThread == null) break;
                this.goThread.switchLogging(this.logInstructions);
                break;
            }
            case 50: {
                this.checkmem = false;
                if (this.goThread == null) break;
                this.goThread.setckmem(false);
                break;
            }
            case 53: {
                this.checkmem = true;
                if (this.goThread == null) break;
                this.goThread.setckmem(true);
                break;
            }
            case 56: {
                this.setMemToBeWatched(stringArray);
                break;
            }
            case 58: {
                break;
            }
            case 60: {
                this.excludeRom();
                break;
            }
            case 61: {
                break;
            }
            case 63: {
                this.regLogger.setText("");
                for (int i = 0; i < this.cpu.pcs.length; ++i) {
                    this.regLogger.append(String.format("%08x", this.cpu.pcs[i] * 2).toUpperCase() + "\n");
                }
                break;
            }
        }
    }

    private void setMemToBeWatched(String[] stringArray) {
        if (stringArray.length != 2) {
            this.showError("wm - wrong ", "wm <address>", stringArray);
            return;
        }
        int n = this.parseForInteger(stringArray[1]);
        if (n == -123456789) {
            this.showError("wm - wrong ", "wm <address>", stringArray);
            return;
        }
        this.memoryToBeWatched = n;
        if (this.goThread != null) {
            this.goThread.setmemWatched(n);
        }
    }

    private void setUpperLimit(String[] stringArray) {
        if (stringArray.length != 2) {
            this.regLogger.setText("Upper limit = " + String.format("%08x", this.upperLimit) + "\n");
            return;
        }
        int n = this.parseForInteger(stringArray[1]);
        if (n == -123456789) {
            this.showError("ul - wrong ", "ul <address>", stringArray);
            return;
        }
        this.upperLimit = n;
        if (this.goThread != null) {
            this.goThread.setUpperLimit(n);
        }
    }

    private void excludeRom() {
        int n;
        this.upperLimit = n = this.cpu.readMemoryLong(163872);
        if (this.goThread != null) {
            this.goThread.setUpperLimit(n);
            this.goThread.switchSuper(true);
        }
        this.regLogger.setText("Exclude ROM : upper limit set to " + String.format("%08x", this.upperLimit) + "\n");
        this.excludeSuper = true;
    }

    private void setMem(String[] stringArray) {
        if (stringArray.length != 3) {
            this.showError("mw - wrong number of instructions", "mw <address> <number>", stringArray);
            return;
        }
        int n = this.parseForInteger(stringArray[1]);
        int n2 = this.parseForInteger(stringArray[2]);
        if (n == -123456789 || n2 == -123456789) {
            this.showError("mw - wrong number of instructions", "mw <address> <number>", stringArray);
            return;
        }
        this.cpu.writeMemoryWord(n, n2 & 0xFFFF);
        this.showInfo(true, this.diTextArea);
    }

    private void traceOver() {
        int n = this.cpu.pc_reg * 2;
        DisassembledInstruction disassembledInstruction = this.getDI(n);
        int n2 = n + disassembledInstruction.size();
        while (n != n2) {
            int n3 = this.cpu.execute();
            if (n3 < -1) {
                this.trapDispatcher.dispatchTrap(n3, this.cpu);
            }
            n = this.cpu.pc_reg * 2;
        }
        this.showInfo(true, this.diTextArea);
    }

    public void goCommand(String[] stringArray, int n) {
        int n2 = 0;
        if (stringArray != null && stringArray.length > 1 && (n2 = this.parseForInteger(stringArray[1])) == -123456789) {
            this.showError("g - wrong number of instructions", "g <nbr of instructions>", stringArray);
            return;
        }
        if (this.goThread != null) {
            this.regLogger.setText("Error : Already or still running (go command? - may be killed with k)");
        } else {
            this.goThread = new MonitorGoThread(n2, this.cpu, this.breakpoints, this, this.debugFilename, this.watchBreakpoints, this.logInstructions, this.ih, this.fastMode, this.trapDispatcher, this.upperLimit, this.checkmem, this.memoryToBeWatched, n, this.excludeSuper);
            this.setCondition();
            this.goThread.setName("Main emulation thread");
            this.goThread.start();
            this.setFocusToEmulScreen();
        }
    }

    private void dixCommand(String[] stringArray) {
        int n = 1;
        try {
            n = Integer.parseInt(stringArray[0].substring(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diTextArea = this.getPanel(n);
        this.diCommand(stringArray);
    }

    private void diCommand(String[] stringArray) {
        DisassembledInstruction disassembledInstruction;
        int n = 16;
        int n2 = this.cpu.pc_reg * 2;
        if (stringArray.length > 1 && ((n2 = this.parseForInteger(stringArray[1])) == -123456789 || n2 < 0)) {
            this.showError("di - wrong start address", "di <start_address> [<nbr of bytes>]", stringArray);
            return;
        }
        if (stringArray.length > 2 && (n = this.parseForInteger(stringArray[2])) == -123456789) {
            this.showError("di - wrong number of bytes", "di <start_address> [<nbr of bytes>]", stringArray);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        int n3 = this.cpu.readableSize();
        for (int i = 0; i < n && n2 < n3; n2 += disassembledInstruction.size(), ++i) {
            stringBuilder.delete(0, 80);
            disassembledInstruction = this.getDI(n2);
            disassembledInstruction.shortFormat(stringBuilder);
            this.diTextArea.append(stringBuilder.toString().toUpperCase() + "\n");
        }
    }

    private void dispXMem(String[] stringArray) {
        int n = 1;
        try {
            n = Integer.parseInt(stringArray[0].substring(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dTextArea = this.getPanel(n);
        this.dispMem(stringArray);
    }

    private void dispMem(String[] stringArray) {
        int n = 256;
        int n2 = this.cpu.pc_reg * 2;
        if (stringArray.length > 1 && ((n2 = this.parseForInteger(stringArray[1])) == -123456789 || n2 < 0)) {
            this.showError("d - wrong start address", "d <start_address> [<nbr of bytes>]", stringArray);
            return;
        }
        if (stringArray.length > 2 && (n = this.parseForInteger(stringArray[2])) == -123456789) {
            this.showError("d - wrong number of bytes", "d <start_address> [<nbr of bytes>]", stringArray);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        int n3 = n2 + n;
        StringBuilder stringBuilder2 = new StringBuilder(80);
        while (n2 < n3) {
            stringBuilder.delete(0, 80);
            stringBuilder2.setLength(0);
            stringBuilder2.append("  ");
            stringBuilder.append(String.format("%08x", n2).toUpperCase()).append(" ");
            for (int i = 0; i < 8 && n2 < n3; ++i) {
                int n4;
                if (i == 4) {
                    stringBuilder.append(" ");
                }
                char c = (n4 = this.cpu.readMemoryByte(n2++)) < 32 || n4 > 126 ? (char)'.' : (char)n4;
                stringBuilder.append(String.format("%02x", n4).toUpperCase());
                stringBuilder2.append(c);
                n4 = this.cpu.readMemoryByte(n2++);
                c = n4 < 32 || n4 > 126 ? (char)'.' : (char)n4;
                stringBuilder.append(String.format("%02x", n4).toUpperCase());
                stringBuilder.append(" ");
                stringBuilder2.append(c);
            }
            this.dTextArea.append(stringBuilder.toString() + stringBuilder2 + "\n");
        }
    }

    private void setRegister(String[] stringArray) {
        String string;
        String string2;
        if (stringArray.length < 2) {
            this.showError("setRegister", "s<register> <content> or s <register> <content>", stringArray);
            return;
        }
        if (stringArray[0].length() != 1) {
            string2 = stringArray[0];
            if (string2.length() != 3) {
                this.showError("setRegister", "s<register> <content> or s <register> <content>", stringArray);
                return;
            }
            string2 = string2.substring(1);
            string = stringArray[1];
        } else {
            if (stringArray.length < 3) {
                this.showError("setRegister", "s<register> <content> or s <register> <content>", stringArray);
                return;
            }
            string2 = stringArray[1];
            string = stringArray[2];
        }
        int n = this.parseForInteger(string);
        if (n == -123456789 || string2.length() != 2) {
            this.showError("setRegister", "s<register> <content> or s <register> <content>", stringArray);
            return;
        }
        int n2 = "01234567".indexOf(string2.substring(1));
        if (n2 == -1 && !string2.equals("pc")) {
            this.showError("setRegister", "s<register> <content> or s <register> <content>", stringArray);
            return;
        }
        int n3 = "adp".indexOf(string2.substring(0, 1));
        switch (n3) {
            case 0: {
                this.cpu.addr_regs[n2] = n;
                this.showInfo(true, this.diTextArea);
                break;
            }
            case 1: {
                this.cpu.data_regs[n2] = n;
                this.showInfo(true, this.diTextArea);
                break;
            }
            case 2: {
                this.cpu.pc_reg = n / 2;
                break;
            }
            default: {
                this.showError("setRegister", "s<register> <content> or s <register> <content>", stringArray);
            }
        }
    }

    private void setBreakpoints(String[] stringArray) {
        if (this.breakpoints == null) {
            this.breakpoints = new ArrayList();
        }
        if (stringArray.length == 1) {
            this.regLogger.setText("Breakpoints:");
            for (int n : this.breakpoints) {
                this.regLogger.append(String.format("%08x (%d)", n, n).toUpperCase() + "\n");
            }
        } else {
            int n = this.parseForInteger(stringArray[1]);
            if (n == -123456789) {
                this.showError("breakpoint", "b [< address>]", stringArray);
                return;
            }
            if (this.breakpoints.contains(n)) {
                this.breakpoints.remove((Object)n);
                this.regLogger.append(String.format("Breakpoint removed at $%08x\n", n).toUpperCase());
            } else {
                this.breakpoints.add(n);
                this.regLogger.append(String.format("Breakpoint set at %08x\n", n).toUpperCase());
            }
        }
    }

    private void parseCondition(String[] stringArray) {
        if (stringArray.length == 1) {
            this.conditionDataReg = -1;
            this.conditionAddressReg = -1;
            this.conditionValue = 0;
            this.conditionAddress = -1;
            this.conditionIsContent = false;
            this.setCondition();
            return;
        }
        if (stringArray.length != 2) {
            this.showError("set condition", "sc <condition>", stringArray);
            return;
        }
        String string = stringArray[1];
        if (string == null || string.isEmpty()) {
            this.showError("set condition", "sc <condition>", stringArray);
            return;
        }
        String[] stringArray2 = string.split("=");
        if (stringArray2 == null || stringArray2.length != 2) {
            this.showError("set condition", "sc <condition>", stringArray);
            return;
        }
        String string2 = stringArray2[0].toLowerCase().trim();
        int n = this.parseForInteger(stringArray2[1].trim());
        if (string2.length() != 2 || n == -123456789) {
            this.showError("set condition", "sc <condition>", stringArray);
            return;
        }
        int n2 = "adcx".indexOf(string2.substring(0, 1));
        if (n2 < 0) {
            this.showError("set condition", "sc <condition>", stringArray);
            return;
        }
        int n3 = this.parseForInteger(string2.substring(1));
        if (n3 == -123456789 || n3 > 7 || n3 < 0) {
            this.showError("set condition", "sc <condition>", stringArray);
            return;
        }
        if (n2 == 0) {
            this.conditionDataReg = -1;
            this.conditionAddressReg = n3;
            this.conditionValue = n;
            this.conditionIsContent = false;
            this.setCondition();
        } else if (n2 == 1) {
            this.conditionDataReg = n3;
            this.conditionAddressReg = -1;
            this.conditionValue = n;
            this.conditionIsContent = false;
            this.setCondition();
        } else if (n2 == 2) {
            this.conditionDataReg = -1;
            this.conditionAddressReg = n3;
            this.conditionValue = n;
            this.conditionIsContent = true;
            this.setCondition();
        } else if (n2 == 3) {
            this.conditionAddress = n;
            this.setCondition();
        }
    }

    private void setCondition() {
        if (this.goThread != null) {
            this.goThread.setCondition(this.conditionDataReg, this.conditionAddressReg, this.conditionValue, this.conditionIsContent, this.conditionAddress);
        }
    }

    public void setLoggers(JTextArea jTextArea, JTextArea jTextArea2) {
        this.regLogger = jTextArea;
        this.dataLogger = jTextArea2;
        this.diTextArea = this.getPanel(this.diPanelNbr);
        this.dTextArea = this.getPanel(this.dPanelNbr);
    }

    private void showHelp() {
        this.dataLogger.setText("");
        this.dataLogger.append("Commands are single or double letters, possibly followed by options.\n");
        this.dataLogger.append("Commands are:\n");
        this.dataLogger.append("  h - Help: show help.\n");
        this.dataLogger.append("  g - Go (start monitoring) <start_address (default current PC)> <number_of_instructions to go (default unlimited)>.\n");
        this.dataLogger.append("  gb- Go to a provisional breakpoint. One paramter: the breakpoint.\n");
        this.dataLogger.append("  r and dr - display registers : show content of all registers (no parameter).\n");
        this.dataLogger.append("  dr1 and dr2 - display registers in window 1 or 2\n");
        this.dataLogger.append("  a - check whether the go thread is still running.\n");
        this.dataLogger.append("  di- Disasssemble instructions <start_address (default current PC)> <number_of_instructions (default : 8)>.\n");
        this.dataLogger.append("      This can also be 'di1' or 'di2' to choose the display area where the result will be shown\n");
        this.dataLogger.append("  j - Jump over current instruction (do not execute, advance PC to next instruction).\n");
        this.dataLogger.append("  b - Breakpoint. No parameters = show breakpoints , parameter= set breakpoint at that addresss, or unset it, if it already is set at that address.\n");
        this.dataLogger.append("  t - Trace (execute) one instruction at the current PC.\n");
        this.dataLogger.append("  d - display memory content <start_address (default current PC)> <number_of_bytes (default : 16)>.\n");
        this.dataLogger.append("      This can also be 'd1' or 'd2' to choose the display area where the result will be shown\n");
        this.dataLogger.append("  k - kill current Go thread if it exists.\n");
        this.dataLogger.append("  s - set a register to a value: s<reg> <value> or s <reg> <value>.\n");
        this.dataLogger.append("  bc - clear all breakpoints.\n");
        this.dataLogger.append("  qr- quickly execute the following instruction & set a breakpoint to the one after that. Useful for JSR/BSR/Trap.\n");
        this.dataLogger.append("      This does NOT stop at any normal breakpoints.\n");
        this.dataLogger.append("  mw- change a word in memory : mw <address> <new word content>.\n");
        this.dataLogger.append("  ck0, ck1 swicth watching memory on (ck1) or off (ck2). When on, and watched memory != 0 any change in the long value in that memory location will trigger a breakpoint.\n");
        this.dataLogger.append("  wm - watched memory : wm <address> Sets the memory location that will be watched..\n");
        this.dataLogger.append("  sc- set a condition : sc <condition> <address> sets the condition at that address. a condition is <register>=<value> WITHOUT spaces in between, eg a0=28000\n");
        this.dataLogger.append("  ul- set upper limit : when logging instructions, if the pc is beyond this limit, instructions will not be logged.\n");
        this.dataLogger.append("  e  - exclude ROM code from logging (switch on/off).\n");
        this.dataLogger.append("  sl - switch logging instructions from yes to no to yes etc When switched on and then off, the logged isntrcutions are .\n");
        this.dataLogger.append("       written into a log file, by default this is (user home)+SMSQmulatorDebug.txt.\n");
        this.dataLogger.append("  wf - write file : write the logging file immediately.\n");
        this.dataLogger.append("  dp - display the previous 10 PCs - uncomment the relevant section in the CPU.execute method!!!!\n");
        this.dataLogger.append("  wf - write file : write the logging file immediately.\n");
        this.dataLogger.append("  ck1 & ck0 start/stop checking memory.\n");
        this.dataLogger.append("  sp - special, could be anything.\n");
        this.dataLogger.append("  sp - special, could be anything.\n");
        this.dataLogger.append("A simple ENTER will repeat the last t, d or di command.\n");
        this.dataLogger.append("Options are separated from the command and each other by single spaces.\n");
        this.dataLogger.append("Numbers can be given in decimal or hex format. The default is hex, decimals must be prefixed by '&'.\n");
        this.dataLogger.append("The star '*' can be used for an address, this then is the current PC \n");
        this.dataLogger.append("An address can also be given by register number enclosed in parenthesis, eg (a7) or (d0) and also (pc):\n");
        this.dataLogger.append("The address will then be that of the content of the register, so, if a7= $100, 'di (a7)' will disassemble instructions as off address $100.\n");
        this.dataLogger.append("An address can also be calculated with + or - , e.g. *-10 or (a0)+$100.\n");
        this.dataLogger.append("An address can also be calculated with a displacement eg 10(a0) and combined regs eg. 10(a3,a6). Both regs will be long.\n");
    }

    private void showError(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(string3).append(" ");
        }
        this.regLogger.setText("Error in instruction -" + string + " : " + stringBuilder.toString() + "\n");
        this.regLogger.append("Usage : " + string2 + "\n");
    }

    private int parseForInteger(String string) {
        int n;
        int n2 = -123456789;
        if (string == null || string.isEmpty()) {
            return n2;
        }
        if ((string = string.trim()).isEmpty()) {
            return n2;
        }
        int n3 = 0;
        int n4 = string.indexOf("(");
        if (n4 > 0) {
            n3 = this.parseForInteger(string.substring(n4));
            if (n3 == -123456789) {
                return n3;
            }
            string = string.substring(0, n4);
        }
        boolean bl = false;
        n4 = string.indexOf("-");
        if (n4 == -1) {
            n4 = string.indexOf("+");
        } else {
            bl = true;
        }
        if (n4 != -1) {
            if (n4 + 1 >= string.length()) {
                return n2;
            }
            String string2 = string.substring(n4 + 1);
            n = this.parseForInteger(string2);
            if (n == -123456789) {
                return n;
            }
            if (bl) {
                n *= -1;
            }
            n3 += n;
            if ((string = string.substring(0, n4)).isEmpty()) {
                return n3;
            }
        }
        if (string.equals("*")) {
            return this.cpu.pc_reg * 2 + n3;
        }
        if (string.startsWith("(")) {
            if (!string.endsWith(")")) {
                return n2;
            }
            n4 = string.indexOf(",");
            if (n4 == -1) {
                if (string.length() != 4) {
                    return n2;
                }
                String string3 = string.substring(1, 2);
                if (!"adp".contains(string3)) {
                    return n2;
                }
                try {
                    if (string3.equals("p")) {
                        return this.cpu.pc_reg * 2 + n3;
                    }
                    n2 = Integer.parseInt(string.substring(2, 3));
                    if (n2 < 0 || n2 > 7) {
                        return -123456789;
                    }
                    if (string3.equals("a")) {
                        return this.cpu.addr_regs[n2] + n3;
                    }
                    return this.cpu.data_regs[n2] + n3;
                }
                catch (Exception exception) {
                    return -123456789;
                }
            }
            if (n4 != 3 || string.length() != 7) {
                return n2;
            }
            n4 = this.parseForInteger("(" + string.substring(1, 3) + ")");
            if (n4 == n2) {
                return n2;
            }
            n2 = this.parseForInteger("(" + string.substring(4, 6) + ")");
            if (n2 == -123456789) {
                return n2;
            }
            return n4 + n2 + n3;
        }
        int n5 = 16;
        if (string.startsWith("$")) {
            if (string.length() == 1) {
                return n2;
            }
            string = string.substring(1);
            n5 = 16;
        } else if (string.startsWith("&")) {
            if (string.length() == 1) {
                return n2;
            }
            string = string.substring(1);
            n5 = 10;
        }
        try {
            boolean bl2 = false;
            if (string.length() > 8 && n5 == 16) {
                return n2;
            }
            if (string.length() == 8 && n5 == 16) {
                String string4 = "0" + string.substring(0, 1);
                try {
                    n = Integer.parseInt(string4, n5);
                }
                catch (Exception exception) {
                    return n2;
                }
                if (n > 7) {
                    bl2 = true;
                    string = (n -= 8) + string.substring(1);
                }
            }
            n2 = Integer.parseInt(string, n5);
            if (bl2) {
                n2 |= Integer.MIN_VALUE;
            }
        }
        catch (Exception exception) {
            return -123456789;
        }
        return n2 + n3;
    }

    public void showInfo(boolean bl, JTextArea jTextArea) {
        if (jTextArea == null) {
            jTextArea = this.diTextArea;
        }
        if (bl) {
            jTextArea.setText("");
        }
        jTextArea.append(String.format("D0:%08x  D1:%08x  D2:%08x  D3:%08x  PC:%08x\n", this.cpu.data_regs[0], this.cpu.data_regs[1], this.cpu.data_regs[2], this.cpu.data_regs[3], this.cpu.pc_reg * 2).toUpperCase());
        jTextArea.append(String.format("D4:%08x  D5:%08x  D6:%08x  D7:%08x  SR:%04x %s\n", this.cpu.data_regs[4], this.cpu.data_regs[5], this.cpu.data_regs[6], this.cpu.data_regs[7], this.cpu.reg_sr, this.showFlags()).toUpperCase());
        jTextArea.append(String.format("A0:%08x  A1:%08x  A2:%08x  A3:%08x  USP:%08x\n", this.cpu.addr_regs[0], this.cpu.addr_regs[1], this.cpu.addr_regs[2], this.cpu.addr_regs[3], this.cpu.reg_usp).toUpperCase());
        jTextArea.append(String.format("A4:%08x  A5:%08x  A6:%08x  A7:%08x  SSP:%08x\n\n", this.cpu.addr_regs[4], this.cpu.addr_regs[5], this.cpu.addr_regs[6], this.cpu.addr_regs[7], this.cpu.reg_ssp).toUpperCase());
        this.sbuffer.delete(0, this.sbuffer.length());
        int n = this.cpu.pc_reg * 2;
        if (n < 0 || n >= this.cpu.readableSize()) {
            this.sbuffer.append(String.format("%08x   ????", n));
        } else {
            int n2 = this.cpu.readMemoryWord(n);
            Instruction instruction = this.cpu.getInstructionFor(n2);
            DisassembledInstruction disassembledInstruction = instruction.disassemble(n, n2, this.cpu);
            disassembledInstruction.shortFormat(this.sbuffer);
        }
        jTextArea.append(String.format("==> %s\n\n", this.sbuffer.toString().toUpperCase()));
    }

    private String showFlags() {
        String string = "";
        string = string + (this.cpu.isSupervisorMode() ? "S " : "  ");
        string = string + ((this.cpu.reg_sr & 0x10) != 0 ? "X" : "-");
        string = string + ((this.cpu.reg_sr & 8) != 0 ? "N" : "-");
        string = string + ((this.cpu.reg_sr & 4) != 0 ? "Z" : "-");
        string = string + ((this.cpu.reg_sr & 2) != 0 ? "V" : "-");
        return string + ((this.cpu.reg_sr & 1) != 0 ? "C" : "-");
    }

    private DisassembledInstruction getDI(int n) {
        int n2 = this.cpu.readMemoryWord(n);
        Instruction instruction = this.cpu.getInstructionFor(n2);
        return instruction.disassemble(n, n2, this.cpu);
    }

    private JTextArea getPanel(int n) {
        switch (n) {
            default: {
                return this.dataLogger;
            }
            case 2: 
        }
        return this.regLogger;
    }

    public synchronized void goThreadStopped(String string) {
        this.showInfo(false, this.diTextArea);
        this.setFocusToInputWindow();
        this.regLogger.setText(string + "\n");
        this.goThread = null;
    }

    public synchronized boolean checkThread() {
        return this.goThread == null;
    }

    public void showHardbreak() {
        this.regLogger.append("HARD BREAK ENCOUNTERED.\n");
    }

    public void suspendExecution() {
        if (this.goThread != null) {
            try {
                this.goThread.suspend();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resumeExecution() {
        if (this.goThread != null) {
            try {
                this.goThread.resume();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setScreenUpdateInterval(int n) {
        if (this.ih != null) {
            this.ih.setScreenUpdateInterval(n);
            this.gui.setScreenUpdateInterval(n);
        }
    }

    public void setFocusToEmulScreen() {
        if (this.gui != null) {
            this.gui.setFocus();
        }
    }

    public void setInputWindow(JTextField jTextField) {
        this.inputWdw = jTextField;
    }

    public void setFocusToInputWindow() {
        if (this.inputWdw != null) {
            this.inputWdw.requestFocus();
            this.inputWdw.requestFocusInWindow();
        }
    }

    public void setCapsLockStatus(boolean bl) {
        int n = bl ? 65280 : 0;
        this.cpu.writeMemoryWord(163976, n);
    }

    public void inputKey(int n) {
        if (!this.cpu.isRomLoadedOk()) {
            return;
        }
        this.cpu.writeMemoryLong(this.cpu.getLinkageBlock() + 0, n);
        this.trapDispatcher.resetCounter();
    }

    public void inputMouse(int n, int n2, int n3, int n4) {
        if (!this.cpu.isRomLoadedOk()) {
            return;
        }
        n3 = (n3 << 16) + n4;
        n = n << 16 | n2 & 0xFFFF;
        this.cpu.writeMemoryLong(this.cpu.getLinkageBlock() + 8, n3);
        this.cpu.writeMemoryLong(this.cpu.getLinkageBlock() + 12, n);
        this.trapDispatcher.resetCounter();
    }

    public void inputMouseButton(int n) {
        if (!this.cpu.isRomLoadedOk()) {
            return;
        }
        this.cpu.writeMemoryWord(this.cpu.getLinkageBlock() + 16, n);
        this.trapDispatcher.resetCounter();
    }

    public void inputMouseWheel(int n) {
        if (!this.cpu.isRomLoadedOk()) {
            return;
        }
        this.cpu.writeMemoryLong(this.cpu.getLinkageBlock() + 62, n);
        this.trapDispatcher.resetCounter();
    }

    public void setScreenCoordinates(int n, int n2) {
        if (this.trapDispatcher != null) {
            this.trapDispatcher.setScreenCoordinates(n, n2);
        }
    }

    public void setNamesForDrives(int n, String[] stringArray, boolean bl) {
        this.trapDispatcher.setNamesForDrives(n, stringArray, bl);
    }

    public void setUsageForDrive(int n, String string) {
        this.trapDispatcher.setUsage(n, Helper.convertUsageName(string));
    }

    public void setFilenameChange(int n, int n2) {
        this.trapDispatcher.setFilenameChange(n, n2);
    }

    public void setFloppyNames(String[] stringArray) {
        if (this.floppy != null) {
            this.floppy.setNames(stringArray, true, -1);
        }
    }

    public void setCopyScreen(int n, int n2) {
        this.cpu.setCopyScreen(n, n2);
    }

    public void reset() {
        if (!this.waitForGoThreadToDie()) {
            return;
        }
        this.ih.stopInterruptHandler();
        this.regLogger.setText("");
        this.dataLogger.setText("");
        this.lastCommand = "";
        if (this.cpu.isRomLoadedOk()) {
            this.cpu.setupSMSQE(true);
            if (this.trapDispatcher != null) {
                this.trapDispatcher.reset();
            }
            this.goCommand(null, -1);
        }
    }

    public MC68000Cpu getCPU() {
        return this.cpu;
    }

    public Screen getScreen() {
        return this.cpu.getScreen();
    }

    public int getMemSize() {
        return this.cpu.getMemory().length;
    }

    public boolean loadRom(File file) {
        return this.loadRom(file.getAbsolutePath(), null);
    }

    public boolean loadRom(String string, URL uRL) {
        if (string != null && !string.isEmpty()) {
            if (!this.waitForGoThreadToDie()) {
                return false;
            }
            return this.cpu.loadRomImage(string, uRL);
        }
        Helper.reportError(Localization.Texts[45], Localization.Texts[32] + " (" + string + ")", null);
        return false;
    }

    public void setKeyrow(int n, int n2) {
        this.cpu.setKeyrow(n, n2);
        this.trapDispatcher.resetCounter();
    }

    public void removeKeyrow(int n, int n2) {
        this.cpu.removeKeyrow(n, n2);
        this.trapDispatcher.resetCounter();
    }

    public void changeMemSize(int n, Screen screen, boolean bl) {
        if (!this.waitForGoThreadToDie()) {
            return;
        }
        this.ih.stopInterruptHandler();
        if (screen == null) {
            screen = this.cpu.getScreen();
        }
        screen.clearScreen();
        if (n == -1) {
            n = this.cpu.getLinkageBlock();
        }
        String string = this.cpu.getRomFile();
        this.dataLogger.setText("");
        this.regLogger.setText("");
        this.trapDispatcher.closeAllFiles();
        this.cpu = null;
        this.trapDispatcher.setCpu(null);
        this.ih.setCpu(null);
        if (this.floppy != null) {
            this.floppy.setCPU(null);
        }
        this.cpu = bl ? new CPUforScreenEmulation(n, screen, this.inifile, 350000) : new MC68000Cpu(n, screen, this.inifile, 350000);
        if (this.cpu.loadRomImage(string, null)) {
            this.ih.setCpu(this.cpu);
            this.ih.setScreen(screen);
            this.trapDispatcher.setCpu(this.cpu);
            if (this.floppy != null) {
                this.floppy.setCPU(this.cpu);
            }
            this.goCommand(null, 0);
        }
    }

    public TrapDispatcher getTrapDispatcher() {
        return this.trapDispatcher;
    }

    private boolean waitForGoThreadToDie() {
        if (this.goThread != null) {
            this.goThread.stop();
        }
        this.goThread = null;
        return true;
    }

    public void setFastMode(boolean bl) {
        if (this.fastMode != bl) {
            this.fastMode = bl;
            if (this.waitForGoThreadToDie()) {
                this.goCommand(null, -1);
            }
        }
    }

    public void setThrottle(int n) {
        if (this.trapDispatcher != null) {
            this.trapDispatcher.setThrottle(n);
        }
    }

    public void setSoundVolume(int n) {
        if (this.trapDispatcher != null) {
            this.trapDispatcher.setSoundVolume(n);
        }
    }

    public void stopThrottle() {
        if (this.trapDispatcher != null) {
            this.trapDispatcher.setThrottleStatus(false);
        }
    }

    public void setTimeOffset(int n) {
        TIME_OFFSET = 283996799 + n;
    }
}

