/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import inifile.IniFile;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import smsqmulator.DriveAssignmentsDialog;
import smsqmulator.Helper;
import smsqmulator.Localization;
import smsqmulator.Monitor;
import smsqmulator.MonitorHandler;
import smsqmulator.MonitorPanel;
import smsqmulator.MultiMonitorDialog;
import smsqmulator.Screen;
import smsqmulator.Screen0;
import smsqmulator.Screen16;
import smsqmulator.Screen32;
import smsqmulator.TBFlasher;
import smsqmulator.Warnings;

public class MonitorGui
extends JFrame
implements MonitorHandler {
    private Monitor monitor;
    private DriveAssignmentsDialog dad;
    private String[] nfaNames;
    private String[] sfaNames;
    private String[] winNames;
    private String[] flpNames;
    private String[] memNames;
    private final IniFile inifile;
    private final JFileChooser fc;
    private String romFile;
    private int memSize;
    private Screen screen;
    private static final Object[] memPossibilities = new Object[]{"1", "2", "4", "8", "16", "32", "64", "96", "128", "240"};
    private boolean isMac;
    private int language;
    private final Warnings warnings;
    private boolean isDouble;
    private boolean windowActivated;
    private final String version;
    private final MonitorPanel monitorPanel;
    private Robot robot;
    private int screenUpdateRate;
    private int screenMode;
    private int windowMode;
    private GraphicsDevice[] gds;
    private int currentMonitor;
    private JRadioButtonMenuItem QLColoursRadioButton;
    private JMenuItem aboutMenuItem;
    private JCheckBoxMenuItem allowScreenEmulationjCheckBoxMenuItem;
    private JMenuItem beepVolumeItem;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ButtonGroup buttonGroup5;
    private ButtonGroup buttonGroup6;
    private ButtonGroup buttonGroup7;
    private JRadioButtonMenuItem byteColoursRadioButton;
    private JMenu changeNfaNamesMenu;
    private JMenu changeSfaNamesMenu;
    private JMenu configMenu;
    private JMenuItem dateOffsetMenuItem;
    private JRadioButtonMenuItem deutschRadioButton;
    private JMenu devicesMenu;
    private JMenuItem doubleSizeMenuItem;
    private JRadioButtonMenuItem englishRadioButton;
    private JRadioButtonMenuItem espanolRadioButton;
    private JMenuItem exitMenuItem;
    private JCheckBoxMenuItem fastModeMenuItem;
    private JMenu filesMenu;
    private JCheckBoxMenuItem flpDisableCheckBoxMenuItem;
    private JCheckBoxMenuItem flpReadOnlyCheckBoxMenuItem;
    private JMenuItem flpUseMenuItem;
    private JPopupMenu.Separator flpUseNameMenuItem;
    private JRadioButtonMenuItem francaisRadioButton;
    private JMenuItem fullScreenMonitorMenuItem;
    private JRadioButtonMenuItem fullSizeMenuItem;
    private JCheckBoxMenuItem idleMenuItem;
    private JRadioButtonMenuItem italianRadioButton;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu6;
    private JMenuBar jMenuBar1;
    private JMenuBar jMenuBar2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JMenuItem javaVersionMenuItem;
    private JMenuItem loadSmsqeFileMenuItem;
    private JCheckBoxMenuItem memDisableCheckBoxMenuItem;
    private JMenuItem memSizeMenuItem;
    private JMenuItem memUseMenuItem;
    private JMenuItem menuBarInvisibleMenuItem;
    private JCheckBoxMenuItem monitorVisibleCheckBoxMenuItem;
    private JMenuItem mouseClickDelayMenuItem;
    private JMenuItem mousewheelAccelItem;
    private JCheckBoxMenuItem nfaDisableCheckBoxMenuItem;
    private JRadioButtonMenuItem nfaNameLowerCaseRadioButton;
    private JRadioButtonMenuItem nfaNameUnchangedRadioButton;
    private JRadioButtonMenuItem nfaNameUpperCaseRadioButton;
    private JMenuItem nfaUseMenuItem;
    private JCheckBoxMenuItem nonStandardQXLDriveCheckBox;
    private JCheckBoxMenuItem nonexistingFlpFileCheckBoxMenuItem;
    private JCheckBoxMenuItem nonexistingQxlFileCheckBox;
    private JMenu popupActionMenu;
    private JCheckBoxMenuItem popupBlinkCheckBoxMenuItem;
    private JCheckBoxMenuItem popupOpenWdwCheckBoxMenuItem;
    private JCheckBoxMenuItem qxlDisableCheckBoxMenuItem;
    private JCheckBoxMenuItem qxlDriveFullCheckBox;
    private JCheckBoxMenuItem qxlDriveIsReadOnlyCheckBox;
    private JCheckBoxMenuItem qxlIgnoreFilelockErrorCheckBoxMenuItem;
    private JMenuItem qxlUseMenuItem;
    private JMenuItem resetMenuItem;
    private JMenu screenColoursMenu;
    private JMenuItem screenSizeMenuItem;
    private JMenuItem screenUpdateRateMenuItem;
    private JMenuItem setFlpNamesMenuItem;
    private JMenuItem setMemNamesMenuItem;
    private JMenuItem setNFANameMenuItem;
    private JMenuItem setQxlNameMenuItem;
    private JMenuItem setSFANameMenuItem;
    private JCheckBoxMenuItem sfaDisableCheckBoxMenuItem;
    private JRadioButtonMenuItem sfaNameLowerCaseRadioButton;
    private JRadioButtonMenuItem sfaNameUnchangedRadioButton;
    private JRadioButtonMenuItem sfaNameUpperCaseRadioButton;
    private JMenuItem sfaUseMenuItem;
    private JCheckBoxMenuItem soundProblemCheckBox;
    private JRadioButtonMenuItem specialFullSizeMenuItem;
    private JCheckBoxMenuItem ssss20KHzCheckBoxMenuItem;
    private JCheckBoxMenuItem ssss22KHzCheckBoxMenuItem;
    private JMenu ssssFrequencyMenuItem;
    private JCheckBoxMenuItem suspendIconifiedMenuItem;
    private JCheckBoxMenuItem unlockable2ReadOnlyCheckBoxMenuItem;
    private JCheckBoxMenuItem vibrantColoursMenuItem;
    private JMenu warningsMenu;
    private JRadioButtonMenuItem windowMenuItem;
    private JMenu windowModeMenuItem;
    private JRadioButtonMenuItem wordColoursRadioButton;

    public MonitorGui(Screen screen, IniFile iniFile, Warnings warnings, int n, boolean bl, boolean bl2, int n2, GraphicsConfiguration graphicsConfiguration, GraphicsDevice[] graphicsDeviceArray, int n3) {
        Object object;
        Object object2;
        Serializable serializable;
        String string;
        block25: {
            super(graphicsConfiguration);
            this.nfaNames = new String[]{"", "", "", "", "", "", "", ""};
            this.sfaNames = new String[]{"", "", "", "", "", "", "", ""};
            this.winNames = new String[]{"", "", "", "", "", "", "", ""};
            this.flpNames = new String[]{"", "", "", "", "", "", "", ""};
            this.memNames = new String[]{"", "", "", "", "", "", "", ""};
            this.romFile = "";
            this.memSize = 2;
            this.windowActivated = false;
            this.robot = null;
            this.windowMode = n2;
            this.inifile = iniFile;
            this.screen = screen;
            this.screenMode = screen.getMode();
            this.warnings = warnings;
            this.gds = graphicsDeviceArray;
            this.currentMonitor = n3;
            string = System.getProperty("os.name").toLowerCase();
            if (this.windowMode > 0) {
                serializable = graphicsConfiguration.getBounds();
                this.setLocation(((Rectangle)serializable).x, ((Rectangle)serializable).y);
                object2 = new Dimension(((Rectangle)serializable).width, ((Rectangle)serializable).height);
                this.setSize((Dimension)object2);
                this.setUndecorated(true);
                try {
                    object = graphicsConfiguration.getDevice();
                    if (string.contains("mac")) {
                        try {
                            FullScreenUtilities.setWindowCanFullScreen(this, true);
                            Application.getApplication().requestToggleFullScreen(this);
                        }
                        catch (Exception exception) {
                            this.setExtendedState(6);
                            ((GraphicsDevice)object).setFullScreenWindow(this);
                        }
                        break block25;
                    }
                    if (string.contains("windows")) {
                        this.setExtendedState(6);
                        break block25;
                    }
                    if (((GraphicsDevice)object).isFullScreenSupported()) {
                        ((GraphicsDevice)object).setFullScreenWindow(this);
                        break block25;
                    }
                    this.setExtendedState(6);
                }
                catch (Exception exception) {}
            } else {
                this.setLocation(this.inifile.getOptionAsInt("WDW-XPOS", 0), this.inifile.getOptionAsInt("WDW-YPOS", 0));
            }
        }
        if (string.contains("mac")) {
            serializable = this;
            object2 = Application.getApplication();
            ((Application)object2).setQuitHandler(new QuitHandler((MonitorGui)serializable){
                final /* synthetic */ MonitorGui val$mon;
                {
                    this.val$mon = monitorGui2;
                }

                @Override
                public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
                    if (quitEvent.getSource() != this.val$mon) {
                        quitResponse.cancelQuit();
                    } else {
                        quitResponse.performQuit();
                    }
                }
            });
            this.isMac = true;
        }
        screen.setIsMac(this.isMac);
        this.initComponents();
        this.setTitle("SMSQmulator v." + Localization.getVersion());
        this.deutschRadioButton.setIcon(new ImageIcon(this.getClass().getResource("images/flag-germany.gif")));
        this.englishRadioButton.setIcon(new ImageIcon(this.getClass().getResource("images/flag-uk.gif")));
        this.francaisRadioButton.setIcon(new ImageIcon(this.getClass().getResource("images/flag-france.gif")));
        this.espanolRadioButton.setIcon(new ImageIcon(this.getClass().getResource("images/flag-spain.gif")));
        this.italianRadioButton.setIcon(new ImageIcon(this.getClass().getResource("images/flag-italy.png")));
        this.setIconImage(MonitorGui.getFDImage("images/smsqmulator2.png"));
        this.monitorPanel = new MonitorPanel(this);
        this.vibrantColoursMenuItem.setSelected(bl);
        this.isDouble = this.inifile.getTrueOrFalse("DOUBLE-SIZE");
        if (!this.inifile.getTrueOrFalse("MENUBAR-VISIBLE")) {
            this.jMenuBar1.setVisible(false);
        }
        if (this.gds.length < 2) {
            this.fullScreenMonitorMenuItem.setVisible(false);
        }
        this.setupScreen();
        if (!bl2) {
            this.setDefaultCloseOperation(3);
        }
        this.language = Localization.getLanguage();
        this.setLanguage(0);
        this.fc = new JFileChooser();
        this.version = "" + n + ")";
        serializable = new HashSet<AWTKeyStroke>(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        ((HashSet)serializable).clear();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(0, (Set<? extends AWTKeyStroke>)((Object)serializable));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(1, (Set<? extends AWTKeyStroke>)((Object)serializable));
        object2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        object = (JPanel)this.getContentPane();
        InputMap inputMap = ((JComponent)object).getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("F10");
        inputMap.put(keyStroke, "F10");
        ((JComponent)object).getActionMap().put("F10", (Action)object2);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.doaltSpace(false);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.doaltSpace(true);
            }
        };
        if (string.contains("windows")) {
            inputMap = this.getRootPane().getInputMap(2);
            keyStroke = KeyStroke.getKeyStroke("alt SPACE");
            inputMap.put(keyStroke, "xxx");
            this.getRootPane().getActionMap().put("xxx", abstractAction);
            keyStroke = KeyStroke.getKeyStroke("shift alt SPACE");
            inputMap.put(keyStroke, "xsp");
            this.getRootPane().getActionMap().put("xsp", abstractAction2);
            try {
                this.robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.nonStandardQXLDriveCheckBox.setSelected(this.warnings.warnIfQXLDriveNotCompliant);
        this.nonexistingQxlFileCheckBox.setSelected(this.warnings.warnIfNonexistingQXLDrive);
        this.qxlDriveFullCheckBox.setSelected(this.warnings.warnIfQXLDriveFull);
        this.qxlDriveIsReadOnlyCheckBox.setSelected(this.warnings.warnIfQXLDriveIsReadOnly);
        this.soundProblemCheckBox.setSelected(this.warnings.warnIfSoundProblem);
        this.flpReadOnlyCheckBoxMenuItem.setSelected(this.warnings.warnIfFLPDriveIsReadOnly);
        this.nonexistingFlpFileCheckBoxMenuItem.setSelected(this.warnings.warnIfNonexistingFLPDrive);
        this.qxlDisableCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("DISABLE-WIN-DEVICE"));
        this.qxlIgnoreFilelockErrorCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("IGNORE-QXLWIN-LOCK-ERROR"));
        this.nfaDisableCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("DISABLE-NFA-DEVICE"));
        this.sfaDisableCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("DISABLE-sFA-DEVICE"));
        this.flpDisableCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("DISABLE-FLP-DEVICE"));
        this.memDisableCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("DISABLE-MEM-DEVICE"));
        this.idleMenuItem.setSelected(this.inifile.getTrueOrFalse("LESS-CPU-WHEN-IDLE"));
        this.suspendIconifiedMenuItem.setSelected(this.inifile.getTrueOrFalse("SUSPEND-WHEN-ICONIFIED"));
        this.allowScreenEmulationjCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("QL-SCREEN-EMULATION"));
        int n4 = iniFile.getOptionAsInt("MOUSE-CLICK-DELAY", 0);
        this.mouseClickDelayMenuItem.setText(Localization.Texts[127] + n4);
        this.screen.setMouseClickDelay(n4);
        this.screenUpdateRate = iniFile.getOptionAsInt("SCREEN-UPDATE-RATE", 50);
        switch (this.windowMode) {
            case 1: {
                this.fullSizeMenuItem.setSelected(true);
                break;
            }
            case 2: {
                this.specialFullSizeMenuItem.setSelected(true);
                break;
            }
            default: {
                this.windowMenuItem.setSelected(true);
            }
        }
        this.unlockable2ReadOnlyCheckBoxMenuItem.setSelected(this.inifile.getTrueOrFalse("MAKE-UNLOCKABLE-QXLWIN-READONLY"));
        this.unlockable2ReadOnlyCheckBoxMenuItem.setEnabled(iniFile.getTrueOrFalse("IGNORE-QXLWIN-LOCK-ERROR"));
        if (this.inifile.getTrueOrFalse("POPUP-ACTION")) {
            this.popupBlinkCheckBoxMenuItem.setSelected(true);
        } else {
            this.popupOpenWdwCheckBoxMenuItem.setSelected(true);
        }
        if (iniFile.getOptionValue("SSSS-FREQUENCY").equals("20")) {
            this.ssss20KHzCheckBoxMenuItem.setSelected(true);
        } else {
            this.ssss22KHzCheckBoxMenuItem.setSelected(true);
        }
        int n5 = iniFile.getOptionAsInt("MOUSEWHEEL-ACCEL", 0);
        if (n5 > 0 & n5 < 10) {
            this.screen.setMousewheelAccel(n5);
        }
    }

    private void doaltSpace(boolean bl) {
        KeyEvent keyEvent = bl ? new KeyEvent(this.getRootPane(), 32, System.currentTimeMillis(), 576, 32, ' ') : new KeyEvent(this.getRootPane(), 32, System.currentTimeMillis(), 512, 32, ' ');
        this.screen.screenPanelKeyTyped(keyEvent);
        this.screen.requestFocus();
        if (this.robot != null) {
            this.robot.mousePress(16);
        }
        this.screen.screenPanelKeyReleased(keyEvent);
        if (this.robot != null) {
            this.robot.mouseRelease(16);
        }
    }

    private void setupScreen() {
        if (this.screen != null) {
            this.remove(this.screen);
        }
        this.add((Component)this.screen, "Center");
        this.add((Component)this.monitorPanel, "Last");
        if (this.inifile.getTrueOrFalse("MONITOR-VISIBLE")) {
            this.monitorPanel.setVisible(true);
            this.monitorVisibleCheckBoxMenuItem.setSelected(true);
        } else {
            this.monitorPanel.setVisible(false);
            this.monitorVisibleCheckBoxMenuItem.setSelected(false);
        }
        Dimension dimension = this.screen.getImageSize();
        if (this.isDouble) {
            dimension.width *= 2;
            dimension.height *= 2;
        }
        this.screen.setDoubleSize(this.isDouble);
        this.screen.setFullSize(this.windowMode > 0);
        this.screen.setMinimumSize(dimension);
        this.screen.setMaximumSize(dimension);
        this.screen.setPreferredSize(dimension);
        this.screen.setSize(dimension);
        this.screen.setMonitor(this.monitor);
        this.invalidate();
        this.screen.setVisible(true);
        this.screen.setFocusable(true);
        this.pack();
    }

    public void setMonitor(Monitor monitor, boolean bl) {
        this.monitor = monitor;
        this.screen.setMonitor(monitor);
        if (bl) {
            this.getOptions();
        }
    }

    public JTextArea getDataLogger() {
        return this.monitorPanel.getDataLogger();
    }

    public JTextArea getRegLogger() {
        return this.monitorPanel.getRegLogger();
    }

    public JTextField getInputWindow() {
        return this.monitorPanel.getInputWindow();
    }

    public void setRomfile(String string) {
        this.romFile = string;
    }

    public void setFocus() {
        if (this.screen != null) {
            this.screen.requestFocus();
            this.screen.requestFocusInWindow();
        }
    }

    @Override
    public void monitorCommand(String string) {
        if (this.monitor != null) {
            this.monitor.executeMonitorCommand(string);
        }
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.formComponentMoved(componentEvent);
    }

    private void formComponentMoved(ComponentEvent componentEvent) {
        Point point;
        if (this.screen.isShowing()) {
            point = this.screen.getLocationOnScreen();
            this.monitor.setScreenCoordinates(point.x, point.y);
        }
        point = this.getLocation();
        if (this.windowMode < 1) {
            this.inifile.setOptionValue("WDW-XPOS", "" + point.x);
            this.setOptionAndSave("WDW-YPOS", "" + point.y);
        }
    }

    private void formWindowActivated(WindowEvent windowEvent) {
        this.formComponentMoved(windowEvent);
        this.windowActivated = true;
    }

    private void setNFANameMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setDeviceNames(this.nfaNames, "NFA", 1313227056, true);
    }

    private void setSFANameMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setDeviceNames(this.sfaNames, "SFA", 1397113136, true);
    }

    private void setQxlNameMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setDeviceNames(this.winNames, "WIN", 1464421936, false);
    }

    private void setFlpNamesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setDeviceNames(this.flpNames, "FLP", 0, false);
        this.monitor.setFloppyNames(this.flpNames);
    }

    private void setMemNamesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setDeviceNames(this.memNames, "MEM", 1296387376, false);
    }

    private void setDeviceNames(String[] stringArray, String string, int n, boolean bl) {
        this.dad = new DriveAssignmentsDialog(this, true, stringArray, string, bl, this.inifile.getOptionValue("EXPANDED_DIR"));
        Point point = this.getMousePosition();
        if (point == null) {
            point = new Point();
        }
        Point point2 = this.getLocationOnScreen();
        if (!this.dad.adoptChanges(stringArray, point.x + point2.x + 10, point.y + point2.y + 10)) {
            return;
        }
        String[] stringArray2 = this.dad.getOptions();
        this.setAndStoreDeviceNames(string, stringArray, stringArray2, bl);
        this.monitor.setNamesForDrives(n, stringArray, false);
    }

    private void setAndStoreDeviceNames(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        for (int i = 0; i < 8; ++i) {
            stringArray[i] = bl && stringArray2[i] != null && !stringArray2[i].isEmpty() && !stringArray2[i].endsWith(File.separator) ? stringArray2[i] + File.separator : stringArray2[i];
            this.inifile.setOptionValue(string + (i + 1), stringArray[i]);
        }
        try {
            this.inifile.writeIniFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNewDeviceNames(int n, String[] stringArray) {
        String string;
        boolean bl;
        String[] stringArray2;
        switch (n) {
            case 1464421936: {
                stringArray2 = this.winNames;
                bl = false;
                string = "WIN";
                break;
            }
            case 0: {
                stringArray2 = this.flpNames;
                bl = false;
                string = "FLP";
                break;
            }
            case 1313227056: {
                stringArray2 = this.nfaNames;
                bl = true;
                string = "NFA";
                break;
            }
            case 1397113136: {
                stringArray2 = this.sfaNames;
                bl = true;
                string = "SFA";
                break;
            }
            case 1296387376: {
                stringArray2 = this.memNames;
                bl = false;
                string = "MEM";
                break;
            }
            default: {
                return;
            }
        }
        this.setAndStoreDeviceNames(string, stringArray2, stringArray, bl);
    }

    private void setNfaNameChange(int n) {
        this.monitor.setFilenameChange(1313227056, n);
        this.setOptionAndSave("NFA-FILENAME-CHANGE", "" + n);
    }

    private void nfaNameUnchangedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setNfaNameChange(0);
    }

    private void nfaNameUpperCaseRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setNfaNameChange(1);
    }

    private void nfaNameLowerCaseRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setNfaNameChange(2);
    }

    private void setSfaNameChange(int n) {
        this.monitor.setFilenameChange(1397113136, n);
        this.setOptionAndSave("SFA-FILENAME-CHANGE", "" + n);
    }

    private void sfaNameUnchangedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setSfaNameChange(0);
    }

    private void sfaNameUpperCaseRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setSfaNameChange(1);
    }

    private void sfaNameLowerCaseRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setSfaNameChange(2);
    }

    private void nfaUseMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getUsageName("NFA");
    }

    private void sfaUseMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getUsageName("SFA");
    }

    private void qxlUseMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getUsageName("WIN");
    }

    private void flpUseMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getUsageName("FLP");
    }

    private void memUseMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getUsageName("MEM");
    }

    private void getUsageName(String string) {
        String string2 = this.inifile.getOptionValue((string = string.toUpperCase()) + "_USE");
        if (string2 == null || string2.isEmpty()) {
            string2 = string;
        }
        if ((string2 = (String)JOptionPane.showInputDialog(this, Localization.Texts[36] + "\n" + string + Localization.Texts[37], Localization.Texts[38] + string, -1, null, null, string2)) == null || string2.isEmpty()) {
            return;
        }
        if (string2.length() != 3) {
            Helper.reportError(Localization.Texts[30], Localization.Texts[39] + string2, this);
        } else {
            this.setOptionAndSave(string + "_USE", string2.toUpperCase());
        }
    }

    private void screenSizeMenuItemActionPerformed(ActionEvent actionEvent) {
        Dimension dimension = this.screen.getImageSize();
        String string = (String)JOptionPane.showInputDialog(this, Localization.Texts[40] + "\n" + Localization.Texts[41] + " '512 x 256' " + Localization.Texts[42] + " '1024 x 512'\n" + Localization.Texts[98] + "\n" + Localization.Texts[43] + dimension.width + " x " + dimension.height + "\n" + Localization.Texts[95] + "\n<html><font color=red>" + Localization.Texts[29] + "</font></html>", Localization.Texts[44], -1, null, null, null);
        if (string == null || string.isEmpty()) {
            return;
        }
        try {
            String[] stringArray = string.split("x");
            if (stringArray.length != 2 && (stringArray = string.split("\\*")).length != 2) {
                throw new IOException();
            }
            int n = Integer.parseInt(stringArray[0].trim());
            int n2 = Integer.parseInt(stringArray[1].trim());
            if (n < 512) {
                n = 512;
            }
            if (n2 < 256) {
                n2 = 256;
            }
            this.inifile.setOptionValue("WDW_XSIZE", "" + (n += n % 8 == 0 ? 0 : 8 - n % 8));
            this.inifile.setOptionValue("WDW_YSIZE", "" + n2);
            this.inifile.writeIniFile();
            this.changeScreen(n, n2);
        }
        catch (Exception exception) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[40], this);
        }
    }

    private void changeScreen(int n, int n2) {
        boolean bl = false;
        if (this.screen != null) {
            bl = this.screen.isVibrantColours();
        }
        this.screen = null;
        switch (this.screenMode) {
            case 32: {
                this.screen = new Screen32(n, n2, 0, bl, this.monitor, false);
                break;
            }
            case 16: {
                this.screen = new Screen16(n, n2, 0, bl, this.monitor, false);
                break;
            }
            default: {
                this.screen = n == 512 && n2 == 256 ? new Screen0(512, 256, -1, null, false) : new Screen0(n, n2, 0, null, false);
            }
        }
        this.setupScreen();
        this.pack();
        this.monitor.changeMemSize(-1, this.screen, this.inifile.getTrueOrFalse("QL-SCREEN-EMULATION"));
    }

    private void fastModeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.monitor.setFastMode(this.fastModeMenuItem.isSelected());
        if (this.fastModeMenuItem.isSelected()) {
            this.setOptionAndSave("FAST-MODE", "1");
        } else {
            this.setOptionAndSave("FAST-MODE", "0");
        }
    }

    private void deutschRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setLanguage(1);
        this.setOptionAndSave("LANGUAGE", "1");
    }

    private void englishRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setLanguage(2);
        this.setOptionAndSave("LANGUAGE", "2");
    }

    private void espanolRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setLanguage(3);
        this.setOptionAndSave("LANGUAGE", "3");
    }

    private void francaisRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setLanguage(4);
        this.setOptionAndSave("LANGUAGE", "4");
    }

    private void setLanguage(int n) {
        if (n > 0 & n < 6) {
            this.language = n;
            Localization.setLanguage(n);
        }
        this.filesMenu.setText(Localization.Texts[1]);
        this.devicesMenu.setText(Localization.Texts[132]);
        this.configMenu.setText(Localization.Texts[3]);
        this.aboutMenuItem.setText(Localization.Texts[4]);
        this.loadSmsqeFileMenuItem.setText(Localization.Texts[6]);
        this.resetMenuItem.setText(Localization.Texts[7]);
        this.setNFANameMenuItem.setText(Localization.Texts[8]);
        this.changeNfaNamesMenu.setText(Localization.Texts[9]);
        this.nfaUseMenuItem.setText(Localization.Texts[10]);
        this.setSFANameMenuItem.setText(Localization.Texts[11]);
        this.changeSfaNamesMenu.setText(Localization.Texts[12]);
        this.sfaUseMenuItem.setText(Localization.Texts[13]);
        this.setQxlNameMenuItem.setText(Localization.Texts[14]);
        this.qxlUseMenuItem.setText(Localization.Texts[15]);
        this.setFlpNamesMenuItem.setText(Localization.Texts[79]);
        this.flpUseMenuItem.setText(Localization.Texts[80]);
        this.setMemNamesMenuItem.setText(Localization.Texts[118]);
        this.memUseMenuItem.setText(Localization.Texts[119]);
        this.screenSizeMenuItem.setText(Localization.Texts[16]);
        this.screenColoursMenu.setText(Localization.Texts[17]);
        this.vibrantColoursMenuItem.setText(Localization.Texts[109]);
        this.screenUpdateRateMenuItem.setText(Localization.Texts[129]);
        this.windowModeMenuItem.setText(Localization.Texts[134]);
        this.windowMenuItem.setText(Localization.Texts[135]);
        this.fullSizeMenuItem.setText(Localization.Texts[136]);
        this.specialFullSizeMenuItem.setText(Localization.Texts[137]);
        this.fullScreenMonitorMenuItem.setText(Localization.Texts[138]);
        this.exitMenuItem.setText(Localization.Texts[141]);
        this.memSizeMenuItem.setText(Localization.Texts[18]);
        this.monitorVisibleCheckBoxMenuItem.setText(Localization.Texts[19]);
        this.fastModeMenuItem.setText(Localization.Texts[20]);
        this.nfaNameUnchangedRadioButton.setText(Localization.Texts[21]);
        this.nfaNameUpperCaseRadioButton.setText(Localization.Texts[22]);
        this.nfaNameLowerCaseRadioButton.setText(Localization.Texts[23]);
        this.sfaNameUnchangedRadioButton.setText(Localization.Texts[21]);
        this.sfaNameUpperCaseRadioButton.setText(Localization.Texts[22]);
        this.sfaNameLowerCaseRadioButton.setText(Localization.Texts[23]);
        this.wordColoursRadioButton.setText(Localization.Texts[24]);
        this.QLColoursRadioButton.setText(Localization.Texts[25]);
        this.byteColoursRadioButton.setText(Localization.Texts[107]);
        switch (this.language) {
            case 1: {
                this.deutschRadioButton.setSelected(true);
                break;
            }
            default: {
                this.englishRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.espanolRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.francaisRadioButton.setSelected(true);
                break;
            }
            case 5: {
                this.italianRadioButton.setSelected(true);
            }
        }
        this.beepVolumeItem.setText(Localization.Texts[113]);
        this.suspendIconifiedMenuItem.setText(Localization.Texts[110]);
        this.dateOffsetMenuItem.setText(Localization.Texts[93]);
        this.menuBarInvisibleMenuItem.setText(Localization.Texts[71]);
        if (this.isDouble) {
            this.doubleSizeMenuItem.setText(Localization.Texts[97]);
        } else {
            this.doubleSizeMenuItem.setText(Localization.Texts[96]);
        }
        this.warningsMenu.setText(Localization.Texts[82]);
        this.nonStandardQXLDriveCheckBox.setText(Localization.Texts[83]);
        this.nonexistingQxlFileCheckBox.setText(Localization.Texts[84]);
        this.qxlDriveFullCheckBox.setText(Localization.Texts[85]);
        this.qxlDriveIsReadOnlyCheckBox.setText(Localization.Texts[104]);
        this.flpReadOnlyCheckBoxMenuItem.setText(Localization.Texts[122]);
        this.soundProblemCheckBox.setText(Localization.Texts[114]);
        this.ssssFrequencyMenuItem.setText(Localization.Texts[143]);
        this.nonexistingFlpFileCheckBoxMenuItem.setText(Localization.Texts[124]);
        this.qxlDisableCheckBoxMenuItem.setText(Localization.Texts[99]);
        this.qxlIgnoreFilelockErrorCheckBoxMenuItem.setText(Localization.Texts[125]);
        this.unlockable2ReadOnlyCheckBoxMenuItem.setText(Localization.Texts[144]);
        this.nfaDisableCheckBoxMenuItem.setText(Localization.Texts[100]);
        this.sfaDisableCheckBoxMenuItem.setText(Localization.Texts[101]);
        this.flpDisableCheckBoxMenuItem.setText(Localization.Texts[102]);
        this.memDisableCheckBoxMenuItem.setText(Localization.Texts[120]);
        this.idleMenuItem.setText(Localization.Texts[121]);
        this.mouseClickDelayMenuItem.setText(Localization.Texts[127]);
        this.mousewheelAccelItem.setText(Localization.Texts[148] + ": " + this.inifile.getOptionValue("MOUSEWHEEL-ACCEL"));
        this.allowScreenEmulationjCheckBoxMenuItem.setText(Localization.Texts[142]);
        this.popupActionMenu.setText(Localization.Texts[145]);
        this.popupOpenWdwCheckBoxMenuItem.setText(Localization.Texts[146]);
        this.popupBlinkCheckBoxMenuItem.setText(Localization.Texts[147]);
        this.pack();
    }

    private void setScreenModeForNextRestart(int n) {
        this.setOptionAndSave("SCREEN-MODE", "" + n);
        switch (n) {
            case 0: {
                this.screenMode = 0;
                break;
            }
            case 2: {
                this.screenMode = 16;
                break;
            }
            case 3: {
                this.screenMode = 32;
            }
        }
        this.changeScreen(this.screen.xsize, this.screen.ysize);
    }

    private void wordColoursRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setScreenModeForNextRestart(3);
    }

    private void QLColoursRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setScreenModeForNextRestart(0);
    }

    private void byteColoursRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setScreenModeForNextRestart(2);
    }

    private void monitorVisibleCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.monitorPanel.setVisible(this.monitorVisibleCheckBoxMenuItem.isSelected());
        this.pack();
        if (this.monitorVisibleCheckBoxMenuItem.isSelected()) {
            this.setOptionAndSave("MONITOR-VISIBLE", "1");
        } else {
            this.setOptionAndSave("MONITOR-VISIBLE", "0");
        }
    }

    private void memSizeMenuItemActionPerformed(ActionEvent actionEvent) {
        int n = this.screen != null ? this.screen.getMode() : 0;
        Object[] objectArray = new Object[memPossibilities.length - 3];
        if (n > 8) {
            System.arraycopy(memPossibilities, 3, objectArray, 0, memPossibilities.length - 3);
        } else {
            objectArray = memPossibilities;
        }
        String string = (String)JOptionPane.showInputDialog(this, Localization.Texts[26] + "\n" + Localization.Texts[27] + this.memSize + "MB\n<html><font color=red>" + Localization.Texts[29] + "</font></html>", Localization.Texts[28], -1, null, objectArray, "" + this.memSize);
        if (string != null && !string.isEmpty()) {
            try {
                this.memSize = Integer.parseInt(string);
                this.setOptionAndSave("MEM_SIZE", string);
                this.monitor.changeMemSize(this.memSize * 1024 * 1024, this.screen, this.inifile.getTrueOrFalse("QL-SCREEN-EMULATION"));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, Localization.Texts[30], string + Localization.Texts[31], 0);
            }
        }
    }

    private void doubleSizeMenuItemActionPerformed(ActionEvent actionEvent) {
        Dimension dimension = this.screen.getImageSize();
        if (this.isDouble) {
            this.doubleSizeMenuItem.setText(Localization.Texts[96]);
        } else {
            dimension.width *= 2;
            dimension.height *= 2;
            this.doubleSizeMenuItem.setText(Localization.Texts[97]);
        }
        this.isDouble = !this.isDouble;
        this.screen.setDoubleSize(this.isDouble);
        this.screen.setSize(dimension);
        this.screen.setMinimumSize(dimension);
        this.screen.setMaximumSize(dimension);
        this.screen.setPreferredSize(dimension);
        this.invalidate();
        this.pack();
        this.setOptionAndSave("DOUBLE-SIZE", this.isDouble ? "1" : "0");
    }

    private void nonStandardQXLDriveCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfQXLDriveNotCompliant = this.nonStandardQXLDriveCheckBox.isSelected();
        this.setOptionAndSave("WARN-ON-NONSTANDARD-WINDRIVE", this.warnings.warnIfQXLDriveNotCompliant ? "1" : "0");
    }

    private void nonexistingQxlFileCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfNonexistingQXLDrive = this.nonexistingQxlFileCheckBox.isSelected();
        this.setOptionAndSave("WARN-ON-NONEXISTING-WINDRIVE", this.warnings.warnIfNonexistingQXLDrive ? "1" : "0");
    }

    private void qxlDriveFullCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfQXLDriveFull = this.qxlDriveFullCheckBox.isSelected();
        this.setOptionAndSave("WARN-ON-WINDRIVE-FULL", this.warnings.warnIfQXLDriveFull ? "1" : "0");
    }

    private void qxlDriveIsReadOnlyCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfQXLDriveIsReadOnly = this.qxlDriveIsReadOnlyCheckBox.isSelected();
        this.setOptionAndSave("WARN-ON-WINDRIVE-READ-ONLY", this.warnings.warnIfQXLDriveIsReadOnly ? "1" : "0");
    }

    private void soundProblemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfSoundProblem = this.soundProblemCheckBox.isSelected();
        this.setOptionAndSave("WARN-ON-SOUND-PROBLEM", this.warnings.warnIfSoundProblem ? "1" : "0");
    }

    private void flpReadOnlyCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfFLPDriveIsReadOnly = this.flpReadOnlyCheckBoxMenuItem.isSelected();
        this.setOptionAndSave("WARN-ON-FLPDRIVE-READ-ONLY", this.warnings.warnIfFLPDriveIsReadOnly ? "1" : "0");
    }

    private void nonexistingFlpFileCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.warnings.warnIfNonexistingFLPDrive = this.nonexistingFlpFileCheckBoxMenuItem.isSelected();
        this.setOptionAndSave("WARN-ON-NONEXISTING-FLPDRIVE", this.warnings.warnIfNonexistingFLPDrive ? "1" : "0");
    }

    private void dateOffsetMenuItemActionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        String string = this.inifile.getOptionValue("TIME-OFFSET");
        while (bl) {
            if ((string = (String)JOptionPane.showInputDialog(this, Localization.Texts[94], Localization.Texts[93], -1, null, null, string)) == null || string.isEmpty()) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                this.monitor.setTimeOffset(n);
                this.setOptionAndSave("TIME-OFFSET", "" + n);
                bl = false;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, string + Localization.Texts[90], Localization.Texts[45], 0);
            }
        }
    }

    private void menuBarInvisibleMenuItemActionPerformed(ActionEvent actionEvent) {
        this.menuBarVisible(false);
    }

    public void menuBarVisible(boolean bl) {
        this.jMenuBar1.setVisible(bl);
        this.pack();
        this.setOptionAndSave("MENUBAR-VISIBLE", bl ? "1" : "0");
    }

    public int menuBarIsVisible() {
        return this.jMenuBar1.isVisible() ? 1 : 0;
    }

    private void suspendIconifiedMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("SUSPEND-WHEN-ICONIFIED", this.suspendIconifiedMenuItem.isSelected() ? "1" : "0");
    }

    private void flpDisableCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("DISABLE-FLP-DEVICE", this.flpDisableCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void qxlDisableCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("DISABLE-WIN-DEVICE", this.qxlDisableCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void sfaDisableCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("DISABLE-SFA-DEVICE", this.sfaDisableCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void nfaDisableCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("DISABLE-NFA-DEVICE", this.nfaDisableCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void memDisableCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("DISABLE-MEM-DEVICE", this.memDisableCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void vibrantColoursMenuItemActionPerformed(ActionEvent actionEvent) {
        this.screen.setVibrantColours(this.vibrantColoursMenuItem.isSelected(), this.monitor.cpu.getMemory());
        this.setOptionAndSave("VIBRANT-COLOURS", this.vibrantColoursMenuItem.isSelected() ? "1" : "0");
    }

    private void beepVolumeItemActionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        String string = this.inifile.getOptionValue("SOUND-VOLUME");
        while (bl) {
            if ((string = (String)JOptionPane.showInputDialog(this, Localization.Texts[112], Localization.Texts[113], -1, null, null, string)) == null || string.isEmpty()) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                this.monitor.setSoundVolume(n);
                this.setOptionAndSave("SOUND-VOLUME", "" + n);
                bl = false;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, string + Localization.Texts[90], Localization.Texts[45], 0);
            }
        }
    }

    private void idleMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("LESS-CPU-WHEN-IDLE", this.idleMenuItem.isSelected() ? "1" : "0");
    }

    private void qxlIgnoreFilelockErrorCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("IGNORE-QXLWIN-LOCK-ERROR", this.qxlIgnoreFilelockErrorCheckBoxMenuItem.isSelected() ? "1" : "0");
        this.unlockable2ReadOnlyCheckBoxMenuItem.setEnabled(this.qxlIgnoreFilelockErrorCheckBoxMenuItem.isSelected());
    }

    private void mouseClickDelayMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.inifile.getOptionValue("MOUSE-CLICK-DELAY");
        if (string == null || string.isEmpty()) {
            string = "0";
        }
        boolean bl = true;
        while (bl) {
            if ((string = (String)JOptionPane.showInputDialog(this, Localization.Texts[128], Localization.Texts[127], -1, null, null, string)) == null || string.isEmpty()) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                this.setOptionAndSave("MOUSE-CLICK-DELAY", "" + n);
                this.mouseClickDelayMenuItem.setText(Localization.Texts[127] + n);
                this.screen.setMouseClickDelay(n);
                bl = false;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, string + Localization.Texts[90], Localization.Texts[45], 0);
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        URL uRL = MonitorGui.class.getResource("images/combined.png");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            JOptionPane.showMessageDialog(this, Localization.Texts[5] + Localization.Texts[106] + this.version, "SMSQmulator ", 1, imageIcon);
        } else {
            JOptionPane.showMessageDialog(this, Localization.Texts[5] + Localization.Texts[106] + this.version, "SMSQmulator ", 1);
        }
    }

    private void loadSmsqeFileMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.inifile.getOptionValue("ROM_IMAGE_FILE");
        if (string != null && !string.isEmpty()) {
            this.fc.setCurrentDirectory(new File(string));
        }
        if (this.fc.showOpenDialog(this) == 0) {
            File file = this.fc.getSelectedFile();
            this.setOptionAndSave("ROM_IMAGE_FILE", file.getAbsolutePath());
            if (this.monitor.loadRom(file)) {
                this.monitor.goCommand(null, -1);
            }
        }
    }

    private void resetMenuItemActionPerformed(ActionEvent actionEvent) {
        this.monitor.reset();
    }

    private void formWindowOpened(WindowEvent windowEvent) {
        this.getOptions();
        if (!this.romFile.isEmpty()) {
            this.screen.requestFocusInWindow();
            this.screen.requestFocus();
            if (this.monitor.loadRom(this.romFile, null)) {
                this.monitor.goCommand(null, -1);
            } else {
                Helper.reportError(Localization.Texts[45], Localization.Texts[32] + " (" + this.romFile + ")", null);
            }
        } else {
            Helper.reportError(Localization.Texts[32], Localization.Texts[33] + "\n" + Localization.Texts[34], this);
        }
        this.formComponentMoved(null);
    }

    private void formWindowDeactivated(WindowEvent windowEvent) {
        this.windowActivated = false;
    }

    private void formWindowIconified(WindowEvent windowEvent) {
        if (this.suspendIconifiedMenuItem.isSelected()) {
            this.monitor.suspendExecution();
        }
    }

    private void formWindowDeiconified(WindowEvent windowEvent) {
        if (this.suspendIconifiedMenuItem.isSelected()) {
            this.monitor.resumeExecution();
        }
    }

    private void getOptions() {
        int n;
        String string = this.inifile.getOptionValue("EXPANDED_DIR");
        this.getDriveNames("NFA", this.nfaNames, true, string);
        this.getDriveNames("SFA", this.sfaNames, true, string);
        this.getDriveNames("WIN", this.winNames, false, string);
        this.getDriveNames("MEM", this.memNames, false, string);
        this.getDriveNames("FLP", this.flpNames, false, string);
        if (this.monitor != null) {
            this.monitor.setNamesForDrives(1397113136, this.sfaNames, true);
            this.monitor.setNamesForDrives(1313227056, this.nfaNames, true);
            this.monitor.setNamesForDrives(1464421936, this.winNames, true);
            this.monitor.setNamesForDrives(1296387376, this.memNames, true);
            this.monitor.setFloppyNames(this.flpNames);
            n = this.inifile.getOptionAsInt("NFA-FILENAME-CHANGE", 0);
            this.monitor.setFilenameChange(1313227056, n);
            switch (n) {
                default: {
                    this.nfaNameUnchangedRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.nfaNameUpperCaseRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.nfaNameLowerCaseRadioButton.setSelected(true);
                }
            }
            n = this.inifile.getOptionAsInt("SFA-FILENAME-CHANGE", 0);
            this.monitor.setFilenameChange(1397113136, n);
            switch (n) {
                default: {
                    this.sfaNameUnchangedRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.sfaNameUpperCaseRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.sfaNameLowerCaseRadioButton.setSelected(true);
                }
            }
            string = this.inifile.getOptionValue("NFA_USE");
            if (string != null && !string.isEmpty()) {
                this.monitor.setUsageForDrive(1313227056, string);
            }
            if ((string = this.inifile.getOptionValue("SFA_USE")) != null && !string.isEmpty()) {
                this.monitor.setUsageForDrive(1397113136, string);
            }
            if ((string = this.inifile.getOptionValue("WIN_USE")) != null && !string.isEmpty()) {
                this.monitor.setUsageForDrive(1464421936, string);
            }
            if ((string = this.inifile.getOptionValue("MEM_USE")) != null && !string.isEmpty()) {
                this.monitor.setUsageForDrive(1296387376, string);
            }
        }
        this.memSize = this.inifile.getOptionAsInt("MEM_SIZE", 8);
        if (this.inifile.getTrueOrFalse("MONITOR-VISIBLE")) {
            this.monitorPanel.setVisible(true);
            this.monitorVisibleCheckBoxMenuItem.setSelected(true);
        } else {
            this.monitorPanel.setVisible(false);
            this.monitorVisibleCheckBoxMenuItem.setSelected(false);
        }
        n = this.inifile.getOptionAsInt("SCREEN-MODE", 0);
        switch (n) {
            default: {
                this.QLColoursRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.byteColoursRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.wordColoursRadioButton.setSelected(true);
            }
        }
        n = this.inifile.getOptionAsInt("DIVIDER-LOCATION", 0);
        if (n != 0) {
            this.monitorPanel.setDividerLocation(n);
        }
        if (this.inifile.getTrueOrFalse("FAST-MODE")) {
            this.fastModeMenuItem.setSelected(true);
        } else {
            this.fastModeMenuItem.setSelected(false);
        }
        this.pack();
    }

    private void getDriveNames(String string, String[] stringArray, boolean bl, String string2) {
        for (int i = 0; i < 8; ++i) {
            String string3 = this.inifile.getOptionValue(string + (i + 1));
            if (string3 == null) continue;
            if (bl && !string3.isEmpty() && !string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            if (string3.startsWith("./")) {
                string3 = string2 + string3.substring(2);
            }
            stringArray[i] = string3;
        }
    }

    public void deIconify() {
        if ((this.getExtendedState() & 1) != 0) {
            if (this.inifile.getTrueOrFalse("POPUP-ACTION")) {
                Image image = MonitorGui.getFDImage("images/smsqmulatorinv.png");
                TBFlasher tBFlasher = new TBFlasher(this, image);
                tBFlasher.execute();
            } else {
                this.setExtendedState(0);
            }
        }
    }

    public void iconify() {
        this.setExtendedState(1);
    }

    private void setOptionAndSave(String string, String string2) {
        this.inifile.setOptionValue(string, string2);
        try {
            this.inifile.writeIniFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Image getFDImage(String string) {
        URL uRL = MonitorGui.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL).getImage();
        }
        return null;
    }

    public final Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void dividerLocationChanged(int n) {
        this.setOptionAndSave("DIVIDER-LOCATION", "" + n);
    }

    public boolean getMouseIsInScreen() {
        return this.screen.mouseInScreen() & this.windowActivated;
    }

    public boolean setMousePosition(int n, int n2) {
        return this.screen.setMousePosition(n, n2);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.buttonGroup6 = new ButtonGroup();
        this.buttonGroup7 = new ButtonGroup();
        this.jMenuBar1 = new JMenuBar();
        this.filesMenu = new JMenu();
        this.loadSmsqeFileMenuItem = new JMenuItem();
        this.resetMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.configMenu = new JMenu();
        this.jMenu6 = new JMenu();
        this.deutschRadioButton = new JRadioButtonMenuItem();
        this.englishRadioButton = new JRadioButtonMenuItem();
        this.espanolRadioButton = new JRadioButtonMenuItem();
        this.francaisRadioButton = new JRadioButtonMenuItem();
        this.italianRadioButton = new JRadioButtonMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.devicesMenu = new JMenu();
        this.setNFANameMenuItem = new JMenuItem();
        this.changeNfaNamesMenu = new JMenu();
        this.nfaNameUnchangedRadioButton = new JRadioButtonMenuItem();
        this.nfaNameUpperCaseRadioButton = new JRadioButtonMenuItem();
        this.nfaNameLowerCaseRadioButton = new JRadioButtonMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.nfaUseMenuItem = new JMenuItem();
        this.nfaDisableCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.setSFANameMenuItem = new JMenuItem();
        this.changeSfaNamesMenu = new JMenu();
        this.sfaNameUnchangedRadioButton = new JRadioButtonMenuItem();
        this.sfaNameUpperCaseRadioButton = new JRadioButtonMenuItem();
        this.sfaNameLowerCaseRadioButton = new JRadioButtonMenuItem();
        this.sfaUseMenuItem = new JMenuItem();
        this.sfaDisableCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.setQxlNameMenuItem = new JMenuItem();
        this.qxlUseMenuItem = new JMenuItem();
        this.qxlDisableCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.qxlIgnoreFilelockErrorCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.unlockable2ReadOnlyCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.setFlpNamesMenuItem = new JMenuItem();
        this.flpUseMenuItem = new JMenuItem();
        this.flpDisableCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.flpUseNameMenuItem = new JPopupMenu.Separator();
        this.setMemNamesMenuItem = new JMenuItem();
        this.memUseMenuItem = new JMenuItem();
        this.memDisableCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.screenSizeMenuItem = new JMenuItem();
        this.screenColoursMenu = new JMenu();
        this.wordColoursRadioButton = new JRadioButtonMenuItem();
        this.byteColoursRadioButton = new JRadioButtonMenuItem();
        this.QLColoursRadioButton = new JRadioButtonMenuItem();
        this.windowModeMenuItem = new JMenu();
        this.windowMenuItem = new JRadioButtonMenuItem();
        this.fullSizeMenuItem = new JRadioButtonMenuItem();
        this.specialFullSizeMenuItem = new JRadioButtonMenuItem();
        this.vibrantColoursMenuItem = new JCheckBoxMenuItem();
        this.doubleSizeMenuItem = new JMenuItem();
        this.screenUpdateRateMenuItem = new JMenuItem();
        this.allowScreenEmulationjCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.fullScreenMonitorMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.beepVolumeItem = new JMenuItem();
        this.ssssFrequencyMenuItem = new JMenu();
        this.ssss22KHzCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.ssss20KHzCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.memSizeMenuItem = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.monitorVisibleCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.fastModeMenuItem = new JCheckBoxMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.idleMenuItem = new JCheckBoxMenuItem();
        this.suspendIconifiedMenuItem = new JCheckBoxMenuItem();
        this.popupActionMenu = new JMenu();
        this.popupOpenWdwCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.popupBlinkCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.mouseClickDelayMenuItem = new JMenuItem();
        this.mousewheelAccelItem = new JMenuItem();
        this.dateOffsetMenuItem = new JMenuItem();
        this.menuBarInvisibleMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.warningsMenu = new JMenu();
        this.nonStandardQXLDriveCheckBox = new JCheckBoxMenuItem();
        this.nonexistingQxlFileCheckBox = new JCheckBoxMenuItem();
        this.qxlDriveFullCheckBox = new JCheckBoxMenuItem();
        this.qxlDriveIsReadOnlyCheckBox = new JCheckBoxMenuItem();
        this.soundProblemCheckBox = new JCheckBoxMenuItem();
        this.flpReadOnlyCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.nonexistingFlpFileCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jMenu3 = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.javaVersionMenuItem = new JMenuItem();
        this.jMenu1.setText("File");
        this.jMenuBar2.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar2.add(this.jMenu2);
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                MonitorGui.this.formComponentMoved(componentEvent);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MonitorGui.this.formComponentResized(componentEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                MonitorGui.this.formWindowActivated(windowEvent);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                MonitorGui.this.formWindowDeactivated(windowEvent);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                MonitorGui.this.formWindowDeiconified(windowEvent);
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                MonitorGui.this.formWindowIconified(windowEvent);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                MonitorGui.this.formWindowOpened(windowEvent);
            }
        });
        this.filesMenu.setText("File");
        this.loadSmsqeFileMenuItem.setText("Load SMSQE File");
        this.loadSmsqeFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.loadSmsqeFileMenuItemActionPerformed(actionEvent);
            }
        });
        this.filesMenu.add(this.loadSmsqeFileMenuItem);
        this.resetMenuItem.setText("Reset");
        this.resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.resetMenuItemActionPerformed(actionEvent);
            }
        });
        this.filesMenu.add(this.resetMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.filesMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.filesMenu);
        this.configMenu.setText("Config");
        this.jMenu6.setText("Language/Sprache/Lengua/Langue/Lingua");
        this.jMenu6.setActionCommand("Lnaguage/Sprache/Lenguaje/Langue");
        this.buttonGroup4.add(this.deutschRadioButton);
        this.deutschRadioButton.setSelected(true);
        this.deutschRadioButton.setText("Deutsch");
        this.deutschRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.deutschRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.deutschRadioButton);
        this.buttonGroup4.add(this.englishRadioButton);
        this.englishRadioButton.setText("English");
        this.englishRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.englishRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.englishRadioButton);
        this.buttonGroup4.add(this.espanolRadioButton);
        this.espanolRadioButton.setText("Espa\u00f1ol");
        this.espanolRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.espanolRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.espanolRadioButton);
        this.buttonGroup4.add(this.francaisRadioButton);
        this.francaisRadioButton.setText("Fran\u00e7ais");
        this.francaisRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.francaisRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.francaisRadioButton);
        this.buttonGroup4.add(this.italianRadioButton);
        this.italianRadioButton.setText("Italiano");
        this.italianRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.italianRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.italianRadioButton);
        this.configMenu.add(this.jMenu6);
        this.configMenu.add(this.jSeparator6);
        this.devicesMenu.setText("Devices");
        this.setNFANameMenuItem.setText("Set dirs for NFA drives");
        this.setNFANameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.setNFANameMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.setNFANameMenuItem);
        this.changeNfaNamesMenu.setText("NFA file name changes");
        this.buttonGroup1.add(this.nfaNameUnchangedRadioButton);
        this.nfaNameUnchangedRadioButton.setText("Leave as they are");
        this.nfaNameUnchangedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nfaNameUnchangedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.changeNfaNamesMenu.add(this.nfaNameUnchangedRadioButton);
        this.buttonGroup1.add(this.nfaNameUpperCaseRadioButton);
        this.nfaNameUpperCaseRadioButton.setText("Set all NFA names to upper case");
        this.nfaNameUpperCaseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nfaNameUpperCaseRadioButtonActionPerformed(actionEvent);
            }
        });
        this.changeNfaNamesMenu.add(this.nfaNameUpperCaseRadioButton);
        this.buttonGroup1.add(this.nfaNameLowerCaseRadioButton);
        this.nfaNameLowerCaseRadioButton.setText("Set all NFA names to lower case");
        this.nfaNameLowerCaseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nfaNameLowerCaseRadioButtonActionPerformed(actionEvent);
            }
        });
        this.changeNfaNamesMenu.add(this.nfaNameLowerCaseRadioButton);
        this.changeNfaNamesMenu.add(this.jSeparator2);
        this.devicesMenu.add(this.changeNfaNamesMenu);
        this.nfaUseMenuItem.setText("NFA USE name");
        this.nfaUseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nfaUseMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.nfaUseMenuItem);
        this.nfaDisableCheckBoxMenuItem.setSelected(true);
        this.nfaDisableCheckBoxMenuItem.setText("NFA disable");
        this.nfaDisableCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nfaDisableCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.nfaDisableCheckBoxMenuItem);
        this.devicesMenu.add(this.jSeparator1);
        this.setSFANameMenuItem.setText("Set dirs for SFA drives");
        this.setSFANameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.setSFANameMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.setSFANameMenuItem);
        this.changeSfaNamesMenu.setText("SFA file name changes");
        this.buttonGroup2.add(this.sfaNameUnchangedRadioButton);
        this.sfaNameUnchangedRadioButton.setText("Leave as they are");
        this.sfaNameUnchangedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.sfaNameUnchangedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.changeSfaNamesMenu.add(this.sfaNameUnchangedRadioButton);
        this.buttonGroup2.add(this.sfaNameUpperCaseRadioButton);
        this.sfaNameUpperCaseRadioButton.setText("Set all SFA names to upper case");
        this.sfaNameUpperCaseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.sfaNameUpperCaseRadioButtonActionPerformed(actionEvent);
            }
        });
        this.changeSfaNamesMenu.add(this.sfaNameUpperCaseRadioButton);
        this.buttonGroup2.add(this.sfaNameLowerCaseRadioButton);
        this.sfaNameLowerCaseRadioButton.setText("Set all SFA names to lower case");
        this.sfaNameLowerCaseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.sfaNameLowerCaseRadioButtonActionPerformed(actionEvent);
            }
        });
        this.changeSfaNamesMenu.add(this.sfaNameLowerCaseRadioButton);
        this.devicesMenu.add(this.changeSfaNamesMenu);
        this.sfaUseMenuItem.setText("SFA USE name");
        this.sfaUseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.sfaUseMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.sfaUseMenuItem);
        this.sfaDisableCheckBoxMenuItem.setSelected(true);
        this.sfaDisableCheckBoxMenuItem.setText("SFA disable");
        this.sfaDisableCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.sfaDisableCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.sfaDisableCheckBoxMenuItem);
        this.devicesMenu.add(this.jSeparator5);
        this.setQxlNameMenuItem.setText("Set files for QXL drives");
        this.setQxlNameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.setQxlNameMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.setQxlNameMenuItem);
        this.qxlUseMenuItem.setText("QXL USE name");
        this.qxlUseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.qxlUseMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.qxlUseMenuItem);
        this.qxlDisableCheckBoxMenuItem.setSelected(true);
        this.qxlDisableCheckBoxMenuItem.setText("WIN disable");
        this.qxlDisableCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.qxlDisableCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.qxlDisableCheckBoxMenuItem);
        this.qxlIgnoreFilelockErrorCheckBoxMenuItem.setSelected(true);
        this.qxlIgnoreFilelockErrorCheckBoxMenuItem.setText("Ignore file lock error");
        this.qxlIgnoreFilelockErrorCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.qxlIgnoreFilelockErrorCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.qxlIgnoreFilelockErrorCheckBoxMenuItem);
        this.unlockable2ReadOnlyCheckBoxMenuItem.setSelected(true);
        this.unlockable2ReadOnlyCheckBoxMenuItem.setText("Make unlockable read only");
        this.unlockable2ReadOnlyCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.unlockable2ReadOnlyCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.unlockable2ReadOnlyCheckBoxMenuItem);
        this.devicesMenu.add(this.jSeparator3);
        this.setFlpNamesMenuItem.setText("Set files for FLP drives");
        this.setFlpNamesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.setFlpNamesMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.setFlpNamesMenuItem);
        this.flpUseMenuItem.setText("FLP USE name");
        this.flpUseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.flpUseMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.flpUseMenuItem);
        this.flpDisableCheckBoxMenuItem.setSelected(true);
        this.flpDisableCheckBoxMenuItem.setText("FLP disable");
        this.flpDisableCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.flpDisableCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.flpDisableCheckBoxMenuItem);
        this.devicesMenu.add(this.flpUseNameMenuItem);
        this.setMemNamesMenuItem.setText("Set files for mem drives");
        this.setMemNamesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.setMemNamesMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.setMemNamesMenuItem);
        this.memUseMenuItem.setText("Mem USE name");
        this.memUseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.memUseMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.memUseMenuItem);
        this.memDisableCheckBoxMenuItem.setSelected(true);
        this.memDisableCheckBoxMenuItem.setText("MEM disble");
        this.memDisableCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.memDisableCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.devicesMenu.add(this.memDisableCheckBoxMenuItem);
        this.configMenu.add(this.devicesMenu);
        this.configMenu.add(this.jSeparator11);
        this.screenSizeMenuItem.setText("Set sceen size");
        this.screenSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.screenSizeMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.screenSizeMenuItem);
        this.screenColoursMenu.setText("Screen colours/mode");
        this.buttonGroup3.add(this.wordColoursRadioButton);
        this.wordColoursRadioButton.setSelected(true);
        this.wordColoursRadioButton.setText("16 bit colours");
        this.wordColoursRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.wordColoursRadioButtonActionPerformed(actionEvent);
            }
        });
        this.screenColoursMenu.add(this.wordColoursRadioButton);
        this.buttonGroup3.add(this.byteColoursRadioButton);
        this.byteColoursRadioButton.setText("8 bit colours");
        this.byteColoursRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.byteColoursRadioButtonActionPerformed(actionEvent);
            }
        });
        this.screenColoursMenu.add(this.byteColoursRadioButton);
        this.buttonGroup3.add(this.QLColoursRadioButton);
        this.QLColoursRadioButton.setText("QL colours");
        this.QLColoursRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.QLColoursRadioButtonActionPerformed(actionEvent);
            }
        });
        this.screenColoursMenu.add(this.QLColoursRadioButton);
        this.configMenu.add(this.screenColoursMenu);
        this.windowModeMenuItem.setText("Window mode");
        this.buttonGroup5.add(this.windowMenuItem);
        this.windowMenuItem.setSelected(true);
        this.windowMenuItem.setText("Window");
        this.windowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.windowMenuItemActionPerformed(actionEvent);
            }
        });
        this.windowModeMenuItem.add(this.windowMenuItem);
        this.buttonGroup5.add(this.fullSizeMenuItem);
        this.fullSizeMenuItem.setText("Full size");
        this.fullSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.fullSizeMenuItemActionPerformed(actionEvent);
            }
        });
        this.windowModeMenuItem.add(this.fullSizeMenuItem);
        this.buttonGroup5.add(this.specialFullSizeMenuItem);
        this.specialFullSizeMenuItem.setText("Special full size");
        this.specialFullSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.specialFullSizeMenuItemActionPerformed(actionEvent);
            }
        });
        this.windowModeMenuItem.add(this.specialFullSizeMenuItem);
        this.configMenu.add(this.windowModeMenuItem);
        this.vibrantColoursMenuItem.setSelected(true);
        this.vibrantColoursMenuItem.setText("Vibrant colours");
        this.vibrantColoursMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.vibrantColoursMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.vibrantColoursMenuItem);
        this.doubleSizeMenuItem.setText("Double window size");
        this.doubleSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.doubleSizeMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.doubleSizeMenuItem);
        this.screenUpdateRateMenuItem.setText("Screen update rate");
        this.screenUpdateRateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.screenUpdateRateMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.screenUpdateRateMenuItem);
        this.allowScreenEmulationjCheckBoxMenuItem.setSelected(true);
        this.allowScreenEmulationjCheckBoxMenuItem.setText("allow screen emulation");
        this.allowScreenEmulationjCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.allowScreenEmulationjCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.allowScreenEmulationjCheckBoxMenuItem);
        this.fullScreenMonitorMenuItem.setText("Monitor for full screen");
        this.fullScreenMonitorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.fullScreenMonitorMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.fullScreenMonitorMenuItem);
        this.configMenu.add(this.jSeparator4);
        this.beepVolumeItem.setText("Set beep volume");
        this.beepVolumeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.beepVolumeItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.beepVolumeItem);
        this.ssssFrequencyMenuItem.setText("SSSS Frequency");
        this.buttonGroup7.add(this.ssss22KHzCheckBoxMenuItem);
        this.ssss22KHzCheckBoxMenuItem.setSelected(true);
        this.ssss22KHzCheckBoxMenuItem.setText("22.05 KHz (22050 Hz)");
        this.ssss22KHzCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.ssss22KHzCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.ssssFrequencyMenuItem.add(this.ssss22KHzCheckBoxMenuItem);
        this.buttonGroup7.add(this.ssss20KHzCheckBoxMenuItem);
        this.ssss20KHzCheckBoxMenuItem.setText("20 KHz (20000 Hz)");
        this.ssss20KHzCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.ssss20KHzCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.ssssFrequencyMenuItem.add(this.ssss20KHzCheckBoxMenuItem);
        this.configMenu.add(this.ssssFrequencyMenuItem);
        this.configMenu.add(this.jSeparator10);
        this.memSizeMenuItem.setText("Memory Size");
        this.memSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.memSizeMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.memSizeMenuItem);
        this.configMenu.add(this.jSeparator8);
        this.monitorVisibleCheckBoxMenuItem.setSelected(true);
        this.monitorVisibleCheckBoxMenuItem.setText("Monitor visible");
        this.monitorVisibleCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.monitorVisibleCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.monitorVisibleCheckBoxMenuItem);
        this.fastModeMenuItem.setSelected(true);
        this.fastModeMenuItem.setText("Fast mode");
        this.fastModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.fastModeMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.fastModeMenuItem);
        this.configMenu.add(this.jSeparator12);
        this.idleMenuItem.setSelected(true);
        this.idleMenuItem.setText("Less CPU when idle");
        this.idleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.idleMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.idleMenuItem);
        this.suspendIconifiedMenuItem.setSelected(true);
        this.suspendIconifiedMenuItem.setText("Suspend when iconified");
        this.suspendIconifiedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.suspendIconifiedMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.suspendIconifiedMenuItem);
        this.popupActionMenu.setText("Action when popup event");
        this.buttonGroup6.add(this.popupOpenWdwCheckBoxMenuItem);
        this.popupOpenWdwCheckBoxMenuItem.setSelected(true);
        this.popupOpenWdwCheckBoxMenuItem.setText("Open window");
        this.popupOpenWdwCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.popupOpenWdwCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupActionMenu.add(this.popupOpenWdwCheckBoxMenuItem);
        this.buttonGroup6.add(this.popupBlinkCheckBoxMenuItem);
        this.popupBlinkCheckBoxMenuItem.setText("Blink");
        this.popupBlinkCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.popupBlinkCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupActionMenu.add(this.popupBlinkCheckBoxMenuItem);
        this.configMenu.add(this.popupActionMenu);
        this.configMenu.add(this.jSeparator9);
        this.mouseClickDelayMenuItem.setText("mouselcikcdelay");
        this.mouseClickDelayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.mouseClickDelayMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.mouseClickDelayMenuItem);
        this.mousewheelAccelItem.setText("Mousewheel acceleration factor");
        this.mousewheelAccelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.mousewheelAccelItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.mousewheelAccelItem);
        this.dateOffsetMenuItem.setText("Time correction");
        this.dateOffsetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.dateOffsetMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.dateOffsetMenuItem);
        this.menuBarInvisibleMenuItem.setText("Menu bar invisible");
        this.menuBarInvisibleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.menuBarInvisibleMenuItemActionPerformed(actionEvent);
            }
        });
        this.configMenu.add(this.menuBarInvisibleMenuItem);
        this.configMenu.add(this.jSeparator7);
        this.warningsMenu.setText("Warnings");
        this.nonStandardQXLDriveCheckBox.setText("Non standard qxl drive");
        this.nonStandardQXLDriveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nonStandardQXLDriveCheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.nonStandardQXLDriveCheckBox);
        this.nonexistingQxlFileCheckBox.setText("Non existing qxl file");
        this.nonexistingQxlFileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nonexistingQxlFileCheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.nonexistingQxlFileCheckBox);
        this.qxlDriveFullCheckBox.setText("qxl Drive full");
        this.qxlDriveFullCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.qxlDriveFullCheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.qxlDriveFullCheckBox);
        this.qxlDriveIsReadOnlyCheckBox.setSelected(true);
        this.qxlDriveIsReadOnlyCheckBox.setText("Drive is read only");
        this.qxlDriveIsReadOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.qxlDriveIsReadOnlyCheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.qxlDriveIsReadOnlyCheckBox);
        this.soundProblemCheckBox.setSelected(true);
        this.soundProblemCheckBox.setText("Sound problem");
        this.soundProblemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.soundProblemCheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.soundProblemCheckBox);
        this.flpReadOnlyCheckBoxMenuItem.setSelected(true);
        this.flpReadOnlyCheckBoxMenuItem.setText("Flp read only");
        this.flpReadOnlyCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.flpReadOnlyCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.flpReadOnlyCheckBoxMenuItem);
        this.nonexistingFlpFileCheckBoxMenuItem.setSelected(true);
        this.nonexistingFlpFileCheckBoxMenuItem.setText("jCheckBoxMenuItem1");
        this.nonexistingFlpFileCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.nonexistingFlpFileCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.warningsMenu.add(this.nonexistingFlpFileCheckBoxMenuItem);
        this.configMenu.add(this.warningsMenu);
        this.jMenuBar1.add(this.configMenu);
        this.jMenu3.setText("?");
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.aboutMenuItem);
        this.javaVersionMenuItem.setText("Java version");
        this.javaVersionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonitorGui.this.javaVersionMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.javaVersionMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void italianRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setLanguage(5);
        this.setOptionAndSave("LANGUAGE", "5");
    }

    private void screenUpdateRateMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, Localization.Texts[130] + "\n" + Localization.Texts[131] + this.screenUpdateRate, Localization.Texts[129], -1, null, null, "" + this.screenUpdateRate);
        if (string != null && !string.isEmpty()) {
            try {
                this.screenUpdateRate = Integer.parseInt(string);
                if (this.screenUpdateRate < 0) {
                    this.screenUpdateRate = 0;
                }
                if (this.screenUpdateRate > 65535) {
                    this.screenUpdateRate = 65535;
                }
                this.setOptionAndSave("SCREEN-UPDATE-RATE", string);
                this.monitor.setScreenUpdateInterval(this.screenUpdateRate);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, string + Localization.Texts[31], Localization.Texts[30], 0);
            }
        }
    }

    private void fullSizeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.windowMode = 1;
        this.setOptionAndSave("Window-MODE", "" + this.windowMode);
    }

    private void windowMenuItemActionPerformed(ActionEvent actionEvent) {
        this.windowMode = 0;
        this.setOptionAndSave("Window-MODE", "" + this.windowMode);
    }

    private void specialFullSizeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.windowMode = 2;
        this.setOptionAndSave("Window-MODE", "" + this.windowMode);
    }

    private void fullScreenMonitorMenuItemActionPerformed(ActionEvent actionEvent) {
        MultiMonitorDialog multiMonitorDialog = new MultiMonitorDialog((Frame)this, true, this.gds, this.currentMonitor);
        int n = multiMonitorDialog.getChoice();
        if (n != -1) {
            this.setOptionAndSave("SCREEN-NUMBER", "" + this.currentMonitor);
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void allowScreenEmulationjCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("QL-SCREEN-EMULATION", this.allowScreenEmulationjCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void unlockable2ReadOnlyCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("MAKE-UNLOCKABLE-QXLWIN-READONLY", this.unlockable2ReadOnlyCheckBoxMenuItem.isSelected() ? "1" : "0");
    }

    private void popupOpenWdwCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("POPUP-ACTION", "0");
    }

    private void popupBlinkCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("POPUP-ACTION", "1");
    }

    private void ssss20KHzCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("SSSS-FREQUENCY", "20");
    }

    private void ssss22KHzCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setOptionAndSave("SSSS-FREQUENCY", "22");
    }

    private void javaVersionMenuItemActionPerformed(ActionEvent actionEvent) {
        URL uRL = MonitorGui.class.getResource("images/combined.png");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            JOptionPane.showMessageDialog(this, " Java Version: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor"), "SMSQmulator ", 1, imageIcon);
        } else {
            JOptionPane.showMessageDialog(this, " Java Version: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor"), "SMSQmulator ", 1);
        }
    }

    private void mousewheelAccelItemActionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        String string = this.inifile.getOptionValue("MOUSEWHEEL-ACCEL");
        while (bl) {
            string = (String)JOptionPane.showInputDialog(this, Localization.Texts[148] + " (1 - 9)", Localization.Texts[148], -1, null, null, string);
            if (string == null || string.isEmpty()) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n <= 0 || n >= 10) continue;
                this.screen.setMousewheelAccel(n);
                this.setOptionAndSave("MOUSEWHEEL-ACCEL", "" + n);
                this.mousewheelAccelItem.setText(Localization.Texts[148] + ": " + n);
                bl = false;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, string + Localization.Texts[90], Localization.Texts[45], 0);
            }
        }
    }

    public void setScreenUpdateInterval(int n) {
        this.screenUpdateRate = n;
    }
}

