/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.DosFileAttributes;
import smsqmulator.Monitor;
import smsqmulator.XfaFileheader;
import smsqmulator.cpu.MC68000Cpu;

public class NfaFileheader
implements XfaFileheader {
    private final byte[] header = new byte[64];
    private int updateDate = 0;
    private boolean dateChanged = false;

    public NfaFileheader(File file, String string, int n) {
        int n2 = string.length() & 0xFF;
        if (n2 > 34) {
            n2 = 34;
        }
        this.header[15] = (byte)n2;
        for (int i = 0; i < n2; ++i) {
            this.header[16 + i] = (byte)string.charAt(i);
        }
        if (file.isDirectory()) {
            this.putIntW(4, 255);
            this.putIntL(0, n);
        } else {
            n2 = (int)file.length();
            this.putIntL(0, n2);
            n2 = (int)(file.lastModified() / 1000L) + Monitor.TIME_OFFSET;
            this.putIntL(52, n2);
        }
        this.header[4] = (byte)NfaFileheader.setAttrs(file);
    }

    private void putIntL(int n, int n2) {
        this.header[n] = (byte)(n2 >>> 24);
        this.header[n + 1] = (byte)(n2 >>> 16);
        this.header[n + 2] = (byte)(n2 >>> 8);
        this.header[n + 3] = (byte)n2;
    }

    private void putIntW(int n, int n2) {
        this.header[n] = (byte)(n2 >>> 8);
        this.header[n + 1] = (byte)n2;
    }

    private int getLong(int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            n2 |= this.header[n + i] & 0xFF;
            n2 <<= 8;
        }
        return n2 | this.header[n + 3] & 0xFF;
    }

    @Override
    public int readFileheader(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (n2 > 64) {
            n2 = 64;
        }
        for (int i = 0; i < n2; ++i) {
            mC68000Cpu.writeMemoryByte(n + i, this.header[i]);
        }
        return n2;
    }

    @Override
    public int writeFileHeader(MC68000Cpu mC68000Cpu, int n) {
        return 14;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public boolean flushHeader(FileChannel fileChannel, boolean bl) {
        return this.dateChanged;
    }

    @Override
    public String getSMSQEFilename() {
        int n = this.header[15];
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)this.header[16 + i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSMSQEFilename(String string) {
    }

    @Override
    public int getDate(int n) {
        return n == 0 ? this.getLong(52) : 0;
    }

    @Override
    public void setDate(int n, int n2) {
        if (n == 0) {
            this.updateDate = n2;
            this.dateChanged = true;
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void setVersion(int n) {
    }

    public void setLength(int n) {
        this.putIntL(0, n);
    }

    @Override
    public void setFileDates(File file) {
        long l = this.updateDate - Monitor.TIME_OFFSET;
        l = l < 0L ? 0L : (l *= 1000L);
        file.setLastModified(l);
    }

    public static final int setAttrs(File file) {
        int n = 0;
        try {
            DosFileAttributes dosFileAttributes = Files.readAttributes(file.toPath(), DosFileAttributes.class, new LinkOption[0]);
            if (dosFileAttributes.isArchive()) {
                n += 32;
            }
            if (dosFileAttributes.isSystem()) {
                n += 4;
            }
            if (dosFileAttributes.isReadOnly()) {
                ++n;
            }
            if (dosFileAttributes.isHidden()) {
                n += 2;
            }
            if (dosFileAttributes.isDirectory()) {
                n += 16;
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        return n;
    }
}

