/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import smsqmulator.ExternalInterruptHandler;
import smsqmulator.Screen;
import smsqmulator.cpu.MC68000Cpu;

public class QL50HzInterrupt
implements ExternalInterruptHandler {
    private InterruptThread iThread = null;
    private ScreenThread sThread = null;
    private MC68000Cpu cpu;
    private Screen screen;

    public QL50HzInterrupt(int n, MC68000Cpu mC68000Cpu, Screen screen) {
        this.cpu = mC68000Cpu;
        this.screen = screen;
        try {
            this.cpu.registerInterruptHandler(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handleExternalInterrupt(MC68000Cpu mC68000Cpu) {
    }

    public void startInterrruptHandler() {
        if (this.iThread != null) {
            this.iThread.stopit();
        }
        this.iThread = null;
        this.iThread = new InterruptThread(this.cpu);
        this.iThread.setName("50 Hz Interrupt");
        this.iThread.setDaemon(true);
        if (this.sThread != null) {
            this.sThread.stopit();
        }
        this.sThread = null;
        this.sThread = new ScreenThread(this.screen);
        this.sThread.setName("Screen updater");
        this.sThread.setDaemon(true);
        this.iThread.start();
        this.sThread.start();
    }

    public void stopInterruptHandler() {
        if (this.iThread != null) {
            this.iThread.stopit();
        }
        this.iThread = null;
        if (this.sThread != null) {
            this.sThread.setScreen(null);
            this.sThread.stopit();
        }
        this.sThread = null;
    }

    @Override
    public void removeHandler() {
        this.stopInterruptHandler();
        this.cpu = null;
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
        if (this.sThread != null) {
            this.sThread.setScreen(screen);
        }
    }

    public void setCpu(MC68000Cpu mC68000Cpu) {
        this.stopInterruptHandler();
        this.cpu = mC68000Cpu;
        try {
            this.cpu.registerInterruptHandler(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setScreenUpdateInterval(int n) {
        if (this.sThread != null) {
            this.sThread.setScreenUpdateInterval(n);
        }
    }

    private class ScreenThread
    extends Thread {
        private volatile boolean stopNow = false;
        private Screen screen;
        private volatile long interval = 40L;

        public ScreenThread(Screen screen) {
            this.screen = screen;
        }

        @Override
        public void run() {
            try {
                ScreenThread.sleep(1000L);
                while (!this.stopNow) {
                    ScreenThread.sleep(this.interval);
                    if (this.screen == null || !this.screen.isDirty) continue;
                    this.screen.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopit() {
            this.stopNow = true;
        }

        public void setScreen(Screen screen) {
            this.screen = screen;
        }

        public void setScreenUpdateInterval(int n) {
            this.interval = n;
        }
    }

    private class InterruptThread
    extends Thread {
        private volatile boolean stopNow = false;
        private final MC68000Cpu cpu;
        private static final int NOMINAL_CLOCK_TICK = 20;

        public InterruptThread(MC68000Cpu mC68000Cpu) {
            this.cpu = mC68000Cpu;
        }

        @Override
        public void run() {
            try {
                InterruptThread.sleep(1000L);
                while (!this.stopNow) {
                    InterruptThread.sleep(20L);
                    if (this.stopNow) continue;
                    this.cpu.generateInterrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopit() {
            this.stopNow = true;
        }
    }
}

