/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import smsqmulator.Monitor;
import smsqmulator.Types;
import smsqmulator.XfaFileheader;
import smsqmulator.cpu.MC68000Cpu;

public class QemuFileheader
implements XfaFileheader {
    private ByteBuffer header = ByteBuffer.allocate(68);
    private MC68000Cpu cpu;
    private int headerLength = 0;
    private ByteBuffer addInfo = null;
    private boolean dateChanged = false;

    public QemuFileheader(File file, String string, FileChannel fileChannel) throws IOException {
        long l = 0L;
        if (fileChannel != null) {
            l = fileChannel.size();
        }
        if (l != 0L) {
            int n;
            fileChannel.read(this.header);
            for (n = 0; n < 18; ++n) {
                if (this.header.get(n) == Types.QEMU[n]) continue;
                if (this.header.getInt(0) != 1397113136) {
                    throw new IOException();
                }
                for (int i = 4; i < 68; i += 4) {
                    this.header.putInt(n - 4, this.header.getInt(n));
                    this.headerLength = 68;
                }
                return;
            }
            this.headerLength = this.header.get(19) * 2;
            fileChannel.position(this.headerLength);
            if (this.headerLength > 30) {
                this.addInfo = ByteBuffer.allocate(14);
                for (n = 30; n < 44; ++n) {
                    this.addInfo.put(n - 30, this.header.get(n));
                }
            }
            for (n = 4; n < 14; ++n) {
                this.header.put(n, this.header.get(n + 16));
            }
            this.header.putInt(0, 1397113136);
            n = (int)file.length();
            this.header.putInt(0, n - this.headerLength);
            n = (int)(file.lastModified() / 1000L) + Monitor.TIME_OFFSET;
            this.header.putInt(52, n);
            this.header.putInt(60, n);
            this.header.putInt(56, 0);
        } else {
            if (file.isDirectory()) {
                throw new IOException();
            }
            this.header.putInt(0, 0);
            int n = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
            this.header.putInt(52, n);
            this.header.putShort(56, (short)0);
            this.header.putShort(58, (short)0);
            this.header.putInt(60, n);
            this.headerLength = 30;
            fileChannel.position(this.headerLength);
        }
        this.header.limit(this.header.capacity());
        this.header.position(0);
        this.setSMSQEFilename(string);
    }

    @Override
    public int readFileheader(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (n2 > 64) {
            n2 = 64;
        }
        for (int i = 0; i < n2; ++i) {
            mC68000Cpu.writeMemoryByte(n + i, this.header.get(i));
        }
        return n2;
    }

    @Override
    public int writeFileHeader(MC68000Cpu mC68000Cpu, int n) {
        for (int i = 0; i < 14; ++i) {
            this.header.put(i, (byte)(mC68000Cpu.readMemoryByte(n + i) & 0xFF));
        }
        return 14;
    }

    @Override
    public boolean flushHeader(FileChannel fileChannel, boolean bl) {
        if (fileChannel == null) {
            return false;
        }
        try {
            long l = fileChannel.position();
            fileChannel.position(0L);
            Types.QEMUBUF.position(0);
            fileChannel.write(Types.QEMUBUF);
            byte[] byArray = new byte[2];
            byArray[1] = (byte)(this.headerLength / 2);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            fileChannel.write(byteBuffer);
            this.header.position(4);
            this.header.limit(14);
            fileChannel.write(this.header);
            if (this.headerLength > 30) {
                fileChannel.write(this.addInfo);
            }
            this.header.position(0);
            this.header.limit(this.header.capacity());
            fileChannel.position(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.dateChanged;
    }

    @Override
    public int getOffset() {
        return this.headerLength;
    }

    @Override
    public String getSMSQEFilename() {
        int n = this.header.getShort(14);
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)this.header.get(16 + i));
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSMSQEFilename(String string) {
        int n = string.length() & 0xFF;
        if (n > 34) {
            n = 34;
        }
        this.header.putShort(14, (short)n);
        for (int i = 0; i < n; ++i) {
            this.header.put(16 + i, (byte)string.charAt(i));
        }
    }

    @Override
    public int getDate(int n) {
        return this.header.getInt(52 + 4 * n);
    }

    @Override
    public void setDate(int n, int n2) {
        this.header.putInt(52 + 4 * n, n2);
        if (n == 0) {
            this.dateChanged = true;
        }
    }

    @Override
    public int getVersion() {
        return this.header.getShort(56) & 0xFFFF;
    }

    @Override
    public void setVersion(int n) {
        this.header.putShort(56, (short)(n & 0xFFFF));
    }

    @Override
    public void setFileDates(File file) {
        long l = this.header.getInt(52) - Monitor.TIME_OFFSET;
        l = l < 0L ? 0L : (l *= 1000L);
        file.setLastModified(l);
    }
}

