/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import smsqmulator.Monitor;
import smsqmulator.Screen;
import smsqmulator.cpu.MC68000Cpu;

public class Screen0
extends Screen {
    private int nbrOfPixelsPerByte = 4;
    private boolean isQLScreen = true;

    public Screen0(int n, int n2, int n3, Monitor monitor, boolean bl) {
        super(n, n2, monitor, bl);
        this.mode = 0;
        this.makeScreen(n, n2, n3);
    }

    private void makeScreen(int n, int n2, int n3) {
        if (n == 512 && n2 == 256) {
            this.startAddress = 131072;
            this.stopAddress = 163838;
            this.nbrOfBytesPerLine = 128;
        } else {
            this.isQLScreen = false;
            this.stopAddress = n * n2 / this.nbrOfPixelsPerByte;
            this.nbrOfBytesPerLine = n / this.nbrOfPixelsPerByte;
            this.startAddress = n3;
            this.stopAddress = n3 + this.getScreenSizeInBytes();
        }
        this.fillScreen(0);
    }

    @Override
    public void writeByteToScreen(int n, int n2, int n3) {
        this.writeWordToScreen(n & 0xFFFFFFFE, n3);
    }

    @Override
    public void writeWordToScreen(int n, int n2) {
        if (n >= this.stopAddress) {
            return;
        }
        n2 &= 0xFFFF;
        int n3 = (n -= this.startAddress) / this.nbrOfBytesPerLine;
        int n4 = n - n3 * this.nbrOfBytesPerLine;
        n4 *= this.nbrOfPixelsPerByte;
        n3 *= this.xsize;
        switch (this.mode) {
            case 0: {
                n4 += 7;
                for (int i = 0; i < 8; ++i) {
                    int n5;
                    int n6 = (n2 & this.pixelmask4[i]) >>> i;
                    switch (n6) {
                        case 0: {
                            n5 = this.black;
                            break;
                        }
                        case 1: {
                            n5 = this.red;
                            break;
                        }
                        case 256: {
                            n5 = this.green;
                            break;
                        }
                        case 257: {
                            n5 = this.white;
                            break;
                        }
                        default: {
                            n5 = this.blue;
                        }
                    }
                    this.dataBuffer.setElem(n4 + n3, n5);
                    --n4;
                }
                this.isDirty = true;
                break;
            }
            case 8: {
                n4 += 3;
                for (int i = 0; i < 4; ++i) {
                    int n7;
                    int n8 = (n2 & this.pixelmask8[i]) >>> i * 2;
                    switch (n8) {
                        case 0: {
                            n7 = this.black;
                            break;
                        }
                        case 1: {
                            n7 = this.blue;
                            break;
                        }
                        case 2: {
                            n7 = this.red;
                            break;
                        }
                        case 3: {
                            n7 = this.magenta;
                            break;
                        }
                        case 512: {
                            n7 = this.green;
                            break;
                        }
                        case 513: {
                            n7 = this.cyan;
                            break;
                        }
                        case 514: {
                            n7 = this.yellow;
                            break;
                        }
                        case 515: {
                            n7 = this.white;
                            break;
                        }
                        default: {
                            n7 = this.orange;
                        }
                    }
                    if (n4 * 2 + 1 <= this.xsize) {
                        this.dataBuffer.setElem(n4 * 2 + n3, n7);
                        this.dataBuffer.setElem(n4 * 2 + n3 + 1, n7);
                    }
                    --n4;
                }
                this.isDirty = true;
            }
        }
    }

    @Override
    public void writeLongToScreen(int n, int n2) {
        this.writeWordToScreen(n, n2 >>> 16);
        this.writeWordToScreen(n + 2, n2);
    }

    @Override
    public void setMode(int n) {
        if (n != 0 && n != 8 || n == this.mode) {
            return;
        }
        this.mode = n;
        switch (n) {
            case 0: {
                this.nbrOfPixelsPerByte = 4;
                break;
            }
            case 8: {
                this.nbrOfPixelsPerByte = 2;
            }
        }
    }

    @Override
    public void clearScreen() {
        int[] nArray = new int[this.xsize * this.ysize];
        this.raster.setDataElements(0, 0, this.xsize, this.ysize, nArray);
        this.isDirty = true;
    }

    @Override
    public void fillBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        mC68000Cpu.data_regs[0] = -19;
        mC68000Cpu.reg_sr &= 0xFFFFFFFB;
    }

    @Override
    public void xorBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        mC68000Cpu.data_regs[0] = -4;
        mC68000Cpu.reg_sr &= 0xFFFFFFFB;
    }

    @Override
    public void combineBlocks(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.data_regs[0] = -19;
        mC68000Cpu.reg_sr &= 0xFFFFFFFB;
    }

    @Override
    public void moveBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        mC68000Cpu.data_regs[0] = -19;
        mC68000Cpu.reg_sr &= 0xFFFFFFFB;
    }

    @Override
    public void displayRegion(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (this.stopAddress < n + n2) {
            n2 -= n + n2 - this.stopAddress;
        }
        if (n < this.startAddress) {
            n2 -= this.startAddress - n;
            n = this.startAddress;
        }
        if (n2 < 1) {
            return;
        }
        n2 /= 2;
        n -= this.startAddress;
        n &= 0xFFFFFFFE;
        short[] sArray = mC68000Cpu.getMemory();
        int n3 = this.nbrOfPixelsPerByte;
        for (int i = 0; i < n2; i += n3) {
            this.paintPixels(n + i, sArray);
        }
        this.isDirty = true;
    }

    private void paintPixels(int n, short[] sArray) {
        int n2 = n / 2;
        short s = sArray[n2];
        int n3 = n / this.nbrOfBytesPerLine;
        int n4 = n - n3 * this.nbrOfBytesPerLine;
        this.setPixels(n4 *= this.nbrOfPixelsPerByte, n3, s, this.mode);
    }

    @Override
    public synchronized void setVramBase(int n) {
        if (!this.isQLScreen) {
            this.startAddress = n;
            this.stopAddress = n + this.getScreenSizeInBytes();
        }
    }

    @Override
    public void setVibrantColours(boolean bl, short[] sArray) {
    }

    @Override
    public final int getScreenSizeInBytes() {
        return this.xsize * this.ysize / this.nbrOfPixelsPerByte;
    }

    @Override
    public boolean isQLScreen() {
        return this.isQLScreen;
    }
}

